/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.jaxws.ri;

import javax.xml.soap.MessageFactory;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.jaxws.JAXWSBindingInvoker;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;
import org.w3c.dom.Node;

public class JAXWSReferenceBindingProvider
implements ReferenceBindingProvider {
    private MessageFactory messageFactory;
    private WebServiceBinding wsBinding;
    private RuntimeEndpointReference endpointReference;

    public JAXWSReferenceBindingProvider(RuntimeEndpointReference endpointReference, FactoryExtensionPoint modelFactories, DataBindingExtensionPoint dataBindings) {
        this.endpointReference = endpointReference;
        this.messageFactory = (MessageFactory)modelFactories.getFactory(MessageFactory.class);
        this.wsBinding = (WebServiceBinding)endpointReference.getBinding();
        if (this.wsBinding.getGeneratedWSDLDocument() == null) {
            throw new ServiceRuntimeException("No WSDL document for " + endpointReference.getURI());
        }
        InterfaceContract contract = this.wsBinding.getBindingInterfaceContract();
        if (contract.getInterface() != null) {
            contract.getInterface().resetDataBinding(Node.class.getName());
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.wsBinding.getBindingInterfaceContract();
    }

    public boolean supportsOneWayInvocation() {
        return true;
    }

    public Invoker createInvoker(Operation operation) {
        return new JAXWSBindingInvoker(operation, null, this.messageFactory, this.wsBinding, this.endpointReference);
    }
}

