/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.wireformat.xml.provider;

import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.binding.rest.RESTBinding;
import org.apache.tuscany.sca.binding.rest.wireformat.xml.XMLWireFormat;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class XMLWireFormatInterceptor
implements Interceptor {
    private XMLInputFactory inputFactory;
    private Invoker next;
    private RESTBinding binding;

    public XMLWireFormatInterceptor(ExtensionPointRegistry extensionPoints, RuntimeEndpoint endpoint) {
        FactoryExtensionPoint factories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.inputFactory = (XMLInputFactory)factories.getFactory(XMLInputFactory.class);
        this.binding = (RESTBinding)endpoint.getBinding();
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message invoke(Message msg) {
        Operation operation;
        HTTPContext bindingContext = (HTTPContext)msg.getBindingContext();
        if (bindingContext == null) {
            return this.getNext().invoke(msg);
        }
        if (this.binding.getRequestWireFormat() instanceof XMLWireFormat && XMLWireFormatInterceptor.isPayloadSupported(bindingContext.getHttpRequest().getMethod()) && msg.getBody() != null) {
            msg = this.invokeRequest(bindingContext, msg);
        }
        if ((operation = (msg = this.getNext().invoke(msg)).getOperation()) != null && operation.isNonBlocking()) {
            return msg;
        }
        if (this.binding.getResponseWireFormat() instanceof XMLWireFormat) {
            msg = this.invokeResponse(bindingContext, msg);
        }
        return msg;
    }

    private Message invokeRequest(HTTPContext bindingContext, Message msg) {
        String charset = bindingContext.getHttpRequest().getCharacterEncoding();
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            if (msg.getBody() != null) {
                Object[] args = (Object[])msg.getBody();
                InputStream data = (InputStream)args[0];
                XMLStreamReader xmlPayload = this.inputFactory.createXMLStreamReader(data, charset);
                msg.setBody((Object)new Object[]{xmlPayload});
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to process xml paylod: " + msg.getBody().toString());
        }
        return msg;
    }

    private Message invokeResponse(HTTPContext bindingContext, Message msg) {
        return msg;
    }

    private static boolean isPayloadSupported(String operation) {
        boolean isGet = "get".equalsIgnoreCase(operation);
        boolean isDelete = "delete".equalsIgnoreCase(operation);
        return !isGet && !isDelete;
    }
}

