/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.wireformat.json.provider;

import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.rest.provider.JAXRSHelper;
import org.apache.tuscany.sca.binding.rest.wireformat.json.JSONWireFormat;
import org.apache.tuscany.sca.binding.rest.wireformat.json.provider.JSONWireFormatInterceptor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class JSONWireFormatServiceProvider
implements WireFormatProvider {
    private ExtensionPointRegistry extensionPoints;
    private RuntimeEndpoint endpoint;
    private InterfaceContract serviceContract;
    private Binding binding;
    private boolean jaxrs;

    public JSONWireFormatServiceProvider(ExtensionPointRegistry extensionPoints, RuntimeEndpoint endpoint) {
        this.extensionPoints = extensionPoints;
        this.endpoint = endpoint;
        this.binding = endpoint.getBinding();
        this.jaxrs = this.isJAXRSResource();
    }

    private boolean isJAXRSResource() {
        Interface interfaze = this.endpoint.getComponentServiceInterfaceContract().getInterface();
        return interfaze instanceof JavaInterface && JAXRSHelper.isJAXRSResource(((JavaInterface)interfaze).getJavaClass());
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        this.serviceContract = interfaceContract;
        if (!this.jaxrs) {
            boolean configureInput = this.binding.getRequestWireFormat() != null;
            boolean configureOutput = this.binding.getRequestWireFormat() != null || this.binding.getResponseWireFormat() != null;
            this.setDataBinding(this.serviceContract.getInterface(), configureInput, configureOutput);
        }
        return this.serviceContract;
    }

    public Interceptor createInterceptor() {
        if (this.jaxrs) {
            return null;
        }
        if (this.binding.getRequestWireFormat() != null && this.binding.getRequestWireFormat() instanceof JSONWireFormat || this.binding.getResponseWireFormat() != null && this.binding.getResponseWireFormat() instanceof JSONWireFormat) {
            return new JSONWireFormatInterceptor(this.extensionPoints, this.endpoint);
        }
        return null;
    }

    public String getPhase() {
        return "service.binding.wireformat";
    }

    private void setDataBinding(Interface interfaze, boolean configureInput, boolean configureOutput) {
        List operations = interfaze.getOperations();
        for (Operation operation : operations) {
            if (configureInput) {
                operation.setDataBinding("JSON");
                DataType inputType = operation.getInputType();
                if (inputType != null) {
                    List logical = (List)inputType.getLogical();
                    for (DataType inArg : logical) {
                        if ("java:simpleType".equals(inArg.getDataBinding())) continue;
                        inArg.setDataBinding("JSON");
                    }
                }
            }
            if (!configureOutput) continue;
            List outputTypes = (List)operation.getOutputType().getLogical();
            for (DataType outputType : outputTypes) {
                if (outputType == null || "java:simpleType".equals(outputType.getDataBinding())) continue;
                outputType.setDataBinding("JSON");
            }
        }
    }
}

