/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.wireformat.json.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import org.apache.tuscany.sca.binding.rest.RESTBinding;
import org.apache.tuscany.sca.binding.rest.wireformat.json.JSONWireFormat;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.json.JSONObject;

public class JSONWireFormatInterceptor
implements Interceptor {
    private Invoker next;
    private RESTBinding binding;

    public JSONWireFormatInterceptor(ExtensionPointRegistry extensionPoints, RuntimeEndpoint endpoint) {
        this.binding = (RESTBinding)endpoint.getBinding();
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message invoke(Message msg) {
        Operation operation;
        HTTPContext bindingContext = (HTTPContext)msg.getBindingContext();
        if (bindingContext == null) {
            return this.getNext().invoke(msg);
        }
        if (this.binding.getRequestWireFormat() instanceof JSONWireFormat && JSONWireFormatInterceptor.isPayloadSupported(bindingContext.getHttpRequest().getMethod()) && msg.getBody() != null) {
            msg = this.invokeRequest(bindingContext, msg);
        }
        if ((operation = (msg = this.getNext().invoke(msg)).getOperation()) != null && operation.isNonBlocking()) {
            return msg;
        }
        if (this.binding.getResponseWireFormat() instanceof JSONWireFormat) {
            msg = this.invokeResponse(bindingContext, msg);
        }
        return msg;
    }

    private Message invokeRequest(HTTPContext bindingContext, Message msg) {
        String charset = bindingContext.getHttpRequest().getCharacterEncoding();
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            Object[] args = (Object[])msg.getBody();
            InputStream in = (InputStream)args[0];
            String data = JSONWireFormatInterceptor.read(in, charset);
            JSONObject jsonPayload = new JSONObject(data);
            msg.setBody((Object)new Object[]{jsonPayload});
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse json paylod: " + msg.getBody().toString());
        }
        return msg;
    }

    private Message invokeResponse(HTTPContext bindingContext, Message msg) {
        return msg;
    }

    private static boolean isPayloadSupported(String operation) {
        boolean isGet = "get".equalsIgnoreCase(operation);
        boolean isDelete = "delete".equalsIgnoreCase(operation);
        return !isGet && !isDelete;
    }

    private static String read(InputStream in, String charset) throws IOException {
        int size;
        StringWriter sw = new StringWriter();
        InputStreamReader reader = new InputStreamReader(in, "UTF-8");
        char[] buf = new char[8192];
        while ((size = reader.read(buf)) >= 0) {
            sw.write(buf, 0, size);
        }
        return sw.toString();
    }
}

