/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.rest.RESTBinding;
import org.apache.tuscany.sca.binding.rest.provider.DataBindingJAXRSReader;
import org.apache.tuscany.sca.binding.rest.provider.DataBindingJAXRSWriter;
import org.apache.tuscany.sca.binding.rest.provider.ThreadBindingContext;
import org.apache.tuscany.sca.common.http.HTTPCacheContext;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.common.http.HTTPHeader;
import org.apache.tuscany.sca.common.http.ThreadHTTPContext;
import org.apache.tuscany.sca.common.http.cors.CORSConfiguration;
import org.apache.tuscany.sca.common.http.cors.CORSHeaderProcessor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ClassLoaderContext;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.model.wadl.Application;
import org.apache.wink.common.model.wadl.WADLGenerator;
import org.apache.wink.server.handlers.HandlersChain;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.handlers.ResponseHandler;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.apache.wink.server.internal.servlet.RestServlet;

public class TuscanyRESTServlet
extends RestServlet {
    private static final long serialVersionUID = 89997233133964915L;
    private static final Logger logger = Logger.getLogger(TuscanyRESTServlet.class.getName());
    private static final Annotation[] annotations = new Annotation[0];
    private ExtensionPointRegistry registry;
    private RESTBinding binding;
    private Class<?> resourceClass;

    public TuscanyRESTServlet(ExtensionPointRegistry registry, Binding binding, Class<?> resourceClass) {
        this.registry = registry;
        this.binding = (RESTBinding)binding;
        this.resourceClass = resourceClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.binding.isCORS()) {
            CORSHeaderProcessor.processCORS((CORSConfiguration)this.binding.getCORSConfiguration(), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        HTTPContext bindingContext = new HTTPContext();
        bindingContext.setHttpRequest(request);
        bindingContext.setHttpResponse(response);
        try {
            ThreadHTTPContext.setHTTPContext((HTTPContext)bindingContext);
            ThreadBindingContext.setBindingContext(this.binding);
            String query = request.getQueryString();
            if (query != null && query.indexOf("wadl") >= 0) {
                this.handleWadlRequest(request, response);
            } else {
                super.service(request, response);
            }
        }
        finally {
            ThreadHTTPContext.removeHTTPContext();
            ThreadBindingContext.removeBindingContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        ClassLoader cl = ClassLoaderContext.setContextClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader(), (ServiceDiscovery)this.registry.getServiceDiscovery(), (String[])new String[]{"/META-INF/server/wink-providers", "javax.ws.rs.ext.RuntimeDelegate"});
        try {
            super.init();
        }
        finally {
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentConfiguration getDeploymentConfiguration() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        DeploymentConfiguration config = (DeploymentConfiguration)this.getServletContext().getAttribute(DeploymentConfiguration.class.getName());
        if (config != null) {
            return config;
        }
        ClassLoader cl = ClassLoaderContext.setContextClassLoader((ClassLoader)Thread.currentThread().getContextClassLoader(), (ServiceDiscovery)this.registry.getServiceDiscovery(), (String[])new String[]{"javax.ws.rs.ext.RuntimeDelegate", "/META-INF/wink-alternate-shortcuts.properties", "/META-INF/server/wink-providers"});
        try {
            config = super.getDeploymentConfiguration();
            this.getServletContext().setAttribute(DeploymentConfiguration.class.getName(), (Object)config);
        }
        finally {
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        config.setFilterConfig(new FilterConfig(){

            public ServletContext getServletContext() {
                return TuscanyRESTServlet.this.getServletContext();
            }

            public Enumeration getInitParameterNames() {
                return TuscanyRESTServlet.this.getInitParameterNames();
            }

            public String getInitParameter(String p) {
                return TuscanyRESTServlet.this.getInitParameter(p);
            }

            public String getFilterName() {
                return TuscanyRESTServlet.this.getServletName();
            }
        });
        ProvidersRegistry providers = config.getProvidersRegistry();
        providers.addProvider(new DataBindingJAXRSReader(this.registry), 0.2, true);
        providers.addProvider(new DataBindingJAXRSWriter(this.registry), 0.2, true);
        config.getResponseUserHandlers().add(new TuscanyResponseHandler());
        return config;
    }

    private void handleWadlRequest(HttpServletRequest request, HttpServletResponse response) {
        try {
            Application wadlDocument = null;
            WADLGenerator generator = new WADLGenerator();
            HashSet classes = new HashSet();
            classes.add(this.resourceClass);
            wadlDocument = generator.generate(this.binding.getURI(), classes);
            MessageBodyWriter writer = this.getDeploymentConfiguration().getProvidersRegistry().getMessageBodyWriter(Application.class, Application.class, annotations, MediaType.APPLICATION_XML_TYPE, null);
            writer.writeTo((Object)wadlDocument, Application.class, Application.class, annotations, MediaType.APPLICATION_XML_TYPE, null, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class TuscanyResponseHandler
    implements ResponseHandler {
        TuscanyResponseHandler() {
        }

        public void handleResponse(MessageContext context, HandlersChain chain) throws Throwable {
            HttpServletResponse httpResponse = (HttpServletResponse)context.getAttribute(HttpServletResponse.class);
            if (httpResponse.isCommitted()) {
                logger.log(Level.FINE, "The response is already committed. Nothing to do.");
                return;
            }
            RESTBinding binding = ThreadBindingContext.getBindingContext();
            for (HTTPHeader header : binding.getHttpHeaders()) {
                if (header.getName().equalsIgnoreCase("Expires")) {
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.setTime(new Date());
                    calendar.add(10, Integer.parseInt(header.getValue()));
                    httpResponse.setHeader("Expires", HTTPCacheContext.RFC822DateFormat.format(calendar.getTime()));
                    continue;
                }
                httpResponse.setHeader(header.getName(), header.getValue());
            }
            chain.doChain(context);
        }

        public void init(Properties props) {
        }
    }
}

