/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.provider;

import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.rest.RESTBinding;
import org.apache.tuscany.sca.common.http.HTTPCacheContext;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.common.http.HTTPHeader;
import org.apache.tuscany.sca.common.http.ThreadHTTPContext;
import org.apache.tuscany.sca.common.http.cors.CORSConfiguration;
import org.apache.tuscany.sca.common.http.cors.CORSHeaderProcessor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;

public class RESTServiceListenerServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = -5543706958107836637L;
    private transient RESTBinding binding;
    private transient ServletConfig config;
    private transient MessageFactory messageFactory;
    private transient Invoker serviceInvoker;

    public RESTServiceListenerServlet(Binding binding, Invoker serviceInvoker, MessageFactory messageFactory) {
        this.binding = (RESTBinding)binding;
        this.serviceInvoker = serviceInvoker;
        this.messageFactory = messageFactory;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public String getServletInfo() {
        return "";
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.binding.isCORS()) {
            CORSHeaderProcessor.processCORS((CORSConfiguration)this.binding.getCORSConfiguration(), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        HTTPContext bindingContext = new HTTPContext();
        bindingContext.setHttpRequest(request);
        bindingContext.setHttpResponse(response);
        ThreadHTTPContext.setHTTPContext((HTTPContext)bindingContext);
        try {
            Message requestMessage = this.messageFactory.createMessage();
            requestMessage.setBindingContext((Object)bindingContext);
            requestMessage.setBody((Object)new Object[]{request, response});
            Message responseMessage = this.serviceInvoker.invoke(requestMessage);
            if (responseMessage.isFault()) {
                Throwable e = (Throwable)responseMessage.getBody();
                response.sendError(500, e.toString());
            } else {
                for (HTTPHeader header : this.binding.getHttpHeaders()) {
                    if (header.getName().equalsIgnoreCase("Expires")) {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime(new Date());
                        calendar.add(10, Integer.parseInt(header.getValue()));
                        response.setHeader("Expires", HTTPCacheContext.RFC822DateFormat.format(calendar.getTime()));
                        continue;
                    }
                    response.setHeader(header.getName(), header.getValue());
                }
            }
        }
        finally {
            ThreadHTTPContext.removeHTTPContext();
        }
    }
}

