/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.provider;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.rest.RESTBinding;
import org.apache.tuscany.sca.binding.rest.provider.JAXRSHelper;
import org.apache.tuscany.sca.binding.rest.provider.RESTBindingListenerServlet;
import org.apache.tuscany.sca.binding.rest.provider.RESTServiceListenerServlet;
import org.apache.tuscany.sca.binding.rest.provider.TuscanyRESTServlet;
import org.apache.tuscany.sca.binding.rest.wireformat.json.JSONWireFormat;
import org.apache.tuscany.sca.binding.rest.wireformat.xml.XMLWireFormat;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.jaxrs.RootResourceClassGenerator;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.EndpointProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProvider;
import org.apache.tuscany.sca.provider.OperationSelectorProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.provider.WireFormatProviderFactory;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.wink.server.utils.RegistrationUtils;
import org.oasisopen.sca.ServiceRuntimeException;

public class RESTServiceBindingProvider
implements EndpointProvider {
    private static Map<QName, String> wireFormatToMediaTypeMapping = new HashMap<QName, String>();
    private ExtensionPointRegistry extensionPoints;
    private RuntimeEndpoint endpoint;
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private InterfaceContract serviceContract;
    private RESTBinding binding;
    private MessageFactory messageFactory;
    private OperationSelectorProvider osProvider;
    private WireFormatProvider wfProvider;
    private WireFormatProvider wfResponseProvider;
    private ServletHost servletHost;
    private String servletMapping;
    private RESTBindingListenerServlet bindingListenerServlet;
    private SimpleApplication application;

    public RESTServiceBindingProvider(RuntimeEndpoint endpoint, ExtensionPointRegistry extensionPoints, MessageFactory messageFactory, ServletHost servletHost) {
        WireFormatProviderFactory wfProviderFactory;
        OperationSelectorProviderFactory osProviderFactory;
        this.endpoint = endpoint;
        this.component = (RuntimeComponent)endpoint.getComponent();
        this.service = (RuntimeComponentService)endpoint.getService();
        this.binding = (RESTBinding)endpoint.getBinding();
        this.extensionPoints = extensionPoints;
        this.messageFactory = messageFactory;
        this.servletHost = servletHost;
        ProviderFactoryExtensionPoint providerFactories = (ProviderFactoryExtensionPoint)extensionPoints.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        if (this.binding.getOperationSelector() != null && (osProviderFactory = (OperationSelectorProviderFactory)providerFactories.getProviderFactory(this.binding.getOperationSelector().getClass())) != null) {
            this.osProvider = osProviderFactory.createServiceOperationSelectorProvider(endpoint);
        }
        if (this.binding.getRequestWireFormat() != null && (wfProviderFactory = (WireFormatProviderFactory)providerFactories.getProviderFactory(this.binding.getRequestWireFormat().getClass())) != null) {
            this.wfProvider = wfProviderFactory.createServiceWireFormatProvider(endpoint);
        }
        if (this.binding.getResponseWireFormat() != null && (wfProviderFactory = (WireFormatProviderFactory)providerFactories.getProviderFactory(this.binding.getResponseWireFormat().getClass())) != null) {
            this.wfResponseProvider = wfProviderFactory.createServiceWireFormatProvider(endpoint);
        }
        try {
            this.serviceContract = (InterfaceContract)this.service.getInterfaceContract().clone();
            if (this.wfProvider != null) {
                this.wfProvider.configureWireFormatInterfaceContract(this.serviceContract);
            }
            if (this.wfResponseProvider != null) {
                this.wfResponseProvider.configureWireFormatInterfaceContract(this.serviceContract);
            }
        }
        catch (CloneNotSupportedException e) {
            this.serviceContract = this.service.getInterfaceContract();
        }
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.serviceContract;
    }

    public void configure() {
        Interceptor interceptor;
        InvocationChain bindingChain = this.endpoint.getBindingInvocationChain();
        if (this.wfProvider != null && (interceptor = this.wfProvider.createInterceptor()) != null) {
            bindingChain.addInterceptor("service.binding.wireformat", interceptor);
        }
        if (this.wfResponseProvider != null && (interceptor = this.wfResponseProvider.createInterceptor()) != null) {
            bindingChain.addInterceptor("service.binding.wireformat", interceptor);
        }
        if (this.osProvider != null && (interceptor = this.osProvider.createInterceptor()) != null) {
            bindingChain.addInterceptor("service.binding.operationselector", interceptor);
        }
    }

    public void start() {
        InvocationChain bindingChain = this.endpoint.getBindingInvocationChain();
        this.application = this.registerWithJAXRS();
        if (this.application != null) {
            return;
        }
        HttpServlet servlet = null;
        Invoker bindingInvoker = bindingChain.getHeadInvoker();
        this.bindingListenerServlet = new RESTBindingListenerServlet((Binding)this.binding, bindingInvoker, this.messageFactory);
        for (InvocationChain invocationChain : this.endpoint.getInvocationChains()) {
            Operation operation = invocationChain.getTargetOperation();
            Invoker serviceInvoker = invocationChain.getHeadInvoker();
            String operationName = operation.getName();
            if (this.binding.getOperationSelector() != null || this.binding.getRequestWireFormat() != null) {
                this.bindingListenerServlet.setInvoker(serviceInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("get")) {
                this.bindingListenerServlet.setGetInvoker(serviceInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalGet")) {
                this.bindingListenerServlet.setConditionalGetInvoker(serviceInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("delete")) {
                this.bindingListenerServlet.setDeleteInvoker(serviceInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalDelete")) {
                this.bindingListenerServlet.setConditionalDeleteInvoker(serviceInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("put")) {
                this.bindingListenerServlet.setPutInvoker(serviceInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalPut")) {
                this.bindingListenerServlet.setConditionalPutInvoker(serviceInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("post")) {
                this.bindingListenerServlet.setPostInvoker(serviceInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (operationName.equals("conditionalPost")) {
                this.bindingListenerServlet.setConditionalPostInvoker(serviceInvoker);
                servlet = this.bindingListenerServlet;
                continue;
            }
            if (!operationName.equals("service")) continue;
            servlet = new RESTServiceListenerServlet((Binding)this.binding, serviceInvoker, this.messageFactory);
            break;
        }
        if (servlet == null) {
            throw new IllegalStateException("No get or service method found on the service");
        }
        this.servletMapping = this.registerServlet((Servlet)servlet);
    }

    public void stop() {
        if (this.application != null) {
            this.application.destroy();
        }
        this.servletHost.removeServletMapping(this.servletMapping);
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    private String registerServlet(Servlet servlet) {
        String mappedURI;
        String deployedURI;
        String servletMapping = this.binding.getURI();
        if (!servletMapping.endsWith("/")) {
            servletMapping = servletMapping + "/";
        }
        if (!servletMapping.endsWith("*")) {
            servletMapping = servletMapping + "*";
        }
        if ((deployedURI = (mappedURI = this.servletHost.addServletMapping(servletMapping, servlet))).endsWith("*")) {
            deployedURI = deployedURI.substring(0, deployedURI.length() - 1);
        }
        this.binding.setURI(deployedURI);
        this.endpoint.setDeployedURI(deployedURI);
        return mappedURI;
    }

    private SimpleApplication registerWithJAXRS() {
        try {
            SimpleApplication application = null;
            JavaInterface javaInterface = (JavaInterface)this.endpoint.getComponentServiceInterfaceContract().getInterface();
            Class interfaze = javaInterface.getJavaClass();
            boolean isJAXRS = JAXRSHelper.isJAXRSResource(interfaze);
            if (isJAXRS) {
                application = new SimpleApplication(interfaze);
                TuscanyRESTServlet restServlet = new TuscanyRESTServlet(this.extensionPoints, (Binding)this.binding, application.resourceClass);
                this.servletMapping = this.registerServlet((Servlet)restServlet);
                RegistrationUtils.registerApplication((Application)application, (ServletContext)restServlet.getServletContext());
                return application;
            }
            return null;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException((Throwable)e);
        }
    }

    static {
        wireFormatToMediaTypeMapping.put(JSONWireFormat.REST_WIREFORMAT_JSON_QNAME, "application/json");
        wireFormatToMediaTypeMapping.put(XMLWireFormat.REST_WIREFORMAT_XML_QNAME, "application/xml");
    }

    private class SimpleApplication
    extends Application {
        private Class<?> resourceClass;

        public SimpleApplication(Class<?> resourceClass) {
            this.resourceClass = resourceClass.isInterface() ? this.generateResourceClass(resourceClass) : resourceClass;
        }

        public Set<Class<?>> getClasses() {
            HashSet classes = new HashSet();
            classes.add(this.resourceClass);
            return classes;
        }

        private Class<?> generateResourceClass(Class<?> interfaze) {
            try {
                Path p;
                String cp;
                QName requestWireFormat = null;
                if (RESTServiceBindingProvider.this.binding.getRequestWireFormat() != null) {
                    requestWireFormat = RESTServiceBindingProvider.this.binding.getRequestWireFormat().getSchemaName();
                }
                QName responeWireFormat = null;
                if (RESTServiceBindingProvider.this.binding.getResponseWireFormat() != null) {
                    responeWireFormat = RESTServiceBindingProvider.this.binding.getRequestWireFormat().getSchemaName();
                }
                String requestMediaType = (String)wireFormatToMediaTypeMapping.get(requestWireFormat);
                String responseMediaType = (String)wireFormatToMediaTypeMapping.get(responeWireFormat);
                String uri = RESTServiceBindingProvider.this.endpoint.getBinding().getURI();
                String path = URI.create(uri).getPath();
                if (path.startsWith(RESTServiceBindingProvider.this.servletHost.getContextPath())) {
                    path = path.substring(RESTServiceBindingProvider.this.servletHost.getContextPath().length());
                }
                String string = cp = (p = interfaze.getAnnotation(Path.class)) == null ? "" : p.value().trim();
                if (cp.startsWith("/")) {
                    cp = cp.substring(1);
                }
                if (!"".equals(cp)) {
                    path = path + "/" + cp;
                }
                Class cls = RootResourceClassGenerator.generateRootResourceClass(interfaze, (String)path, (String)requestMediaType, (String)responseMediaType);
                ExtensibleProxyFactory proxyFactory = ExtensibleProxyFactory.getInstance((ExtensionPointRegistry)RESTServiceBindingProvider.this.extensionPoints);
                Object proxy = proxyFactory.createProxy(interfaze, (Invocable)RESTServiceBindingProvider.this.endpoint);
                RootResourceClassGenerator.injectProxy((Class)cls, (Object)proxy);
                return cls;
            }
            catch (Exception e) {
                throw new ServiceRuntimeException((Throwable)e);
            }
        }

        public void destroy() {
            this.resourceClass = null;
        }
    }
}

