/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.rest.RESTBinding;
import org.apache.tuscany.sca.common.http.HTTPCacheContext;
import org.apache.tuscany.sca.common.http.HTTPContentTypeMapper;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.common.http.HTTPHeader;
import org.apache.tuscany.sca.common.http.ThreadHTTPContext;
import org.apache.tuscany.sca.common.http.cors.CORSConfiguration;
import org.apache.tuscany.sca.common.http.cors.CORSHeaderProcessor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;

public class RESTBindingListenerServlet
extends HttpServlet {
    private static final long serialVersionUID = 2865466417329430610L;
    private transient MessageFactory messageFactory;
    private transient RESTBinding binding;
    private transient Invoker bindingInvoker;
    private Invoker invoker;
    private Invoker getInvoker;
    private Invoker conditionalGetInvoker;
    private Invoker putInvoker;
    private Invoker conditionalPutInvoker;
    private Invoker postInvoker;
    private Invoker conditionalPostInvoker;
    private Invoker deleteInvoker;
    private Invoker conditionalDeleteInvoker;

    public RESTBindingListenerServlet(Binding binding, Invoker bindingInvoker, MessageFactory messageFactory) {
        this.binding = (RESTBinding)binding;
        this.bindingInvoker = bindingInvoker;
        this.messageFactory = messageFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.binding.isCORS()) {
            CORSHeaderProcessor.processCORS((CORSConfiguration)this.binding.getCORSConfiguration(), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        HTTPContext bindingContext = new HTTPContext();
        bindingContext.setHttpRequest(request);
        bindingContext.setHttpResponse(response);
        ThreadHTTPContext.setHTTPContext((HTTPContext)bindingContext);
        try {
            if (this.binding.getOperationSelector() != null || this.binding.getRequestWireFormat() != null) {
                Message requestMessage = this.messageFactory.createMessage();
                requestMessage.setBindingContext((Object)bindingContext);
                requestMessage.setBody((Object)new Object[]{request.getInputStream()});
                Message responseMessage = this.bindingInvoker.invoke(requestMessage);
                if (responseMessage.isFault()) {
                    Throwable e = (Throwable)responseMessage.getBody();
                    response.sendError(500, e.toString());
                } else {
                    for (HTTPHeader header : this.binding.getHttpHeaders()) {
                        if (header.getName().equalsIgnoreCase("Expires")) {
                            GregorianCalendar calendar = new GregorianCalendar();
                            calendar.setTime(new Date());
                            calendar.add(10, Integer.parseInt(header.getValue()));
                            response.setHeader("Expires", HTTPCacheContext.RFC822DateFormat.format(calendar.getTime()));
                            continue;
                        }
                        response.setHeader(header.getName(), header.getValue());
                    }
                    this.write((OutputStream)response.getOutputStream(), responseMessage.getBody());
                    response.getOutputStream().flush();
                    response.getOutputStream().close();
                }
            } else {
                super.service(request, response);
            }
        }
        finally {
            ThreadHTTPContext.removeHTTPContext();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int n;
        String contentType;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.length() == 0) {
            response.sendRedirect(request.getRequestURL().append('/').toString());
            return;
        }
        String path = URLDecoder.decode(pathInfo, "UTF-8");
        Message requestMessage = this.messageFactory.createMessage();
        String id = path.substring(1);
        Message responseMessage = null;
        HTTPCacheContext cacheContext = null;
        try {
            cacheContext = HTTPCacheContext.createCacheContextFromRequest((HttpServletRequest)request);
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (cacheContext != null && cacheContext.isEnabled() && this.conditionalGetInvoker != null) {
            if (id != null && id.length() > 0) {
                requestMessage.setBody((Object)new Object[]{id, cacheContext});
            } else {
                requestMessage.setBody((Object)new Object[]{cacheContext});
            }
            responseMessage = this.conditionalGetInvoker.invoke(requestMessage);
        } else {
            if (id != null && id.length() > 0) {
                requestMessage.setBody((Object)new Object[]{id});
            }
            responseMessage = this.getInvoker.invoke(requestMessage);
        }
        if (responseMessage.isFault()) {
            Object body = responseMessage.getBody();
            int index = -1;
            index = body.getClass().getName().indexOf("NotModifiedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(304, body.toString().substring(index));
                } else {
                    response.sendError(304);
                }
                return;
            }
            index = body.getClass().getName().indexOf("PreconditionFailedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(412, body.toString().substring(index));
                } else {
                    response.sendError(412);
                }
                return;
            }
            throw new ServletException((Throwable)responseMessage.getBody());
        }
        if ((response.getContentType() == null || response.getContentType().length() == 0) && (contentType = HTTPContentTypeMapper.getContentType((String)id)) != null && contentType.length() > 0) {
            response.setContentType(contentType);
        }
        InputStream is = (InputStream)responseMessage.getBody();
        ServletOutputStream os = response.getOutputStream();
        byte[] buffer = new byte[2048];
        while ((n = is.read(buffer)) > 0) {
            os.write(buffer, 0, n);
        }
        os.flush();
        os.close();
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int n;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        if (path.length() == 0) {
            response.sendRedirect(request.getRequestURL().append('/').toString());
            return;
        }
        Message requestMessage = this.messageFactory.createMessage();
        String id = path.substring(1);
        Message responseMessage = null;
        HTTPCacheContext cacheContext = null;
        try {
            cacheContext = HTTPCacheContext.createCacheContextFromRequest((HttpServletRequest)request);
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (cacheContext != null && cacheContext.isEnabled() && this.conditionalDeleteInvoker != null) {
            requestMessage.setBody((Object)new Object[]{id, cacheContext});
            responseMessage = this.conditionalDeleteInvoker.invoke(requestMessage);
        } else {
            requestMessage.setBody((Object)new Object[]{id});
            responseMessage = this.deleteInvoker.invoke(requestMessage);
        }
        if (responseMessage.isFault()) {
            Object body = responseMessage.getBody();
            int index = -1;
            index = body.getClass().getName().indexOf("NotModifiedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(304, body.toString().substring(index));
                } else {
                    response.sendError(304);
                }
                return;
            }
            index = body.getClass().getName().indexOf("PreconditionFailedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(412, body.toString().substring(index));
                } else {
                    response.sendError(412);
                }
                return;
            }
            throw new ServletException((Throwable)responseMessage.getBody());
        }
        InputStream is = (InputStream)responseMessage.getBody();
        ServletOutputStream os = response.getOutputStream();
        byte[] buffer = new byte[2048];
        while ((n = is.read(buffer)) > 0) {
            os.write(buffer, 0, n);
        }
        os.flush();
        os.close();
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int n;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        if (path.length() == 0) {
            response.sendRedirect(request.getRequestURL().append('/').toString());
            return;
        }
        Message requestMessage = this.messageFactory.createMessage();
        String id = path.substring(1);
        Message responseMessage = null;
        HTTPCacheContext cacheContext = null;
        try {
            cacheContext = HTTPCacheContext.createCacheContextFromRequest((HttpServletRequest)request);
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (cacheContext != null && cacheContext.isEnabled() && this.conditionalPutInvoker != null) {
            requestMessage.setBody((Object)new Object[]{id, cacheContext});
            responseMessage = this.conditionalPutInvoker.invoke(requestMessage);
        } else {
            requestMessage.setBody((Object)new Object[]{id});
            responseMessage = this.putInvoker.invoke(requestMessage);
        }
        if (responseMessage.isFault()) {
            Object body = responseMessage.getBody();
            int index = -1;
            index = body.getClass().getName().indexOf("NotModifiedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(304, body.toString().substring(index));
                } else {
                    response.sendError(304);
                }
                return;
            }
            index = body.getClass().getName().indexOf("PreconditionFailedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(412, body.toString().substring(index));
                } else {
                    response.sendError(412);
                }
                return;
            }
            throw new ServletException((Throwable)responseMessage.getBody());
        }
        InputStream is = (InputStream)responseMessage.getBody();
        ServletOutputStream os = response.getOutputStream();
        byte[] buffer = new byte[2048];
        while ((n = is.read(buffer)) > 0) {
            os.write(buffer, 0, n);
        }
        os.flush();
        os.close();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HTTPCacheContext cc;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        if (path.length() == 0) {
            response.sendRedirect(request.getRequestURL().append('/').toString());
            return;
        }
        Message requestMessage = this.messageFactory.createMessage();
        Message responseMessage = null;
        HTTPCacheContext cacheContext = null;
        try {
            cacheContext = HTTPCacheContext.createCacheContextFromRequest((HttpServletRequest)request);
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (cacheContext != null && cacheContext.isEnabled() && this.conditionalPostInvoker != null) {
            requestMessage.setBody((Object)new Object[]{cacheContext});
            responseMessage = this.conditionalPostInvoker.invoke(requestMessage);
        } else {
            requestMessage.setBody((Object)new Object[0]);
            responseMessage = this.postInvoker.invoke(requestMessage);
        }
        if (responseMessage.isFault()) {
            Object body = responseMessage.getBody();
            int index = -1;
            index = body.getClass().getName().indexOf("NotModifiedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(304, body.toString().substring(index));
                } else {
                    response.sendError(304);
                }
                return;
            }
            index = body.getClass().getName().indexOf("PreconditionFailedException");
            if (-1 < index) {
                if (index > -1) {
                    response.sendError(412, body.toString().substring(index));
                } else {
                    response.sendError(412);
                }
                return;
            }
            throw new ServletException((Throwable)responseMessage.getBody());
        }
        Object body = responseMessage.getBody();
        if (body.getClass() == HTTPCacheContext.class && (cc = (HTTPCacheContext)responseMessage.getBody()) != null && cc.isEnabled()) {
            String lastModified;
            String eTag = cc.getETag();
            if (eTag != null) {
                response.setHeader("ETag", cc.getETag());
            }
            if ((lastModified = cc.getLastModified()) != null) {
                response.setHeader("LastModified", cc.getLastModified());
            }
        }
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public Invoker getGetInvoker() {
        return this.getInvoker;
    }

    public void setGetInvoker(Invoker getInvoker) {
        this.getInvoker = getInvoker;
    }

    public Invoker getConditionalGetInvoker() {
        return this.conditionalGetInvoker;
    }

    public void setConditionalGetInvoker(Invoker conditionalGetInvoker) {
        this.conditionalGetInvoker = conditionalGetInvoker;
    }

    public Invoker getPutInvoker() {
        return this.putInvoker;
    }

    public void setPutInvoker(Invoker putInvoker) {
        this.putInvoker = putInvoker;
    }

    public Invoker getConditionalPutInvoker() {
        return this.conditionalPutInvoker;
    }

    public void setConditionalPutInvoker(Invoker conditionalPutInvoker) {
        this.conditionalPutInvoker = conditionalPutInvoker;
    }

    public Invoker getPostInvoker() {
        return this.postInvoker;
    }

    public void setPostInvoker(Invoker postInvoker) {
        this.postInvoker = postInvoker;
    }

    public Invoker getConditionalPostInvoker() {
        return this.conditionalPostInvoker;
    }

    public void setConditionalPostInvoker(Invoker conditionalPostInvoker) {
        this.conditionalPostInvoker = conditionalPostInvoker;
    }

    public Invoker getDeleteInvoker() {
        return this.deleteInvoker;
    }

    public void setDeleteInvoker(Invoker deleteInvoker) {
        this.deleteInvoker = deleteInvoker;
    }

    public Invoker getConditionalDeleteInvoker() {
        return this.conditionalDeleteInvoker;
    }

    public void setConditionalDeleteInvoker(Invoker conditionalDeleteInvoker) {
        this.conditionalDeleteInvoker = conditionalDeleteInvoker;
    }

    private void write(OutputStream out, Object obj) throws IOException {
        if (obj == null) {
            return;
        }
        if (obj instanceof String) {
            out.write(((String)obj).getBytes("UTF-8"));
        } else if (obj instanceof byte[]) {
            out.write((byte[])obj);
        } else if (obj instanceof InputStream) {
            int size;
            byte[] buf = new byte[8192];
            InputStream in = (InputStream)obj;
            while ((size = in.read(buf)) >= 0) {
                out.write(buf, 0, size);
            }
        } else {
            out.write(obj.toString().getBytes("UTF-8"));
        }
    }
}

