/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.binding.rest.RESTBinding;
import org.apache.tuscany.sca.binding.rest.provider.DataBindingJAXRSReader;
import org.apache.tuscany.sca.binding.rest.provider.DataBindingJAXRSWriter;
import org.apache.tuscany.sca.binding.rest.provider.JAXRSHelper;
import org.apache.tuscany.sca.binding.rest.wireformat.json.JSONWireFormat;
import org.apache.tuscany.sca.binding.rest.wireformat.xml.XMLWireFormat;
import org.apache.tuscany.sca.common.http.HTTPCacheContext;
import org.apache.tuscany.sca.common.http.HTTPHeader;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.wink.client.ApacheHttpClientConfig;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.ClientWebException;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;
import org.apache.wink.client.handlers.BasicAuthSecurityHandler;
import org.apache.wink.client.handlers.ClientHandler;

public class RESTBindingInvoker
implements Invoker {
    private ExtensionPointRegistry registry;
    private EndpointReference endpointReference;
    private RESTBinding binding;
    private Operation operation;
    private RestClient restClient;
    private String httpMethod;
    private Class<?> responseType;
    private static Map<Class<?>, String> mapping = new HashMap();

    public RESTBindingInvoker(ExtensionPointRegistry registry, EndpointReference endpointReference, RESTBinding binding, Operation operation, HttpClient httpClient) {
        this.registry = registry;
        this.endpointReference = endpointReference;
        this.binding = binding;
        this.operation = operation;
        this.restClient = this.createRestClient(httpClient);
    }

    private static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> type) {
        for (Annotation a : annotations) {
            if (a.annotationType() != type) continue;
            return (T)((Annotation)type.cast(a));
        }
        return null;
    }

    private RestClient createRestClient(HttpClient httpClient) {
        ApacheHttpClientConfig config = new ApacheHttpClientConfig(httpClient);
        config.applications(new Application[]{new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.emptySet();
            }

            public Set<Object> getSingletons() {
                HashSet<Object> providers = new HashSet<Object>();
                providers.add(new DataBindingJAXRSReader(RESTBindingInvoker.this.registry));
                providers.add(new DataBindingJAXRSWriter(RESTBindingInvoker.this.registry));
                return providers;
            }
        }});
        config.readTimeout(this.binding.getReadTimeout());
        RestClient client = new RestClient((ClientConfig)config);
        this.httpMethod = "GET";
        for (Map.Entry<Class<?>, String> e : mapping.entrySet()) {
            if (this.operation.getAttributes().get(e.getKey()) == null) continue;
            this.httpMethod = e.getValue();
            break;
        }
        this.responseType = this.operation.getOutputType() != null && !((List)this.operation.getOutputType().getLogical()).isEmpty() ? ((DataType)((List)this.operation.getOutputType().getLogical()).get(0)).getPhysical() : null;
        return client;
    }

    private void configureBasicAuth(ClientConfig config, String userName, String password) {
        BasicAuthSecurityHandler basicAuthSecurityHandler = new BasicAuthSecurityHandler();
        basicAuthSecurityHandler.setUserName(userName);
        basicAuthSecurityHandler.setPassword(password);
        config.handlers(new ClientHandler[]{basicAuthSecurityHandler});
    }

    public Message invoke(Message msg) {
        Object entity = null;
        Object[] args = (Object[])msg.getBody();
        URI uri = URI.create(this.endpointReference.getDeployedURI());
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)uri);
        Method method = ((JavaOperation)this.operation).getJavaMethod();
        if (method.isAnnotationPresent(Path.class)) {
            uriBuilder.path(method);
        }
        if (!JAXRSHelper.isResourceMethod(method)) {
            uriBuilder.replaceQueryParam("method", new Object[]{method.getName()});
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        HashMap<String, Object> matrixParams = new HashMap<String, Object>();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        HashMap<String, Object> headerParams = new HashMap<String, Object>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        HashMap<String, Object> cookieParams = new HashMap<String, Object>();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            CookieParam cookieParam;
            FormParam formParam;
            HeaderParam headerParam;
            QueryParam queryParam;
            MatrixParam matrixParam;
            boolean isEntity = true;
            Annotation[] annotations = method.getParameterAnnotations()[i];
            PathParam pathParam = RESTBindingInvoker.getAnnotation(annotations, PathParam.class);
            if (pathParam != null) {
                isEntity = false;
                pathParams.put(pathParam.value(), args[i]);
            }
            if ((matrixParam = RESTBindingInvoker.getAnnotation(annotations, MatrixParam.class)) != null) {
                isEntity = false;
                matrixParams.put(matrixParam.value(), args[i]);
            }
            if ((queryParam = RESTBindingInvoker.getAnnotation(annotations, QueryParam.class)) != null) {
                isEntity = false;
                queryParams.put(queryParam.value(), args[i]);
            }
            if ((headerParam = RESTBindingInvoker.getAnnotation(annotations, HeaderParam.class)) != null) {
                isEntity = false;
                headerParams.put(headerParam.value(), args[i]);
            }
            if ((formParam = RESTBindingInvoker.getAnnotation(annotations, FormParam.class)) != null) {
                isEntity = false;
                formParams.put(formParam.value(), args[i]);
            }
            if ((cookieParam = RESTBindingInvoker.getAnnotation(annotations, CookieParam.class)) != null) {
                isEntity = false;
                cookieParams.put(cookieParam.value(), args[i]);
            }
            if (RESTBindingInvoker.getAnnotation(annotations, Context.class) != null) {
                isEntity = false;
            }
            if (!isEntity) continue;
            entity = args[i];
        }
        for (Map.Entry p : queryParams.entrySet()) {
            uriBuilder.replaceQueryParam((String)p.getKey(), new Object[]{p.getValue()});
        }
        for (Map.Entry p : matrixParams.entrySet()) {
            uriBuilder.replaceMatrixParam((String)p.getKey(), new Object[]{p.getValue()});
        }
        uri = uriBuilder.buildFromMap(pathParams);
        Resource resource = this.restClient.resource(uri);
        for (Map.Entry p : headerParams.entrySet()) {
            resource.header((String)p.getKey(), new String[]{String.valueOf(p.getValue())});
        }
        for (Map.Entry p : cookieParams.entrySet()) {
            Cookie cookie = new Cookie((String)p.getKey(), String.valueOf(p.getValue()));
            resource.cookie(cookie);
        }
        resource.contentType(this.getContentType());
        resource.accept(this.getAccepts());
        for (HTTPHeader header : this.binding.getHttpHeaders()) {
            if (header.getName().equalsIgnoreCase("Expires")) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(new Date());
                calendar.add(10, Integer.parseInt(header.getValue()));
                resource.header("Expires", new String[]{HTTPCacheContext.RFC822DateFormat.format(calendar.getTime())});
                continue;
            }
            resource.header(header.getName(), new String[]{header.getValue()});
        }
        try {
            Object result = resource.invoke(this.httpMethod, this.responseType, entity);
            msg.setBody(result);
        }
        catch (ClientWebException e) {
            ClientResponse clientResponse = e.getResponse();
            byte[] error = (byte[])clientResponse.getEntity(byte[].class);
            ByteArrayEntity errorEntity = error == null ? null : new ByteArrayEntity(error);
            clientResponse.setEntity((Object)errorEntity);
            throw e;
        }
        return msg;
    }

    private String getContentType() {
        WireFormat wf;
        String contentType = "application/octet-stream";
        Consumes consumes = ((JavaOperation)this.operation).getJavaMethod().getAnnotation(Consumes.class);
        if (consumes != null && consumes.value().length > 0) {
            contentType = consumes.value()[0];
        }
        if ((wf = this.binding.getRequestWireFormat()) != null) {
            if (XMLWireFormat.REST_WIREFORMAT_XML_QNAME.equals(wf.getSchemaName())) {
                contentType = "application/xml";
            } else if (JSONWireFormat.REST_WIREFORMAT_JSON_QNAME.equals(wf.getSchemaName())) {
                contentType = "application/json";
            }
        }
        return contentType;
    }

    private String[] getAccepts() {
        WireFormat wf;
        String[] accepts = new String[]{"application/octet-stream"};
        Produces produces = ((JavaOperation)this.operation).getJavaMethod().getAnnotation(Produces.class);
        if (produces != null) {
            accepts = produces.value();
        }
        if ((wf = this.binding.getResponseWireFormat()) != null) {
            if (XMLWireFormat.REST_WIREFORMAT_XML_QNAME.equals(wf.getSchemaName())) {
                accepts = new String[]{"application/xml"};
            } else if (JSONWireFormat.REST_WIREFORMAT_JSON_QNAME.equals(wf.getSchemaName())) {
                accepts = new String[]{"application/json"};
            }
        }
        return accepts;
    }

    static {
        mapping.put(GET.class, "GET");
        mapping.put(POST.class, "POST");
        mapping.put(PUT.class, "PUT");
        mapping.put(DELETE.class, "DELETE");
        mapping.put(HEAD.class, "HEAD");
        mapping.put(OPTIONS.class, "OPTIONS");
    }
}

