/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;

public class JAXRSHelper {
    private JAXRSHelper() {
    }

    public static boolean isJAXRSResource(Class<?> cls) {
        for (Method method : cls.getMethods()) {
            if (method.isAnnotationPresent(Path.class)) {
                return true;
            }
            if (!JAXRSHelper.isResourceMethod(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJAXRSRootResource(Class<?> cls) {
        return cls.isAnnotationPresent(Path.class) && JAXRSHelper.isJAXRSResource(cls);
    }

    public static boolean isResourceMethod(Method method) {
        for (Annotation a : method.getAnnotations()) {
            Class<? extends Annotation> annotationType = a.annotationType();
            if (annotationType == HttpMethod.class) {
                return true;
            }
            HttpMethod m = a.annotationType().getAnnotation(HttpMethod.class);
            if (m == null) continue;
            return true;
        }
        return false;
    }
}

