/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.tuscany.sca.binding.rest.provider.DataBindingJAXRSProvider;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.common.http.ThreadHTTPContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;

@Provider
@Produces(value={"application/json", "application/xml", "text/xml", "*/*"})
public class DataBindingJAXRSWriter<T>
extends DataBindingJAXRSProvider
implements MessageBodyWriter<T> {
    public static final String FIELDS = "fields";
    public static final String EXCLUDED_FIELDS = "excludedFields";
    public static final String INCLUDED_FIELDS = "includedFields";

    public DataBindingJAXRSWriter(ExtensionPointRegistry registry) {
        super(registry);
    }

    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.supports(type, genericType, annotations, mediaType);
    }

    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        DataType dataType = this.createDataType(type, genericType);
        mediaType = new MediaType(mediaType.getType(), mediaType.getSubtype());
        String dataBinding = OutputStream.class.getName();
        if (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
            dataBinding = mediaType.toString() + "#" + OutputStream.class.getName();
        } else if (MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType) || MediaType.TEXT_XML_TYPE.equals((Object)mediaType)) {
            dataBinding = OutputStream.class.getName();
        } else if ("application/x-protobuf".equals(mediaType.toString())) {
            dataBinding = mediaType.toString() + "#" + OutputStream.class.getName();
        } else {
            dataBinding = dataType.getDataBinding();
            this.write(entityStream, t, type);
            return;
        }
        DataTypeImpl targetDataType = new DataTypeImpl(dataBinding, OutputStream.class, OutputStream.class, OutputStream.class);
        this.introspectAnnotations(annotations, (DataType)targetDataType);
        Map<String, Object> metadata = this.getFields();
        this.mediator.mediate(t, (Object)entityStream, dataType, (DataType)targetDataType, metadata);
    }

    private Map<String, Object> getFields() {
        Map<String, Object> metadata = Collections.emptyMap();
        HTTPContext context = ThreadHTTPContext.getHTTPContext();
        if (context != null) {
            String fields;
            Set<String> excludedFields;
            metadata = new HashMap<String, Object>();
            String included = context.getHttpRequest().getParameter(INCLUDED_FIELDS);
            String excluded = context.getHttpRequest().getParameter(EXCLUDED_FIELDS);
            Set<String> includedFields = this.tokenize(included);
            if (includedFields != null) {
                metadata.put(INCLUDED_FIELDS, includedFields);
            }
            if ((excludedFields = this.tokenize(excluded)) != null) {
                metadata.put(EXCLUDED_FIELDS, excludedFields);
            }
            if ((fields = context.getHttpRequest().getParameter(FIELDS)) != null) {
                Set<String> fieldSet = this.tokenize(fields);
                for (String f : fieldSet) {
                    if (f.startsWith("-")) {
                        if (excludedFields == null) {
                            excludedFields = new HashSet<String>();
                            metadata.put(EXCLUDED_FIELDS, excludedFields);
                        }
                        excludedFields.add(f.substring(1));
                        continue;
                    }
                    if (includedFields == null) {
                        includedFields = new HashSet<String>();
                        metadata.put(INCLUDED_FIELDS, includedFields);
                    }
                    includedFields.add(f);
                }
            }
        }
        return metadata;
    }

    private Set<String> tokenize(String included) {
        if (included == null) {
            return null;
        }
        String[] fields = included.split("(,| )+");
        HashSet<String> includedFields = new HashSet<String>();
        for (String f : fields) {
            String field = f.trim();
            if (field.length() <= 0) continue;
            includedFields.add(field);
        }
        return includedFields;
    }
}

