/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.provider;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.apache.tuscany.sca.binding.rest.provider.DataBindingJAXRSProvider;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;

@Provider
@Consumes(value={"application/json", "application/xml", "text/xml", "*/*"})
public class DataBindingJAXRSReader<T>
extends DataBindingJAXRSProvider
implements MessageBodyReader<T> {
    public DataBindingJAXRSReader(ExtensionPointRegistry registry) {
        super(registry);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.supports(type, genericType, annotations, mediaType);
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Object source = entityStream;
        DataType targetDataType = this.createDataType(type, genericType);
        String dataBinding = null;
        if (MediaType.APPLICATION_JSON_TYPE.equals((Object)(mediaType = new MediaType(mediaType.getType(), mediaType.getSubtype())))) {
            dataBinding = mediaType.toString() + "#" + InputStream.class.getName();
        } else if ("application/x-protobuf".equals(mediaType.toString())) {
            dataBinding = mediaType.toString() + "#" + InputStream.class.getName();
        } else if (MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType) || MediaType.TEXT_XML_TYPE.equals((Object)mediaType)) {
            dataBinding = InputStream.class.getName();
        } else {
            dataBinding = targetDataType.getDataBinding();
            source = this.convert(entityStream, mediaType.toString(), type);
            return (T)source;
        }
        DataTypeImpl sourceDataType = new DataTypeImpl(dataBinding, InputStream.class, InputStream.class, InputStream.class);
        Object result = this.mediator.mediate(source, (DataType)sourceDataType, targetDataType, Collections.emptyMap());
        return (T)result;
    }
}

