/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

@Provider
public abstract class DataBindingJAXRSProvider {
    protected DataBindingExtensionPoint dataBindingExtensionPoint;
    protected Mediator mediator;

    public DataBindingJAXRSProvider(ExtensionPointRegistry registry) {
        this.dataBindingExtensionPoint = (DataBindingExtensionPoint)registry.getExtensionPoint(DataBindingExtensionPoint.class);
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.mediator = (Mediator)utilities.getUtility(Mediator.class);
    }

    protected <A extends Annotation> A getAnnotation(Annotation[] annotations, Class<A> type) {
        if (annotations == null) {
            return null;
        }
        for (Annotation a : annotations) {
            if (a.annotationType() != type) continue;
            return (A)((Annotation)type.cast(a));
        }
        return null;
    }

    protected void introspectAnnotations(Annotation[] annotations, DataType targetDataType) {
        WebParam param;
        WebResult result = this.getAnnotation(annotations, WebResult.class);
        if (result != null) {
            QName name = new QName(result.targetNamespace(), result.name());
            targetDataType.setLogical((Object)new XMLType(name, null));
        }
        if ((param = this.getAnnotation(annotations, WebParam.class)) != null) {
            QName name = new QName(param.targetNamespace(), param.name());
            targetDataType.setLogical((Object)new XMLType(name, null));
        }
    }

    protected DataType createDataType(Class<?> type, Type genericType) {
        DataTypeImpl dataType = new DataTypeImpl(null, type, genericType, (Object)genericType);
        this.dataBindingExtensionPoint.introspectType((DataType)dataType, null);
        return dataType;
    }

    protected boolean supports(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType = new MediaType(mediaType.getType(), mediaType.getSubtype())) || MediaType.APPLICATION_XML_TYPE.isCompatible(mediaType) || MediaType.TEXT_XML_TYPE.isCompatible(mediaType);
    }

    protected Object convert(InputStream content, String contentType, Class<?> type) throws IOException {
        if (type == DataSource.class) {
            return type.cast(new InputStreamDataSource(content, contentType));
        }
        if (type == InputStream.class) {
            return type.cast(content);
        }
        if (type == Reader.class) {
            return type.cast(new InputStreamReader(content, "UTF-8"));
        }
        if (type == String.class) {
            try {
                int size;
                StringWriter sw = new StringWriter();
                InputStreamReader reader = new InputStreamReader(content, "UTF-8");
                char[] buf = new char[8192];
                while ((size = reader.read(buf)) >= 0) {
                    sw.write(buf, 0, size);
                }
                return type.cast(sw.toString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (type == byte[].class) {
            try {
                int size;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[8192];
                while ((size = content.read(buf)) >= 0) {
                    bos.write(buf, 0, size);
                }
                return type.cast(bos.toByteArray());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return content;
    }

    protected void write(OutputStream out, Object content, Class<?> type) throws IOException {
        if (content == null) {
            return;
        }
        InputStream in = null;
        if (DataSource.class.isAssignableFrom(type)) {
            in = ((DataSource)content).getInputStream();
        } else if (InputStream.class.isAssignableFrom(type)) {
            in = (InputStream)content;
        } else if (type == String.class) {
            in = new ByteArrayInputStream(((String)content).getBytes("UTF-8"));
        } else if (type == byte[].class) {
            in = new ByteArrayInputStream((byte[])content);
        }
        if (in == null) {
            throw new IllegalArgumentException("Type is not supported: " + type);
        }
        byte[] buf = new byte[8192];
        while (true) {
            int len;
            if ((len = in.read(buf)) < 0) break;
            out.write(buf, 0, len);
        }
        in.close();
    }

    public static final class InputStreamDataSource
    implements DataSource {
        public static final String DEFAULT_TYPE = "application/octet-stream";
        private final InputStream in;
        private final String ctype;

        public InputStreamDataSource(InputStream in) {
            this(in, null);
        }

        public InputStreamDataSource(InputStream in, String ctype) {
            this.in = in;
            this.ctype = ctype != null ? ctype : DEFAULT_TYPE;
        }

        public String getContentType() {
            return this.ctype;
        }

        public String getName() {
            return null;
        }

        public InputStream getInputStream() throws IOException {
            return this.in;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }
    }
}

