/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.operationselector.rpc.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.QueryParam;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.common.http.HTTPUtils;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.SimpleTypeMapper;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class RPCOperationSelectorInterceptor
implements Interceptor {
    private ExtensionPointRegistry extensionPoints;
    private SimpleTypeMapper simpleTypeMapper;
    private RuntimeEndpoint endpoint;
    private RuntimeComponentService service;
    private InterfaceContract interfaceContract;
    private List<Operation> serviceOperations;
    private Invoker next;

    public RPCOperationSelectorInterceptor(ExtensionPointRegistry extensionPoints, RuntimeEndpoint endpoint) {
        this.extensionPoints = extensionPoints;
        UtilityExtensionPoint utilityExtensionPoint = (UtilityExtensionPoint)extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.simpleTypeMapper = (SimpleTypeMapper)utilityExtensionPoint.getUtility(SimpleTypeMapper.class);
        this.endpoint = endpoint;
        this.service = (RuntimeComponentService)endpoint.getService();
        this.interfaceContract = this.service.getInterfaceContract();
        this.serviceOperations = this.service.getInterfaceContract().getInterface().getOperations();
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message invoke(Message msg) {
        try {
            String operationName;
            Operation operation;
            HTTPContext bindingContext = (HTTPContext)msg.getBindingContext();
            if (!"get".equalsIgnoreCase(bindingContext.getHttpRequest().getMethod())) {
                throw new RuntimeException("RPC Invocation only allowed over HTTP GET operations");
            }
            String path = URLDecoder.decode(HTTPUtils.getRequestPath((HttpServletRequest)bindingContext.getHttpRequest()), "UTF-8");
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((operation = this.findOperation(operationName = bindingContext.getHttpRequest().getParameter("method"))) == null) {
                throw new RuntimeException("Invalid Operation '" + operationName + "'");
            }
            JavaOperation javaOperation = (JavaOperation)operation;
            Method method = javaOperation.getJavaMethod();
            ArrayList<Object> messageParameters = new ArrayList<Object>();
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                for (Annotation annotation : method.getParameterAnnotations()[i]) {
                    TypeInfo typeInfo;
                    Class<?> clazz;
                    if (!(annotation instanceof QueryParam)) continue;
                    QueryParam queryParam = (QueryParam)annotation;
                    String name = queryParam.value();
                    String[] values = bindingContext.getHttpRequest().getParameterValues(name);
                    if (values.length == 1) {
                        clazz = method.getParameterTypes()[i];
                        typeInfo = this.simpleTypeMapper.getXMLType(clazz);
                        Object v = this.simpleTypeMapper.toJavaObject(typeInfo.getQName(), values[0], null);
                        messageParameters.add(v);
                        continue;
                    }
                    clazz = method.getParameterTypes()[i].getComponentType();
                    typeInfo = this.simpleTypeMapper.getXMLType(clazz);
                    Object objectArray = Array.newInstance(clazz, values.length);
                    for (int count = 0; count < values.length; ++count) {
                        Object v = this.simpleTypeMapper.toJavaObject(typeInfo.getQName(), values[count], null);
                        Array.set(objectArray, count, v);
                    }
                    messageParameters.add(objectArray);
                }
            }
            Object[] body = new Object[messageParameters.size()];
            messageParameters.toArray(body);
            msg.setBody((Object)body);
            msg.setOperation(operation);
            Message responseMessage = this.getNext().invoke(msg);
            bindingContext.getHttpResponse().setHeader("Cache-Control", "no-cache");
            bindingContext.getHttpResponse().setHeader("Expires", new Date(0L).toGMTString());
            String eTag = HTTPUtils.calculateHashETag((byte[])responseMessage.getBody().toString().getBytes("UTF-8"));
            String predicate = bindingContext.getHttpRequest().getHeader("If-Match");
            if (predicate != null && !predicate.equals(eTag)) {
                bindingContext.getHttpResponse().sendError(412);
            }
            if ((predicate = bindingContext.getHttpRequest().getHeader("If-None-Match")) != null && predicate.equals(eTag)) {
                bindingContext.getHttpResponse().sendError(304);
            }
            bindingContext.getHttpResponse().addHeader("ETag", eTag);
            return responseMessage;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Operation findOperation(String method) {
        if (method.contains(".")) {
            method = method.substring(method.lastIndexOf(".") + 1);
        }
        List operations = this.endpoint.getComponentServiceInterfaceContract().getInterface().getOperations();
        Operation result = null;
        for (Operation o : operations) {
            if (!o.getName().equalsIgnoreCase(method)) continue;
            result = o;
            break;
        }
        return result;
    }
}

