/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.rest.operationselector.jaxrs.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.List;
import javax.activation.DataSource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.apache.tuscany.sca.common.http.HTTPContext;
import org.apache.tuscany.sca.common.http.HTTPUtils;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class JAXRSOperationSelectorInterceptor
implements Interceptor {
    private ExtensionPointRegistry extensionPoints;
    private RuntimeEndpoint endpoint;
    private RuntimeComponentService service;
    private InterfaceContract interfaceContract;
    private List<Operation> serviceOperations;
    private Invoker next;

    public JAXRSOperationSelectorInterceptor(ExtensionPointRegistry extensionPoints, RuntimeEndpoint endpoint) {
        this.extensionPoints = extensionPoints;
        this.endpoint = endpoint;
        this.service = (RuntimeComponentService)endpoint.getService();
        this.interfaceContract = this.service.getInterfaceContract();
        this.serviceOperations = this.service.getInterfaceContract().getInterface().getOperations();
    }

    public Invoker getNext() {
        return this.next;
    }

    public void setNext(Invoker next) {
        this.next = next;
    }

    public Message invoke(Message msg) {
        Class<?>[] paramTypes;
        HTTPContext bindingContext = (HTTPContext)msg.getBindingContext();
        if (bindingContext == null) {
            return this.getNext().invoke(msg);
        }
        String path = null;
        try {
            path = URLDecoder.decode(HTTPUtils.getRequestPath((HttpServletRequest)bindingContext.getHttpRequest()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        List<Operation> operations = JAXRSOperationSelectorInterceptor.filterOperationsByHttpMethod(this.interfaceContract, bindingContext.getHttpRequest().getMethod());
        Operation operation = this.findOperation(path, operations);
        JavaOperation javaOperation = (JavaOperation)operation;
        Method method = javaOperation.getJavaMethod();
        if (path != null && path.length() > 0 && method.getAnnotation(Path.class) != null) {
            msg.setBody((Object)new Object[]{path});
        }
        if ((paramTypes = method.getParameterTypes()).length == 1) {
            Class<?> type = paramTypes[0];
            InputStream is = (InputStream)((Object[])msg.getBody())[0];
            Object target = this.convert(is, bindingContext.getHttpRequest().getContentType(), type);
            msg.setBody((Object)new Object[]{target});
        } else if (paramTypes.length == 0) {
            msg.setBody(null);
        }
        msg.setOperation(operation);
        return this.getNext().invoke(msg);
    }

    private Object convert(InputStream content, String contentType, Class<?> type) {
        if (type == DataSource.class) {
            return type.cast(new InputStreamDataSource(content, contentType));
        }
        if (type == InputStream.class) {
            return type.cast(content);
        }
        if (type == String.class) {
            try {
                int size;
                StringWriter sw = new StringWriter();
                InputStreamReader reader = new InputStreamReader(content, "UTF-8");
                char[] buf = new char[8192];
                while ((size = reader.read(buf)) >= 0) {
                    sw.write(buf, 0, size);
                }
                return type.cast(sw.toString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (type == byte[].class) {
            try {
                int size;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] buf = new byte[8192];
                while ((size = content.read(buf)) >= 0) {
                    bos.write(buf, 0, size);
                }
                return type.cast(bos.toByteArray());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return content;
    }

    private static List<Operation> filterOperationsByHttpMethod(InterfaceContract interfaceContract, String http_method) {
        List operations = null;
        if (http_method.equalsIgnoreCase("get")) {
            operations = (List)interfaceContract.getInterface().getAttributes().get(GET.class);
        } else if (http_method.equalsIgnoreCase("put")) {
            operations = (List)interfaceContract.getInterface().getAttributes().get(PUT.class);
        } else if (http_method.equalsIgnoreCase("post")) {
            operations = (List)interfaceContract.getInterface().getAttributes().get(POST.class);
        } else if (http_method.equalsIgnoreCase("delete")) {
            operations = (List)interfaceContract.getInterface().getAttributes().get(DELETE.class);
        }
        return operations;
    }

    private Operation findOperation(String path, List<Operation> operations) {
        Operation operation = null;
        for (Operation op : operations) {
            JavaOperation javaOperation = (JavaOperation)op;
            Method method = javaOperation.getJavaMethod();
            if (path != null && path.length() > 0) {
                if (method.getAnnotation(Path.class) == null) continue;
                operation = op;
                break;
            }
            if (method.getAnnotation(Path.class) != null) continue;
            operation = op;
            break;
        }
        return operation;
    }

    public static final class InputStreamDataSource
    implements DataSource {
        public static final String DEFAULT_TYPE = "application/octet-stream";
        private final InputStream in;
        private final String ctype;

        public InputStreamDataSource(InputStream in) {
            this(in, null);
        }

        public InputStreamDataSource(InputStream in, String ctype) {
            this.in = in;
            this.ctype = ctype != null ? ctype : DEFAULT_TYPE;
        }

        public String getContentType() {
            return this.ctype;
        }

        public String getName() {
            return null;
        }

        public InputStream getInputStream() throws IOException {
            return this.in;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }
    }
}

