/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo.telnet;

import java.lang.reflect.Method;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.support.ProviderConsumerRegTable;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.telnet.TelnetHandler;
import org.apache.dubbo.remoting.telnet.support.Help;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ConsumerMethodModel;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.ProviderMethodModel;
import org.apache.dubbo.rpc.model.ProviderModel;

@Activate
@Help(parameter="[-l] [service]", summary="List services and methods.", detail="List services and methods.")
public class ListTelnetHandler
implements TelnetHandler {
    public String telnet(Channel channel, String message) {
        StringBuilder buf = new StringBuilder();
        String service = null;
        boolean detail = false;
        if (message.length() > 0) {
            String[] parts;
            for (String part : parts = message.split("\\s+")) {
                if ("-l".equals(part)) {
                    detail = true;
                    continue;
                }
                if (!StringUtils.isEmpty((String)service)) {
                    return "Invalid parameter " + part;
                }
                service = part;
            }
        } else {
            service = (String)channel.getAttribute("telnet.service");
            if (StringUtils.isNotEmpty((String)service)) {
                buf.append("Use default service ").append(service).append(".\r\n");
            }
        }
        if (StringUtils.isEmpty((String)service)) {
            this.printAllServices(buf, detail);
        } else {
            this.printSpecifiedService(service, buf, detail);
            if (buf.length() == 0) {
                buf.append("No such service: ").append(service);
            }
        }
        return buf.toString();
    }

    private void printAllServices(StringBuilder buf, boolean detail) {
        this.printAllProvidedServices(buf, detail);
        this.printAllReferredServices(buf, detail);
    }

    private void printAllProvidedServices(StringBuilder buf, boolean detail) {
        if (!ApplicationModel.allProviderModels().isEmpty()) {
            buf.append("PROVIDER:\r\n");
        }
        for (ProviderModel provider : ApplicationModel.allProviderModels()) {
            buf.append(provider.getServiceName());
            if (detail) {
                buf.append(" -> ");
                buf.append(" published: ");
                buf.append(ProviderConsumerRegTable.isRegistered((String)provider.getServiceName()) ? "Y" : "N");
            }
            buf.append("\r\n");
        }
    }

    private void printAllReferredServices(StringBuilder buf, boolean detail) {
        if (!ApplicationModel.allConsumerModels().isEmpty()) {
            buf.append("CONSUMER:\r\n");
        }
        for (ConsumerModel consumer : ApplicationModel.allConsumerModels()) {
            buf.append(consumer.getServiceName());
            if (!detail) continue;
            buf.append(" -> ");
            buf.append(" addresses: ");
            buf.append(ProviderConsumerRegTable.getConsumerAddressNum((String)consumer.getServiceName()));
        }
    }

    private void printSpecifiedService(String service, StringBuilder buf, boolean detail) {
        this.printSpecifiedProvidedService(service, buf, detail);
        this.printSpecifiedReferredService(service, buf, detail);
    }

    private void printSpecifiedProvidedService(String service, StringBuilder buf, boolean detail) {
        for (ProviderModel provider : ApplicationModel.allProviderModels()) {
            if (!this.isProviderMatched(service, provider)) continue;
            buf.append(provider.getServiceName()).append(" (as provider):\r\n");
            for (ProviderMethodModel method : provider.getAllMethods()) {
                this.printMethod(method.getMethod(), buf, detail);
            }
        }
    }

    private void printSpecifiedReferredService(String service, StringBuilder buf, boolean detail) {
        for (ConsumerModel consumer : ApplicationModel.allConsumerModels()) {
            if (!this.isConsumerMatcher(service, consumer)) continue;
            buf.append(consumer.getServiceName()).append(" (as consumer):\r\n");
            for (ConsumerMethodModel method : consumer.getAllMethods()) {
                this.printMethod(method.getMethod(), buf, detail);
            }
        }
    }

    private void printMethod(Method method, StringBuilder buf, boolean detail) {
        if (detail) {
            buf.append('\t').append(ReflectUtils.getName((Method)method));
        } else {
            buf.append('\t').append(method.getName());
        }
        buf.append("\r\n");
    }

    private boolean isProviderMatched(String service, ProviderModel provider) {
        return service.equalsIgnoreCase(provider.getServiceName()) || service.equalsIgnoreCase(provider.getServiceInterfaceClass().getName()) || service.equalsIgnoreCase(provider.getServiceInterfaceClass().getSimpleName());
    }

    private boolean isConsumerMatcher(String service, ConsumerModel consumer) {
        return service.equalsIgnoreCase(consumer.getServiceName()) || service.equalsIgnoreCase(consumer.getServiceInterfaceClass().getName()) || service.equalsIgnoreCase(consumer.getServiceInterfaceClass().getSimpleName());
    }
}

