/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.Codec2;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffers;
import org.apache.dubbo.remoting.buffer.DynamicChannelBuffer;
import org.apache.dubbo.remoting.transport.netty.NettyChannel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;

final class NettyCodecAdapter {
    private final org.jboss.netty.channel.ChannelHandler encoder = new InternalEncoder();
    private final org.jboss.netty.channel.ChannelHandler decoder = new InternalDecoder();
    private final Codec2 codec;
    private final URL url;
    private final int bufferSize;
    private final ChannelHandler handler;

    public NettyCodecAdapter(Codec2 codec, URL url, ChannelHandler handler) {
        this.codec = codec;
        this.url = url;
        this.handler = handler;
        int b = url.getPositiveParameter("buffer", 8192);
        this.bufferSize = b >= 1024 && b <= 16384 ? b : 8192;
    }

    public org.jboss.netty.channel.ChannelHandler getEncoder() {
        return this.encoder;
    }

    public org.jboss.netty.channel.ChannelHandler getDecoder() {
        return this.decoder;
    }

    private class InternalDecoder
    extends SimpleChannelUpstreamHandler {
        private ChannelBuffer buffer = ChannelBuffers.EMPTY_BUFFER;

        private InternalDecoder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) throws Exception {
            ChannelBuffer message;
            Object o = event.getMessage();
            if (!(o instanceof org.jboss.netty.buffer.ChannelBuffer)) {
                ctx.sendUpstream((ChannelEvent)event);
                return;
            }
            org.jboss.netty.buffer.ChannelBuffer input = (org.jboss.netty.buffer.ChannelBuffer)o;
            int readable = input.readableBytes();
            if (readable <= 0) {
                return;
            }
            if (this.buffer.readable()) {
                if (this.buffer instanceof DynamicChannelBuffer) {
                    this.buffer.writeBytes(input.toByteBuffer());
                    message = this.buffer;
                } else {
                    int size = this.buffer.readableBytes() + input.readableBytes();
                    message = ChannelBuffers.dynamicBuffer((int)(size > NettyCodecAdapter.this.bufferSize ? size : NettyCodecAdapter.this.bufferSize));
                    message.writeBytes(this.buffer, this.buffer.readableBytes());
                    message.writeBytes(input.toByteBuffer());
                }
            } else {
                message = ChannelBuffers.wrappedBuffer((ByteBuffer)input.toByteBuffer());
            }
            NettyChannel channel = NettyChannel.getOrAddChannel(ctx.getChannel(), NettyCodecAdapter.this.url, NettyCodecAdapter.this.handler);
            try {
                do {
                    Object msg;
                    int saveReaderIndex = message.readerIndex();
                    try {
                        msg = NettyCodecAdapter.this.codec.decode((Channel)channel, message);
                    }
                    catch (IOException e) {
                        this.buffer = ChannelBuffers.EMPTY_BUFFER;
                        throw e;
                    }
                    if (msg == Codec2.DecodeResult.NEED_MORE_INPUT) {
                        message.readerIndex(saveReaderIndex);
                        break;
                    }
                    if (saveReaderIndex == message.readerIndex()) {
                        this.buffer = ChannelBuffers.EMPTY_BUFFER;
                        throw new IOException("Decode without read data.");
                    }
                    if (msg == null) continue;
                    Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)msg, (SocketAddress)event.getRemoteAddress());
                } while (message.readable());
            }
            finally {
                if (message.readable()) {
                    message.discardReadBytes();
                    this.buffer = message;
                } else {
                    this.buffer = ChannelBuffers.EMPTY_BUFFER;
                }
                NettyChannel.removeChannelIfDisconnected(ctx.getChannel());
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            ctx.sendUpstream((ChannelEvent)e);
        }
    }

    @ChannelHandler.Sharable
    private class InternalEncoder
    extends OneToOneEncoder {
        private InternalEncoder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object encode(ChannelHandlerContext ctx, org.jboss.netty.channel.Channel ch, Object msg) throws Exception {
            ChannelBuffer buffer = ChannelBuffers.dynamicBuffer((int)1024);
            NettyChannel channel = NettyChannel.getOrAddChannel(ch, NettyCodecAdapter.this.url, NettyCodecAdapter.this.handler);
            try {
                NettyCodecAdapter.this.codec.encode((Channel)channel, buffer, msg);
            }
            finally {
                NettyChannel.removeChannelIfDisconnected(ch);
            }
            return org.jboss.netty.buffer.ChannelBuffers.wrappedBuffer((ByteBuffer)buffer.toByteBuffer());
        }
    }
}

