/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractSharedListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.configcenter.ConfigChangeEvent;
import org.apache.dubbo.configcenter.ConfigChangeType;
import org.apache.dubbo.configcenter.ConfigurationListener;
import org.apache.dubbo.configcenter.DynamicConfiguration;

public class NacosDynamicConfiguration
implements DynamicConfiguration {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long DEFAULT_TIMEOUT = 5000L;
    private ConfigService configService;
    private final ConcurrentMap<String, NacosConfigListener> watchListenerMap;

    NacosDynamicConfiguration(URL url) {
        this.buildConfigService(url);
        this.watchListenerMap = new ConcurrentHashMap<String, NacosConfigListener>();
    }

    private ConfigService buildConfigService(URL url) {
        Properties nacosProperties = this.buildNacosProperties(url);
        try {
            this.configService = NacosFactory.createConfigService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getErrMsg(), (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
        return this.configService;
    }

    private Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        this.setServerAddr(url, properties);
        this.setProperties(url, properties);
        return properties;
    }

    private void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(":").append(url.getPort());
        String backup = url.getParameter("backup");
        if (backup != null) {
            serverAddrBuilder.append(",").append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private void setProperties(URL url, Properties properties) {
        this.putPropertyIfAbsent(url, properties, "namespace");
        this.putPropertyIfAbsent(url, properties, "com.alibaba.nacos.naming.log.filename");
        this.putPropertyIfAbsent(url, properties, "endpoint");
        this.putPropertyIfAbsent(url, properties, "accessKey");
        this.putPropertyIfAbsent(url, properties, "secretKey");
        this.putPropertyIfAbsent(url, properties, "clusterName");
    }

    private void putPropertyIfAbsent(URL url, Properties properties, String propertyName) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty((String)propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        }
    }

    private NacosConfigListener createTargetListener(String key, String group) {
        NacosConfigListener configListener = new NacosConfigListener();
        configListener.fillContext(key, group);
        return configListener;
    }

    public void addListener(String key, String group, ConfigurationListener listener) {
        NacosConfigListener nacosConfigListener = this.watchListenerMap.computeIfAbsent(key, k -> this.createTargetListener(key, group));
        nacosConfigListener.addListener(listener);
        try {
            this.configService.addListener(key, group, (Listener)nacosConfigListener);
        }
        catch (NacosException e) {
            this.logger.error(e.getMessage());
        }
    }

    public void removeListener(String key, String group, ConfigurationListener listener) {
        NacosConfigListener eventListener = (NacosConfigListener)((Object)this.watchListenerMap.get(key));
        if (eventListener != null) {
            eventListener.removeListener(listener);
        }
    }

    public String getRule(String key, String group, long timeout) throws IllegalStateException {
        try {
            long nacosTimeout;
            long l = nacosTimeout = timeout < 0L ? 5000L : timeout;
            if (StringUtils.isEmpty((String)group)) {
                group = "dubbo";
            }
            return this.configService.getConfig(key, group, nacosTimeout);
        }
        catch (NacosException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public String getProperties(String key, String group, long timeout) throws IllegalStateException {
        return this.getRule(key, group, timeout);
    }

    public Object getInternalProperty(String key) {
        try {
            return this.configService.getConfig(key, "dubbo", 5000L);
        }
        catch (NacosException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public class NacosConfigListener
    extends AbstractSharedListener {
        private Set<ConfigurationListener> listeners = new CopyOnWriteArraySet<ConfigurationListener>();
        private Map<String, String> cacheData = new ConcurrentHashMap<String, String>();

        public Executor getExecutor() {
            return null;
        }

        public void innerReceive(String dataId, String group, String configInfo) {
            String oldValue = this.cacheData.get(dataId);
            ConfigChangeEvent event = new ConfigChangeEvent(dataId, configInfo, this.getChangeType(configInfo, oldValue));
            if (configInfo == null) {
                this.cacheData.remove(dataId);
            } else {
                this.cacheData.put(dataId, configInfo);
            }
            this.listeners.forEach(listener -> listener.process(event));
        }

        void addListener(ConfigurationListener configurationListener) {
            this.listeners.add(configurationListener);
        }

        void removeListener(ConfigurationListener configurationListener) {
            this.listeners.remove(configurationListener);
        }

        private ConfigChangeType getChangeType(String configInfo, String oldValue) {
            if (StringUtils.isBlank((CharSequence)configInfo)) {
                return ConfigChangeType.DELETED;
            }
            if (StringUtils.isBlank((CharSequence)oldValue)) {
                return ConfigChangeType.ADDED;
            }
            return ConfigChangeType.MODIFIED;
        }
    }
}

