/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.OptionalLong;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.From;
import org.springframework.data.relational.core.sql.Join;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectList;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.Visitor;
import org.springframework.data.relational.core.sql.Where;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultSelect
implements Select {
    private final boolean distinct;
    private final SelectList selectList;
    private final From from;
    private final long limit;
    private final long offset;
    private final List<Join> joins;
    @Nullable
    private final Where where;
    private final List<OrderByField> orderBy;
    @Nullable
    private final LockMode lockMode;

    DefaultSelect(boolean distinct, List<Expression> selectList, List<Table> from, long limit, long offset, List<Join> joins, @Nullable Condition where, List<OrderByField> orderBy, @Nullable LockMode lockMode) {
        this.distinct = distinct;
        this.selectList = new SelectList(new ArrayList<Expression>(selectList));
        this.from = new From(new ArrayList<Table>(from));
        this.limit = limit;
        this.offset = offset;
        this.joins = new ArrayList<Join>(joins);
        this.orderBy = Collections.unmodifiableList(new ArrayList<OrderByField>(orderBy));
        this.where = where != null ? new Where(where) : null;
        this.lockMode = lockMode;
    }

    @Override
    public From getFrom() {
        return this.from;
    }

    @Override
    public List<OrderByField> getOrderBy() {
        return this.orderBy;
    }

    @Override
    public OptionalLong getLimit() {
        return this.limit == -1L ? OptionalLong.empty() : OptionalLong.of(this.limit);
    }

    @Override
    public OptionalLong getOffset() {
        return this.offset == -1L ? OptionalLong.empty() : OptionalLong.of(this.offset);
    }

    @Override
    public boolean isDistinct() {
        return this.distinct;
    }

    @Override
    @Nullable
    public LockMode getLockMode() {
        return this.lockMode;
    }

    @Override
    public void visit(Visitor visitor) {
        Assert.notNull((Object)visitor, (String)"Visitor must not be null!");
        visitor.enter(this);
        this.selectList.visit(visitor);
        this.from.visit(visitor);
        this.joins.forEach(it -> it.visit(visitor));
        this.visitIfNotNull(this.where, visitor);
        this.orderBy.forEach(it -> it.visit(visitor));
        visitor.leave(this);
    }

    private void visitIfNotNull(@Nullable Visitable visitable, Visitor visitor) {
        if (visitable != null) {
            visitable.visit(visitor);
        }
    }
}

