/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.ArrayUtils;
import org.janusgraph.graphdb.database.serialize.AttributeUtils;
import org.janusgraph.graphdb.query.JanusGraphPredicate;

public enum Cmp implements JanusGraphPredicate
{
    EQUAL{

        @Override
        public boolean isValidValueType(Class<?> clazz) {
            return true;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return true;
        }

        @Override
        public boolean test(Object value, Object condition) {
            if (condition == null) {
                return value == null;
            }
            return condition.equals(value) || condition.getClass().isArray() && ArrayUtils.isEquals((Object)condition, (Object)value);
        }

        public String toString() {
            return "=";
        }

        @Override
        public JanusGraphPredicate negate() {
            return NOT_EQUAL;
        }
    }
    ,
    NOT_EQUAL{

        @Override
        public boolean isValidValueType(Class<?> clazz) {
            return true;
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return true;
        }

        @Override
        public boolean test(Object value, Object condition) {
            return value != null && !value.equals(condition);
        }

        public String toString() {
            return "<>";
        }

        @Override
        public JanusGraphPredicate negate() {
            return EQUAL;
        }
    }
    ,
    LESS_THAN{

        @Override
        public boolean isValidValueType(Class<?> clazz) {
            Preconditions.checkNotNull(clazz);
            return Comparable.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof Comparable;
        }

        @Override
        public boolean test(Object value, Object condition) {
            Integer cmp = AttributeUtils.compare(value, condition);
            return cmp != null && cmp < 0;
        }

        public String toString() {
            return "<";
        }

        @Override
        public JanusGraphPredicate negate() {
            return GREATER_THAN_EQUAL;
        }
    }
    ,
    LESS_THAN_EQUAL{

        @Override
        public boolean isValidValueType(Class<?> clazz) {
            Preconditions.checkNotNull(clazz);
            return Comparable.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof Comparable;
        }

        @Override
        public boolean test(Object value, Object condition) {
            Integer cmp = AttributeUtils.compare(value, condition);
            return cmp != null && cmp <= 0;
        }

        public String toString() {
            return "<=";
        }

        @Override
        public JanusGraphPredicate negate() {
            return GREATER_THAN;
        }
    }
    ,
    GREATER_THAN{

        @Override
        public boolean isValidValueType(Class<?> clazz) {
            Preconditions.checkNotNull(clazz);
            return Comparable.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof Comparable;
        }

        @Override
        public boolean test(Object value, Object condition) {
            Integer cmp = AttributeUtils.compare(value, condition);
            return cmp != null && cmp > 0;
        }

        public String toString() {
            return ">";
        }

        @Override
        public JanusGraphPredicate negate() {
            return LESS_THAN_EQUAL;
        }
    }
    ,
    GREATER_THAN_EQUAL{

        @Override
        public boolean isValidValueType(Class<?> clazz) {
            Preconditions.checkNotNull(clazz);
            return Comparable.class.isAssignableFrom(clazz);
        }

        @Override
        public boolean isValidCondition(Object condition) {
            return condition instanceof Comparable;
        }

        @Override
        public boolean test(Object value, Object condition) {
            Integer cmp = AttributeUtils.compare(value, condition);
            return cmp != null && cmp >= 0;
        }

        public String toString() {
            return ">=";
        }

        @Override
        public JanusGraphPredicate negate() {
            return LESS_THAN;
        }
    };


    @Override
    public boolean hasNegation() {
        return true;
    }

    @Override
    public boolean isQNF() {
        return true;
    }
}

