/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.command.changelog;

import java.util.Date;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.command.changelog.ChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractChangeLogCommand
extends AbstractCommand
implements ChangeLogCommand {
    protected abstract ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository var1, ScmFileSet var2, Date var3, Date var4, ScmBranch var5, String var6) throws ScmException;

    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository repository, ScmFileSet fileSet, ScmVersion startVersion, ScmVersion endVersion, String datePattern) throws ScmException {
        throw new ScmException("Unsupported method for this provider.");
    }

    public ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        Date startDate = parameters.getDate(CommandParameter.START_DATE, null);
        Date endDate = parameters.getDate(CommandParameter.END_DATE, null);
        int numDays = parameters.getInt(CommandParameter.NUM_DAYS, 0);
        ScmBranch branch = (ScmBranch)parameters.getScmVersion(CommandParameter.BRANCH, null);
        ScmVersion startVersion = parameters.getScmVersion(CommandParameter.START_SCM_VERSION, null);
        ScmVersion endVersion = parameters.getScmVersion(CommandParameter.END_SCM_VERSION, null);
        String datePattern = parameters.getString(CommandParameter.CHANGELOG_DATE_PATTERN, null);
        if (startVersion != null && StringUtils.isNotEmpty((String)startVersion.getName())) {
            return this.executeChangeLogCommand(repository, fileSet, startVersion, endVersion, datePattern);
        }
        if (numDays != 0 && (startDate != null || endDate != null)) {
            throw new ScmException("Start or end date cannot be set if num days is set.");
        }
        if (endDate != null && startDate == null) {
            throw new ScmException("The end date is set but the start date isn't.");
        }
        if (numDays > 0) {
            startDate = new Date(System.currentTimeMillis() - (long)numDays * 24L * 60L * 60L * 1000L);
            endDate = new Date(System.currentTimeMillis() + 86400000L);
        } else if (endDate == null) {
            endDate = new Date();
        }
        return this.executeChangeLogCommand(repository, fileSet, startDate, endDate, branch, datePattern);
    }
}

