/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.edit.EditScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jdom.filter.ContentFilter;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;

public abstract class AbstractRewritePomsPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;
    private static final String LS = System.getProperty("line.separator");
    private String pomSuffix;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        this.transform(releaseDescriptor, settings, reactorProjects, false, result);
        result.setResultCode(0);
        return result;
    }

    private void transform(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean simulate, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        Iterator it = reactorProjects.iterator();
        while (it.hasNext()) {
            MavenProject project = (MavenProject)it.next();
            this.logInfo(result, "Transforming '" + project.getName() + "'...");
            this.transformProject(project, releaseDescriptor, settings, reactorProjects, simulate, result);
        }
    }

    private static String readXmlFile(File file) throws IOException {
        return IOUtil.toString((InputStream)new FileInputStream(file), (String)"UTF-8");
    }

    private void transformProject(MavenProject project, ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects, boolean simulate, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        ScmProvider provider;
        ScmRepository scmRepository;
        Document document;
        String intro = null;
        String outtro = null;
        try {
            String content = AbstractRewritePomsPhase.readXmlFile(ReleaseUtil.getStandardPom(project));
            content = content.replaceAll("<([^!][^>]*?)\\s{2,}([^>]*?)>", "<$1 $2>");
            content = content.replaceAll("(\\s{2,}|[^\\s])/>", "$1 />");
            SAXBuilder builder = new SAXBuilder();
            document = builder.build((Reader)new StringReader(content));
            this.normaliseLineEndings(document);
            StringWriter w = new StringWriter();
            Format format = Format.getRawFormat();
            format.setLineSeparator(LS);
            XMLOutputter out = new XMLOutputter(format);
            out.output(document.getRootElement(), (Writer)w);
            int index = content.indexOf(w.toString());
            if (index >= 0) {
                intro = content.substring(0, index);
                outtro = content.substring(index + w.toString().length());
            }
        }
        catch (JDOMException e) {
            throw new ReleaseExecutionException("Error reading POM: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ReleaseExecutionException("Error reading POM: " + e.getMessage(), e);
        }
        try {
            scmRepository = this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, settings);
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(scmRepository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        this.transformDocument(project, document.getRootElement(), releaseDescriptor, reactorProjects, scmRepository, result);
        File pomFile = ReleaseUtil.getStandardPom(project);
        if (simulate) {
            File outputFile = new File(pomFile.getParentFile(), pomFile.getName() + "." + this.pomSuffix);
            this.writePom(outputFile, document, releaseDescriptor, project.getModelVersion(), intro, outtro);
        } else {
            this.writePom(pomFile, document, releaseDescriptor, project.getModelVersion(), intro, outtro, scmRepository, provider);
        }
    }

    private void normaliseLineEndings(Document document) {
        Iterator i = document.getDescendants((Filter)new ContentFilter(8));
        while (i.hasNext()) {
            Comment c = (Comment)i.next();
            c.setText(c.getText().replaceAll("\n", LS));
        }
    }

    private void transformDocument(MavenProject project, Element rootElement, ReleaseDescriptor releaseDescriptor, List reactorProjects, ScmRepository scmRepository, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        Element pluginsRoot;
        Element buildRoot;
        Element dependencyRoot;
        Namespace namespace = rootElement.getNamespace();
        Map mappedVersions = this.getNextVersionMap(releaseDescriptor);
        Map originalVersions = this.getOriginalVersionMap(releaseDescriptor, reactorProjects);
        Map resolvedSnapshotDependencies = releaseDescriptor.getResolvedSnapshotDependencies();
        Element properties = rootElement.getChild("properties", namespace);
        String parentVersion = this.rewriteParent(project, rootElement, namespace, mappedVersions, originalVersions);
        String projectId = ArtifactUtils.versionlessKey((String)project.getGroupId(), (String)project.getArtifactId());
        this.rewriteVersion(rootElement, namespace, mappedVersions, projectId, project, parentVersion);
        this.rewriteDependencies(project.getDependencies(), rootElement, mappedVersions, resolvedSnapshotDependencies, originalVersions, projectId, properties, result, releaseDescriptor);
        if (project.getDependencyManagement() != null && (dependencyRoot = rootElement.getChild("dependencyManagement", namespace)) != null) {
            this.rewriteDependencies(project.getDependencyManagement().getDependencies(), dependencyRoot, mappedVersions, resolvedSnapshotDependencies, originalVersions, projectId, properties, result, releaseDescriptor);
        }
        if (project.getBuild() != null && (buildRoot = rootElement.getChild("build", namespace)) != null) {
            Element pluginsRoot2;
            this.rewritePlugins(project.getBuildPlugins(), buildRoot, mappedVersions, resolvedSnapshotDependencies, originalVersions, projectId, properties, result, releaseDescriptor);
            if (project.getPluginManagement() != null && (pluginsRoot2 = buildRoot.getChild("pluginManagement", namespace)) != null) {
                this.rewritePlugins(project.getPluginManagement().getPlugins(), pluginsRoot2, mappedVersions, resolvedSnapshotDependencies, originalVersions, projectId, properties, result, releaseDescriptor);
            }
            this.rewriteExtensions(project.getBuildExtensions(), buildRoot, mappedVersions, resolvedSnapshotDependencies, originalVersions, projectId, properties, result, releaseDescriptor);
        }
        if (project.getReporting() != null && (pluginsRoot = rootElement.getChild("reporting", namespace)) != null) {
            this.rewriteReportPlugins(project.getReportPlugins(), pluginsRoot, mappedVersions, resolvedSnapshotDependencies, originalVersions, projectId, properties, result, releaseDescriptor);
        }
        this.transformScm(project, rootElement, namespace, releaseDescriptor, projectId, scmRepository, result, ReleaseUtil.getRootProject(reactorProjects));
    }

    private void rewriteVersion(Element rootElement, Namespace namespace, Map mappedVersions, String projectId, MavenProject project, String parentVersion) throws ReleaseFailureException {
        Element versionElement = rootElement.getChild("version", namespace);
        String version = (String)mappedVersions.get(projectId);
        if (version == null) {
            throw new ReleaseFailureException("Version for '" + project.getName() + "' was not mapped");
        }
        if (versionElement == null) {
            if (!version.equals(parentVersion)) {
                Element artifactIdElement = rootElement.getChild("artifactId", namespace);
                int index = rootElement.indexOf((Content)artifactIdElement);
                versionElement = new Element("version", namespace);
                versionElement.setText(version);
                rootElement.addContent(index + 1, (Content)new Text("\n  "));
                rootElement.addContent(index + 2, (Content)versionElement);
            }
        } else {
            versionElement.setText(version);
        }
    }

    private String rewriteParent(MavenProject project, Element rootElement, Namespace namespace, Map mappedVersions, Map originalVersions) throws ReleaseFailureException {
        String parentVersion = null;
        if (project.hasParent()) {
            Element parentElement = rootElement.getChild("parent", namespace);
            Element versionElement = parentElement.getChild("version", namespace);
            MavenProject parent = project.getParent();
            String key = ArtifactUtils.versionlessKey((String)parent.getGroupId(), (String)parent.getArtifactId());
            parentVersion = (String)mappedVersions.get(key);
            if (parentVersion == null) {
                if (parent.getVersion().equals(originalVersions.get(key))) {
                    throw new ReleaseFailureException("Version for parent '" + parent.getName() + "' was not mapped");
                }
            } else {
                versionElement.setText(parentVersion);
            }
        }
        return parentVersion;
    }

    private void rewriteDependencies(List dependencies, Element dependencyRoot, Map mappedVersions, Map resolvedSnapshotDependencies, Map originalVersions, String projectId, Element properties, ReleaseResult result, ReleaseDescriptor releaseDescriptor) throws ReleaseExecutionException, ReleaseFailureException {
        if (dependencies != null) {
            ArrayList<String> dependenciesAlreadyChanged = new ArrayList<String>();
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                Dependency dep = (Dependency)i.next();
                String depId = ArtifactUtils.versionlessKey((String)dep.getGroupId(), (String)dep.getArtifactId());
                if (dependenciesAlreadyChanged.contains(depId)) continue;
                dependenciesAlreadyChanged.add(depId);
                this.updateDomVersion(dep.getGroupId(), dep.getArtifactId(), mappedVersions, resolvedSnapshotDependencies, dep.getVersion(), originalVersions, "dependencies", "dependency", dependencyRoot, projectId, properties, result, releaseDescriptor);
            }
        }
    }

    private void rewritePlugins(List plugins, Element pluginRoot, Map mappedVersions, Map resolvedSnapshotDependencies, Map originalVersions, String projectId, Element properties, ReleaseResult result, ReleaseDescriptor releaseDescriptor) throws ReleaseExecutionException, ReleaseFailureException {
        if (plugins != null) {
            Iterator i = plugins.iterator();
            while (i.hasNext()) {
                Plugin plugin = (Plugin)i.next();
                if (plugin.getVersion() == null) continue;
                this.updateDomVersion(plugin.getGroupId(), plugin.getArtifactId(), mappedVersions, resolvedSnapshotDependencies, plugin.getVersion(), originalVersions, "plugins", "plugin", pluginRoot, projectId, properties, result, releaseDescriptor);
            }
        }
    }

    private void rewriteExtensions(List extensions, Element extensionRoot, Map mappedVersions, Map resolvedSnapshotDependencies, Map originalVersions, String projectId, Element properties, ReleaseResult result, ReleaseDescriptor releaseDescriptor) throws ReleaseExecutionException, ReleaseFailureException {
        if (extensions != null) {
            Iterator i = extensions.iterator();
            while (i.hasNext()) {
                Extension extension = (Extension)i.next();
                if (extension.getVersion() == null) continue;
                this.updateDomVersion(extension.getGroupId(), extension.getArtifactId(), mappedVersions, resolvedSnapshotDependencies, extension.getVersion(), originalVersions, "extensions", "extension", extensionRoot, projectId, properties, result, releaseDescriptor);
            }
        }
    }

    private void rewriteReportPlugins(List plugins, Element pluginRoot, Map mappedVersions, Map resolvedSnapshotDependencies, Map originalVersions, String projectId, Element properties, ReleaseResult result, ReleaseDescriptor releaseDescriptor) throws ReleaseExecutionException, ReleaseFailureException {
        if (plugins != null) {
            Iterator i = plugins.iterator();
            while (i.hasNext()) {
                ReportPlugin plugin = (ReportPlugin)i.next();
                if (plugin.getVersion() == null) continue;
                this.updateDomVersion(plugin.getGroupId(), plugin.getArtifactId(), mappedVersions, resolvedSnapshotDependencies, plugin.getVersion(), originalVersions, "plugins", "plugin", pluginRoot, projectId, properties, result, releaseDescriptor);
            }
        }
    }

    private List getDependencies(String groupId, String artifactId, String groupTagName, String tagName, Element dependencyRoot) throws JDOMException {
        XPath xpath;
        if (!StringUtils.isEmpty((String)dependencyRoot.getNamespaceURI())) {
            xpath = XPath.newInstance((String)("./pom:" + groupTagName + "/pom:" + tagName + "[pom:groupId='" + groupId + "' and pom:artifactId='" + artifactId + "']"));
            xpath.addNamespace("pom", dependencyRoot.getNamespaceURI());
        } else {
            xpath = XPath.newInstance((String)("./" + groupTagName + "/" + tagName + "[groupId='" + groupId + "' and artifactId='" + artifactId + "']"));
        }
        List dependencies = xpath.selectNodes((Object)dependencyRoot);
        if ((dependencies == null || dependencies.isEmpty()) && groupId.indexOf("${") == -1 && ((dependencies = this.getDependencies("${project.groupId}", artifactId, groupTagName, tagName, dependencyRoot)) == null || dependencies.isEmpty())) {
            dependencies = this.getDependencies("${pom.groupId}", artifactId, groupTagName, tagName, dependencyRoot);
        }
        return dependencies;
    }

    private void updateDomVersion(String groupId, String artifactId, Map mappedVersions, Map resolvedSnapshotDepedencies, String version, Map originalVersions, String groupTagName, String tagName, Element dependencyRoot, String projectId, Element properties, ReleaseResult result, ReleaseDescriptor releaseDescriptor) throws ReleaseExecutionException, ReleaseFailureException {
        String key = ArtifactUtils.versionlessKey((String)groupId, (String)artifactId);
        String mappedVersion = (String)mappedVersions.get(key);
        String resolvedSnapshotVersion = this.getResolvedSnapshotVersion(key, resolvedSnapshotDepedencies);
        Object originalVersion = originalVersions.get(key);
        if (originalVersion == null) {
            originalVersion = this.getOriginalResolvedSnapshotVersion(key, resolvedSnapshotDepedencies);
        }
        try {
            List dependencies = this.getDependencies(groupId, artifactId, groupTagName, tagName, dependencyRoot);
            Iterator i = dependencies.iterator();
            while (i.hasNext()) {
                Element dependency = (Element)i.next();
                String dependencyVersion = "";
                Element versionElement = null;
                if (dependency != null && (versionElement = dependency.getChild("version", dependencyRoot.getNamespace())) != null) {
                    dependencyVersion = versionElement.getTextTrim();
                }
                if (mappedVersion != null && mappedVersion.endsWith("SNAPSHOT") && !dependencyVersion.endsWith("SNAPSHOT") && !releaseDescriptor.isUpdateDependencies()) {
                    return;
                }
                if (!version.equals(originalVersion) && !dependencyVersion.equals(originalVersion)) continue;
                if (mappedVersion != null || resolvedSnapshotVersion != null) {
                    this.logInfo(result, "Updating " + artifactId + " to " + (mappedVersion != null ? mappedVersion : resolvedSnapshotVersion));
                    if (dependency == null || versionElement == null) continue;
                    if (mappedVersion == null) {
                        versionElement.setText(resolvedSnapshotVersion);
                        return;
                    }
                    String versionText = versionElement.getTextTrim();
                    if (originalVersion.equals(versionText) || !mappedVersion.equals(mappedVersions.get(projectId))) {
                        versionElement.setText(mappedVersion);
                        continue;
                    }
                    if (versionText.matches("\\$\\{project.+\\}") || versionText.matches("\\$\\{pom.+\\}") || "${version}".equals(versionText)) {
                        this.logInfo(result, "Ignoring artifact version update for expression: " + versionText);
                        continue;
                    }
                    if (versionText.matches("\\$\\{.+\\}") && properties != null) {
                        String expression = versionText.substring(2, versionText.length() - 1);
                        Element property = properties.getChild(expression, properties.getNamespace());
                        if (property != null) {
                            String propertyValue = property.getTextTrim();
                            if (originalVersion.equals(propertyValue)) {
                                property.setText(mappedVersion);
                                continue;
                            }
                            if (mappedVersion.equals(propertyValue)) {
                                this.logInfo(result, "Ignoring artifact version update for expression: " + mappedVersion + " because it is already updated.");
                                continue;
                            }
                            if (mappedVersion.equals(versionText)) continue;
                            if (mappedVersion.matches("\\$\\{project.+\\}") || mappedVersion.matches("\\$\\{pom.+\\}") || "${version}".equals(mappedVersion)) {
                                this.logInfo(result, "Ignoring artifact version update for expression: " + mappedVersion);
                                continue;
                            }
                            throw new ReleaseFailureException("The artifact (" + key + ") requires a " + "different version (" + mappedVersion + ") than what is found (" + propertyValue + ") for the expression (" + expression + ") in the " + "project (" + projectId + ").");
                        }
                        throw new ReleaseFailureException("The version could not be updated: " + versionText);
                    }
                    throw new ReleaseFailureException("The version could not be updated: " + versionText);
                }
                throw new ReleaseFailureException("Version '" + version + "' for " + tagName + " '" + key + "' was not mapped");
            }
        }
        catch (JDOMException e) {
            throw new ReleaseExecutionException("Unable to locate " + tagName + " to process in document", e);
        }
    }

    private void writePom(File pomFile, Document document, ReleaseDescriptor releaseDescriptor, String modelVersion, String intro, String outtro, ScmRepository repository, ScmProvider provider) throws ReleaseExecutionException, ReleaseScmCommandException {
        try {
            EditScmResult result;
            if ((releaseDescriptor.isScmUseEditMode() || provider.requiresEditMode()) && !(result = provider.edit(repository, new ScmFileSet(new File(releaseDescriptor.getWorkingDirectory()), pomFile))).isSuccess()) {
                throw new ReleaseScmCommandException("Unable to enable editing on the POM", (ScmResult)result);
            }
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error occurred enabling edit mode: " + e.getMessage(), e);
        }
        this.writePom(pomFile, document, releaseDescriptor, modelVersion, intro, outtro);
    }

    private void writePom(File pomFile, Document document, ReleaseDescriptor releaseDescriptor, String modelVersion, String intro, String outtro) throws ReleaseExecutionException {
        Element rootElement = document.getRootElement();
        if (releaseDescriptor.isAddSchema()) {
            Namespace pomNamespace = Namespace.getNamespace((String)"", (String)("http://maven.apache.org/POM/" + modelVersion));
            rootElement.setNamespace(pomNamespace);
            Namespace xsiNamespace = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
            rootElement.addNamespaceDeclaration(xsiNamespace);
            if (rootElement.getAttribute("schemaLocation", xsiNamespace) == null) {
                rootElement.setAttribute("schemaLocation", "http://maven.apache.org/POM/" + modelVersion + " http://maven.apache.org/maven-v" + modelVersion.replace('.', '_') + ".xsd", xsiNamespace);
            }
            ElementFilter elementFilter = new ElementFilter(Namespace.getNamespace((String)""));
            Iterator i = rootElement.getDescendants((Filter)elementFilter);
            while (i.hasNext()) {
                Element e = (Element)i.next();
                e.setNamespace(pomNamespace);
            }
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(pomFile), "UTF-8");
            if (intro != null) {
                writer.write(intro);
            }
            Format format = Format.getRawFormat();
            format.setLineSeparator(LS);
            XMLOutputter out = new XMLOutputter(format);
            out.output(document.getRootElement(), (Writer)writer);
            if (outtro != null) {
                writer.write(outtro);
            }
        }
        catch (IOException e) {
            try {
                throw new ReleaseExecutionException("Error writing POM: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, Settings settings, List reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        this.transform(releaseDescriptor, settings, reactorProjects, true, result);
        result.setResultCode(0);
        return result;
    }

    public ReleaseResult clean(List reactorProjects) {
        ReleaseResult result = new ReleaseResult();
        super.clean(reactorProjects);
        if (reactorProjects != null) {
            Iterator i = reactorProjects.iterator();
            while (i.hasNext()) {
                MavenProject project = (MavenProject)i.next();
                File pomFile = ReleaseUtil.getStandardPom(project);
                File file = new File(pomFile.getParentFile(), pomFile.getName() + "." + this.pomSuffix);
                if (!file.exists()) continue;
                file.delete();
            }
        }
        result.setResultCode(0);
        return result;
    }

    protected abstract String getResolvedSnapshotVersion(String var1, Map var2);

    protected abstract Map getOriginalVersionMap(ReleaseDescriptor var1, List var2);

    protected abstract Map getNextVersionMap(ReleaseDescriptor var1);

    protected abstract void transformScm(MavenProject var1, Element var2, Namespace var3, ReleaseDescriptor var4, String var5, ScmRepository var6, ReleaseResult var7, MavenProject var8) throws ReleaseExecutionException;

    protected String getOriginalResolvedSnapshotVersion(String artifactVersionlessKey, Map resolvedSnapshots) {
        Map versionsMap = (Map)resolvedSnapshots.get(artifactVersionlessKey);
        if (versionsMap != null) {
            return (String)versionsMap.get("original");
        }
        return null;
    }

    protected Element rewriteElement(String name, String value, Element root, Namespace namespace) {
        Element tagElement = root.getChild(name, namespace);
        if (tagElement != null) {
            if (value != null) {
                tagElement.setText(value);
            } else {
                int index = root.indexOf((Content)tagElement);
                root.removeContent(index);
                for (int i = index - 1; i >= 0 && root.getContent(i) instanceof Text; --i) {
                    root.removeContent(i);
                }
            }
        } else if (value != null) {
            Element element = new Element(name, namespace);
            element.setText(value);
            root.addContent("  ").addContent((Content)element).addContent("\n  ");
            tagElement = element;
        }
        return tagElement;
    }
}

