/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;

public abstract class AbstractReleasePomsPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    protected ScmRepository getScmRepository(ReleaseDescriptor releaseDescriptor, Settings settings) throws ReleaseFailureException, ReleaseExecutionException {
        try {
            return this.scmRepositoryConfigurator.getConfiguredRepository(releaseDescriptor, settings);
        }
        catch (ScmRepositoryException exception) {
            throw new ReleaseScmRepositoryException(exception.getMessage(), exception.getValidationMessages());
        }
        catch (NoSuchScmProviderException exception) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + exception.getMessage(), exception);
        }
    }

    protected ScmProvider getScmProvider(ScmRepository scmRepository) throws ReleaseExecutionException {
        try {
            return this.scmRepositoryConfigurator.getRepositoryProvider(scmRepository);
        }
        catch (NoSuchScmProviderException exception) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + exception.getMessage(), exception);
        }
    }
}

