/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.DefaultMemStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreLABImpl;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.NonThreadSafeMemStoreSizing;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestDefaultMemStore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDefaultMemStore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestDefaultMemStore.class);
    @Rule
    public TestName name = new TestName();
    protected AbstractMemStore memstore;
    protected static final int ROW_COUNT = 10;
    protected static final int QUALIFIER_COUNT = 10;
    protected static final byte[] FAMILY = Bytes.toBytes((String)"column");
    protected MultiVersionConcurrencyControl mvcc;
    protected AtomicLong startSeqNum = new AtomicLong(0L);
    protected ChunkCreator chunkCreator;

    private String getName() {
        return this.name.getMethodName();
    }

    @Before
    public void setUp() throws Exception {
        this.internalSetUp();
        this.chunkCreator = ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null, (float)0.1f);
        this.memstore = new DefaultMemStore();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        ChunkCreator.getInstance().clearChunkIds();
    }

    protected void internalSetUp() throws Exception {
        this.mvcc = new MultiVersionConcurrencyControl();
    }

    @Test
    public void testPutSameKey() {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        KeyValue kv = new KeyValue(bytes, bytes, bytes, bytes);
        this.memstore.add((Cell)kv, null);
        byte[] other = Bytes.toBytes((String)"somethingelse");
        KeyValue samekey = new KeyValue(bytes, bytes, bytes, other);
        this.memstore.add((Cell)samekey, null);
        Cell found = this.memstore.getActive().first();
        Assert.assertEquals((long)1L, (long)this.memstore.getActive().getCellsCount());
        Assert.assertTrue((String)Bytes.toString((byte[])found.getValueArray()), (boolean)CellUtil.matchingValue((Cell)samekey, (Cell)found));
    }

    @Test
    public void testPutSameCell() {
        byte[] bytes = Bytes.toBytes((String)this.getName());
        KeyValue kv = new KeyValue(bytes, bytes, bytes, bytes);
        NonThreadSafeMemStoreSizing sizeChangeForFirstCell = new NonThreadSafeMemStoreSizing();
        this.memstore.add((Cell)kv, (MemStoreSizing)sizeChangeForFirstCell);
        NonThreadSafeMemStoreSizing sizeChangeForSecondCell = new NonThreadSafeMemStoreSizing();
        this.memstore.add((Cell)kv, (MemStoreSizing)sizeChangeForSecondCell);
        Assert.assertEquals((long)Segment.getCellLength((Cell)kv), (long)sizeChangeForFirstCell.getMemStoreSize().getDataSize());
        MutableSegment segment = this.memstore.getActive();
        MemStoreLAB msLab = segment.getMemStoreLAB();
        if (msLab != null) {
            Assert.assertEquals((long)Segment.getCellLength((Cell)kv), (long)sizeChangeForSecondCell.getMemStoreSize().getDataSize());
            if (msLab instanceof MemStoreLABImpl) {
                Assert.assertEquals((long)(2 * Segment.getCellLength((Cell)kv) + 4), (long)((MemStoreLABImpl)msLab).getCurrentChunk().getNextFreeOffset());
            }
        } else {
            Assert.assertEquals((long)0L, (long)sizeChangeForSecondCell.getMemStoreSize().getDataSize());
            Assert.assertEquals((long)0L, (long)sizeChangeForSecondCell.getMemStoreSize().getHeapSize());
        }
    }

    @Test
    public void testScanAcrossSnapshot() throws IOException {
        Object scanner2;
        int rowCount = this.addRows(this.memstore);
        List memstorescanners = this.memstore.getScanners(0L);
        Scan scan = new Scan();
        ArrayList result = new ArrayList();
        Configuration conf = HBaseConfiguration.create();
        ScanInfo scanInfo = new ScanInfo(conf, null, 0, 1, Long.MAX_VALUE, KeepDeletedCells.FALSE, 65536L, 0L, this.memstore.getComparator(), false);
        int count = 0;
        try (Object s = new StoreScanner(scan, scanInfo, null, memstorescanners);){
            while (s.next(result)) {
                LOG.info(Objects.toString(result));
                ++count;
                Assert.assertEquals((long)rowCount, (long)result.size());
                result.clear();
            }
        }
        Assert.assertEquals((long)rowCount, (long)count);
        for (Object scanner2 : memstorescanners) {
            scanner2.close();
        }
        memstorescanners = this.memstore.getScanners(this.mvcc.getReadPoint());
        count = 0;
        s = new StoreScanner(scan, scanInfo, null, memstorescanners);
        scanner2 = null;
        try {
            while (s.next(result)) {
                LOG.info(Objects.toString(result));
                Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)((Cell)result.get(0)), (byte[])Bytes.toBytes((int)count)));
                Assert.assertEquals((long)rowCount, (long)result.size());
                if (++count == 2) {
                    this.memstore.snapshot();
                    LOG.info("Snapshotted");
                }
                result.clear();
            }
        }
        catch (Throwable throwable) {
            scanner2 = throwable;
            throw throwable;
        }
        finally {
            if (s != null) {
                if (scanner2 != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)scanner2).addSuppressed(throwable);
                    }
                } else {
                    s.close();
                }
            }
        }
        Assert.assertEquals((long)rowCount, (long)count);
        for (Object scanner2 : memstorescanners) {
            scanner2.close();
        }
        memstorescanners = this.memstore.getScanners(this.mvcc.getReadPoint());
        long ts = System.currentTimeMillis();
        count = 0;
        int snapshotIndex = 5;
        try (StoreScanner s = new StoreScanner(scan, scanInfo, null, memstorescanners);){
            while (s.next(result)) {
                LOG.info(Objects.toString(result));
                Assert.assertTrue((boolean)CellUtil.matchingRows((Cell)((Cell)result.get(0)), (byte[])Bytes.toBytes((int)count)));
                Assert.assertEquals((String)("count=" + count + ", result=" + result), (long)rowCount, (long)result.size());
                if (++count == snapshotIndex) {
                    MemStoreSnapshot snapshot = this.memstore.snapshot();
                    this.memstore.clearSnapshot(snapshot.getId());
                    this.addRows((MemStore)this.memstore, ts);
                    LOG.info("Snapshotted, cleared it and then added values (which wont be seen)");
                }
                result.clear();
            }
        }
        Assert.assertEquals((long)rowCount, (long)count);
    }

    @Test
    public void testScanAcrossSnapshot2() throws IOException, CloneNotSupportedException {
        byte[] one = Bytes.toBytes((int)1);
        byte[] two = Bytes.toBytes((int)2);
        byte[] f = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        byte[] v = Bytes.toBytes((int)3);
        KeyValue kv1 = new KeyValue(one, f, q, v);
        KeyValue kv2 = new KeyValue(two, f, q, v);
        this.memstore.add((Cell)kv1.clone(), null);
        this.memstore.add((Cell)kv2.clone(), null);
        this.verifyScanAcrossSnapshot2(kv1, kv2);
        this.memstore.snapshot();
        this.verifyScanAcrossSnapshot2(kv1, kv2);
        this.memstore = new DefaultMemStore();
        this.memstore.add((Cell)kv1.clone(), null);
        this.memstore.snapshot();
        this.memstore.add((Cell)kv2.clone(), null);
        this.verifyScanAcrossSnapshot2(kv1, kv2);
    }

    protected void verifyScanAcrossSnapshot2(KeyValue kv1, KeyValue kv2) throws IOException {
        List memstorescanners = this.memstore.getScanners(this.mvcc.getReadPoint());
        Assert.assertEquals((long)2L, (long)memstorescanners.size());
        KeyValueScanner scanner0 = (KeyValueScanner)memstorescanners.get(0);
        KeyValueScanner scanner1 = (KeyValueScanner)memstorescanners.get(1);
        scanner0.seek((Cell)KeyValueUtil.createFirstOnRow((byte[])HConstants.EMPTY_START_ROW));
        scanner1.seek((Cell)KeyValueUtil.createFirstOnRow((byte[])HConstants.EMPTY_START_ROW));
        Cell n0 = scanner0.next();
        Cell n1 = scanner1.next();
        Assert.assertTrue((kv1.equals((Object)n0) || kv1.equals((Object)n1) ? 1 : 0) != 0);
        Assert.assertTrue((kv2.equals((Object)n0) || kv2.equals((Object)n1) || kv2.equals((Object)scanner0.next()) || kv2.equals((Object)scanner1.next()) ? 1 : 0) != 0);
        Assert.assertNull((Object)scanner0.next());
        Assert.assertNull((Object)scanner1.next());
    }

    protected void assertScannerResults(KeyValueScanner scanner, KeyValue[] expected) throws IOException {
        Cell next;
        scanner.seek((Cell)KeyValueUtil.createFirstOnRow((byte[])new byte[0]));
        ArrayList returned = Lists.newArrayList();
        while ((next = scanner.next()) != null) {
            returned.add(next);
        }
        Assert.assertTrue((String)("Got:\n" + Joiner.on((String)"\n").join((Iterable)returned) + "\nExpected:\n" + Joiner.on((String)"\n").join((Object[])expected)), (boolean)Iterables.elementsEqual(Arrays.asList(expected), (Iterable)returned));
        Assert.assertNull((Object)scanner.peek());
    }

    @Test
    public void testMemstoreConcurrentControl() throws IOException {
        byte[] row = Bytes.toBytes((int)1);
        byte[] f = Bytes.toBytes((String)"family");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] v = Bytes.toBytes((String)"value");
        MultiVersionConcurrencyControl.WriteEntry w = this.mvcc.begin();
        KeyValue kv1 = new KeyValue(row, f, q1, v);
        kv1.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv1, null);
        KeyValueScanner s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[0]);
        this.mvcc.completeAndWait(w);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv1});
        w = this.mvcc.begin();
        KeyValue kv2 = new KeyValue(row, f, q2, v);
        kv2.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv2, null);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv1});
        this.mvcc.completeAndWait(w);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv1, kv2});
    }

    @Test
    public void testMemstoreEditsVisibilityWithSameKey() throws IOException {
        byte[] row = Bytes.toBytes((int)1);
        byte[] f = Bytes.toBytes((String)"family");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] v1 = Bytes.toBytes((String)"value1");
        byte[] v2 = Bytes.toBytes((String)"value2");
        MultiVersionConcurrencyControl.WriteEntry w = this.mvcc.begin();
        KeyValue kv11 = new KeyValue(row, f, q1, v1);
        kv11.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv11, null);
        KeyValue kv12 = new KeyValue(row, f, q2, v1);
        kv12.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv12, null);
        this.mvcc.completeAndWait(w);
        KeyValueScanner s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kv12});
        w = this.mvcc.begin();
        KeyValue kv21 = new KeyValue(row, f, q1, v2);
        kv21.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv21, null);
        KeyValue kv22 = new KeyValue(row, f, q2, v2);
        kv22.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv22, null);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kv12});
        this.mvcc.completeAndWait(w);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv21, kv11, kv22, kv12});
    }

    @Test
    public void testMemstoreDeletesVisibilityWithSameKey() throws IOException {
        byte[] row = Bytes.toBytes((int)1);
        byte[] f = Bytes.toBytes((String)"family");
        byte[] q1 = Bytes.toBytes((String)"q1");
        byte[] q2 = Bytes.toBytes((String)"q2");
        byte[] v1 = Bytes.toBytes((String)"value1");
        MultiVersionConcurrencyControl.WriteEntry w = this.mvcc.begin();
        KeyValue kv11 = new KeyValue(row, f, q1, v1);
        kv11.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv11, null);
        KeyValue kv12 = new KeyValue(row, f, q2, v1);
        kv12.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kv12, null);
        this.mvcc.completeAndWait(w);
        KeyValueScanner s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kv12});
        w = this.mvcc.begin();
        KeyValue kvDel = new KeyValue(row, f, q2, kv11.getTimestamp(), KeyValue.Type.DeleteColumn);
        kvDel.setSequenceId(w.getWriteNumber());
        this.memstore.add((Cell)kvDel, null);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kv12});
        this.mvcc.completeAndWait(w);
        s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
        this.assertScannerResults(s, new KeyValue[]{kv11, kvDel, kv12});
    }

    @Test
    public void testReadOwnWritesUnderConcurrency() throws Throwable {
        int i;
        int NUM_THREADS = 8;
        ReadOwnWritesTester[] threads = new ReadOwnWritesTester[NUM_THREADS];
        AtomicReference<Throwable> caught = new AtomicReference<Throwable>();
        for (i = 0; i < NUM_THREADS; ++i) {
            threads[i] = new ReadOwnWritesTester(i, (MemStore)this.memstore, this.mvcc, caught);
            threads[i].start();
        }
        for (i = 0; i < NUM_THREADS; ++i) {
            threads[i].join();
        }
        if (caught.get() != null) {
            throw (Throwable)caught.get();
        }
    }

    @Test
    public void testSnapshotting() throws IOException {
        int snapshotCount = 5;
        for (int i = 0; i < 5; ++i) {
            this.addRows(this.memstore);
            this.runSnapshot(this.memstore);
            Assert.assertEquals((String)"History not being cleared", (long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        }
    }

    @Test
    public void testMultipleVersionsSimple() throws Exception {
        DefaultMemStore m = new DefaultMemStore(new Configuration(), (CellComparator)CellComparatorImpl.COMPARATOR);
        byte[] row = Bytes.toBytes((String)"testRow");
        byte[] family = Bytes.toBytes((String)"testFamily");
        byte[] qf = Bytes.toBytes((String)"testQualifier");
        long[] stamps = new long[]{1L, 2L, 3L};
        byte[][] values = new byte[][]{Bytes.toBytes((String)"value0"), Bytes.toBytes((String)"value1"), Bytes.toBytes((String)"value2")};
        KeyValue key0 = new KeyValue(row, family, qf, stamps[0], values[0]);
        KeyValue key1 = new KeyValue(row, family, qf, stamps[1], values[1]);
        KeyValue key2 = new KeyValue(row, family, qf, stamps[2], values[2]);
        m.add((Cell)key0, null);
        m.add((Cell)key1, null);
        m.add((Cell)key2, null);
        Assert.assertTrue((String)("Expected memstore to hold 3 values, actually has " + m.getActive().getCellsCount()), (m.getActive().getCellsCount() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testGetNextRow() throws Exception {
        this.addRows(this.memstore);
        Thread.sleep(1L);
        this.addRows(this.memstore);
        Cell closestToEmpty = ((DefaultMemStore)this.memstore).getNextRow((Cell)KeyValue.LOWESTKEY);
        Assert.assertTrue((CellComparatorImpl.COMPARATOR.compareRows(closestToEmpty, (Cell)new KeyValue(Bytes.toBytes((int)0), System.currentTimeMillis())) == 0 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            Cell nr = ((DefaultMemStore)this.memstore).getNextRow((Cell)new KeyValue(Bytes.toBytes((int)i), System.currentTimeMillis()));
            if (i + 1 == 10) {
                Assert.assertNull((Object)nr);
                continue;
            }
            Assert.assertTrue((CellComparatorImpl.COMPARATOR.compareRows(nr, (Cell)new KeyValue(Bytes.toBytes((int)(i + 1)), System.currentTimeMillis())) == 0 ? 1 : 0) != 0);
        }
        Configuration conf = HBaseConfiguration.create();
        for (int startRowId = 0; startRowId < 10; ++startRowId) {
            ScanInfo scanInfo = new ScanInfo(conf, FAMILY, 0, 1, Integer.MAX_VALUE, KeepDeletedCells.FALSE, 65536L, 0L, this.memstore.getComparator(), false);
            try (StoreScanner scanner = new StoreScanner(new Scan().withStartRow(Bytes.toBytes((int)startRowId)), scanInfo, null, this.memstore.getScanners(0L));){
                ArrayList results = new ArrayList();
                int i = 0;
                while (scanner.next(results)) {
                    byte[] row1;
                    int rowId = startRowId + i;
                    Cell left = (Cell)results.get(0);
                    Assert.assertTrue((String)"Row name", (CellComparatorImpl.COMPARATOR.compareRows(left, row1 = Bytes.toBytes((int)rowId), 0, row1.length) == 0 ? 1 : 0) != 0);
                    Assert.assertEquals((String)"Count of columns", (long)10L, (long)results.size());
                    ArrayList<Cell> row = new ArrayList<Cell>();
                    for (Cell kv : results) {
                        row.add(kv);
                    }
                    this.isExpectedRowWithoutTimestamps(rowId, row);
                    results.clear();
                    ++i;
                }
                continue;
            }
        }
    }

    @Test
    public void testGet_memstoreAndSnapShot() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] val = Bytes.toBytes((String)"testval");
        this.memstore.add((Cell)new KeyValue(row, fam, qf1, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf2, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf3, val), null);
        this.memstore.snapshot();
        Assert.assertEquals((long)3L, (long)this.memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)0L, (long)this.memstore.getActive().getCellsCount());
        this.memstore.add((Cell)new KeyValue(row, fam, qf4, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf5, val), null);
        Assert.assertEquals((long)2L, (long)this.memstore.getActive().getCellsCount());
    }

    @Test
    public void testGetWithDelete() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier");
        byte[] val = Bytes.toBytes((String)"testval");
        long ts1 = System.nanoTime();
        KeyValue put1 = new KeyValue(row, fam, qf1, ts1, val);
        long ts2 = ts1 + 1L;
        KeyValue put2 = new KeyValue(row, fam, qf1, ts2, val);
        long ts3 = ts2 + 1L;
        KeyValue put3 = new KeyValue(row, fam, qf1, ts3, val);
        this.memstore.add((Cell)put1, null);
        this.memstore.add((Cell)put2, null);
        this.memstore.add((Cell)put3, null);
        Assert.assertEquals((long)3L, (long)this.memstore.getActive().getCellsCount());
        KeyValue del2 = new KeyValue(row, fam, qf1, ts2, KeyValue.Type.Delete, val);
        this.memstore.add((Cell)del2, null);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(put3);
        expected.add(del2);
        expected.add(put2);
        expected.add(put1);
        Assert.assertEquals((long)4L, (long)this.memstore.getActive().getCellsCount());
        int i = 0;
        for (Cell cell : this.memstore.getActive().getCellSet()) {
            Assert.assertEquals(expected.get(i++), (Object)cell);
        }
    }

    @Test
    public void testGetWithDeleteColumn() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier");
        byte[] val = Bytes.toBytes((String)"testval");
        long ts1 = System.nanoTime();
        KeyValue put1 = new KeyValue(row, fam, qf1, ts1, val);
        long ts2 = ts1 + 1L;
        KeyValue put2 = new KeyValue(row, fam, qf1, ts2, val);
        long ts3 = ts2 + 1L;
        KeyValue put3 = new KeyValue(row, fam, qf1, ts3, val);
        this.memstore.add((Cell)put1, null);
        this.memstore.add((Cell)put2, null);
        this.memstore.add((Cell)put3, null);
        Assert.assertEquals((long)3L, (long)this.memstore.getActive().getCellsCount());
        KeyValue del2 = new KeyValue(row, fam, qf1, ts2, KeyValue.Type.DeleteColumn, val);
        this.memstore.add((Cell)del2, null);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(put3);
        expected.add(del2);
        expected.add(put2);
        expected.add(put1);
        Assert.assertEquals((long)4L, (long)this.memstore.getActive().getCellsCount());
        int i = 0;
        for (Cell cell : this.memstore.getActive().getCellSet()) {
            Assert.assertEquals(expected.get(i++), (Object)cell);
        }
    }

    @Test
    public void testGetWithDeleteFamily() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] val = Bytes.toBytes((String)"testval");
        long ts = System.nanoTime();
        KeyValue put1 = new KeyValue(row, fam, qf1, ts, val);
        KeyValue put2 = new KeyValue(row, fam, qf2, ts, val);
        KeyValue put3 = new KeyValue(row, fam, qf3, ts, val);
        KeyValue put4 = new KeyValue(row, fam, qf3, ts + 1L, val);
        this.memstore.add((Cell)put1, null);
        this.memstore.add((Cell)put2, null);
        this.memstore.add((Cell)put3, null);
        this.memstore.add((Cell)put4, null);
        KeyValue del = new KeyValue(row, fam, null, ts, KeyValue.Type.DeleteFamily, val);
        this.memstore.add((Cell)del, null);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>();
        expected.add(del);
        expected.add(put1);
        expected.add(put2);
        expected.add(put4);
        expected.add(put3);
        Assert.assertEquals((long)5L, (long)this.memstore.getActive().getCellsCount());
        int i = 0;
        for (Cell cell : this.memstore.getActive().getCellSet()) {
            Assert.assertEquals(expected.get(i++), (Object)cell);
        }
    }

    @Test
    public void testKeepDeleteInmemstore() {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf = Bytes.toBytes((String)"testqualifier");
        byte[] val = Bytes.toBytes((String)"testval");
        long ts = System.nanoTime();
        this.memstore.add((Cell)new KeyValue(row, fam, qf, ts, val), null);
        KeyValue delete = new KeyValue(row, fam, qf, ts, KeyValue.Type.Delete, val);
        this.memstore.add((Cell)delete, null);
        Assert.assertEquals((long)2L, (long)this.memstore.getActive().getCellsCount());
        Assert.assertEquals((Object)delete, (Object)this.memstore.getActive().first());
    }

    @Test
    public void testRetainsDeleteVersion() throws IOException {
        this.memstore.add((Cell)KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (String)"dont-care"), null);
        KeyValue delete = KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (KeyValue.Type)KeyValue.Type.Delete, (String)"dont-care");
        this.memstore.add((Cell)delete, null);
        Assert.assertEquals((long)2L, (long)this.memstore.getActive().getCellsCount());
        Assert.assertEquals((Object)delete, (Object)this.memstore.getActive().first());
    }

    @Test
    public void testRetainsDeleteColumn() throws IOException {
        this.memstore.add((Cell)KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (String)"dont-care"), null);
        KeyValue delete = KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (KeyValue.Type)KeyValue.Type.DeleteColumn, (String)"dont-care");
        this.memstore.add((Cell)delete, null);
        Assert.assertEquals((long)2L, (long)this.memstore.getActive().getCellsCount());
        Assert.assertEquals((Object)delete, (Object)this.memstore.getActive().first());
    }

    @Test
    public void testRetainsDeleteFamily() throws IOException {
        this.memstore.add((Cell)KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (String)"dont-care"), null);
        KeyValue delete = KeyValueTestUtil.create((String)"row1", (String)"fam", (String)"a", (long)100L, (KeyValue.Type)KeyValue.Type.DeleteFamily, (String)"dont-care");
        this.memstore.add((Cell)delete, null);
        Assert.assertEquals((long)2L, (long)this.memstore.getActive().getCellsCount());
        Assert.assertEquals((Object)delete, (Object)this.memstore.getActive().first());
    }

    private static byte[] makeQualifier(int i1, int i2) {
        return Bytes.toBytes((String)(Integer.toString(i1) + ";" + Integer.toString(i2)));
    }

    @Test
    public void testUpsertMemstoreSize() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        this.memstore = new DefaultMemStore(conf, (CellComparator)CellComparatorImpl.COMPARATOR);
        MemStoreSize oldSize = this.memstore.size();
        ArrayList<KeyValue> l = new ArrayList<KeyValue>();
        KeyValue kv1 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v");
        KeyValue kv2 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)101L, (String)"v");
        KeyValue kv3 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)102L, (String)"v");
        kv1.setSequenceId(1L);
        kv2.setSequenceId(1L);
        kv3.setSequenceId(1L);
        l.add(kv1);
        l.add(kv2);
        l.add(kv3);
        this.memstore.upsert(l, 2L, null);
        MemStoreSize newSize = this.memstore.size();
        assert (newSize.getDataSize() > oldSize.getDataSize());
        assert (this.memstore.getActive().getCellsCount() == 2);
        KeyValue kv4 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)104L, (String)"v");
        kv4.setSequenceId(1L);
        l.clear();
        l.add(kv4);
        this.memstore.upsert(l, 3L, null);
        Assert.assertEquals((Object)newSize, (Object)this.memstore.size());
        assert (this.memstore.getActive().getCellsCount() == 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateToTimeOfOldestEdit() throws Exception {
        try {
            EnvironmentEdgeForMemstoreTest edge = new EnvironmentEdgeForMemstoreTest();
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
            DefaultMemStore memstore = new DefaultMemStore();
            long t = memstore.timeOfOldestEdit();
            Assert.assertEquals((long)Long.MAX_VALUE, (long)t);
            memstore.add((Cell)KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v"), null);
            t = memstore.timeOfOldestEdit();
            Assert.assertTrue((t == 1234L ? 1 : 0) != 0);
            t = this.runSnapshot((AbstractMemStore)memstore);
            memstore.add((Cell)KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (KeyValue.Type)KeyValue.Type.Delete, (String)"v"), null);
            t = memstore.timeOfOldestEdit();
            Assert.assertTrue((t == 1234L ? 1 : 0) != 0);
            t = this.runSnapshot((AbstractMemStore)memstore);
            ArrayList<KeyValue> l = new ArrayList<KeyValue>();
            KeyValue kv1 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v");
            kv1.setSequenceId(100L);
            l.add(kv1);
            memstore.upsert(l, 1000L, null);
            t = memstore.timeOfOldestEdit();
            Assert.assertTrue((t == 1234L ? 1 : 0) != 0);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testShouldFlush() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hbase.regionserver.optionalcacheflushinterval", 1000);
        this.checkShouldFlush(conf, true);
        conf.setInt("hbase.regionserver.optionalcacheflushinterval", 0);
        this.checkShouldFlush(conf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkShouldFlush(Configuration conf, boolean expected) throws Exception {
        try {
            EnvironmentEdgeForMemstoreTest edge = new EnvironmentEdgeForMemstoreTest();
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
            HBaseTestingUtility hbaseUtility = HBaseTestingUtility.createLocalHTU(conf);
            String cf = "foo";
            HRegion region = hbaseUtility.createTestRegion("foobar", ColumnFamilyDescriptorBuilder.of((String)cf));
            edge.setCurrentTimeMillis(1234L);
            Put p = new Put(Bytes.toBytes((String)"r"));
            p.add((Cell)KeyValueTestUtil.create((String)"r", (String)cf, (String)"q", (long)100L, (String)"v"));
            region.put(p);
            edge.setCurrentTimeMillis(1334L);
            StringBuilder sb = new StringBuilder();
            Assert.assertTrue((!region.shouldFlush(sb) ? 1 : 0) != 0);
            edge.setCurrentTimeMillis(11234L);
            Assert.assertTrue((region.shouldFlush(sb) == expected ? 1 : 0) != 0);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testShouldFlushMeta() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("hbase.regionserver.optionalcacheflushinterval", 3000000);
        HBaseTestingUtility hbaseUtility = HBaseTestingUtility.createLocalHTU(conf);
        Path testDir = hbaseUtility.getDataTestDir();
        EnvironmentEdgeForMemstoreTest edge = new EnvironmentEdgeForMemstoreTest();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
        edge.setCurrentTimeMillis(1234L);
        WALFactory wFactory = new WALFactory(conf, "1234");
        HRegion meta = HRegion.createHRegion((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (Path)testDir, (Configuration)conf, (TableDescriptor)FSTableDescriptors.createMetaTableDescriptorBuilder((Configuration)conf).build(), (WAL)wFactory.getWAL(RegionInfoBuilder.FIRST_META_REGIONINFO));
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName().replaceAll("[\\[\\]]", "_"))).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"foo")).build();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)desc.getTableName()).setStartKey(Bytes.toBytes((String)"row_0200")).setEndKey(Bytes.toBytes((String)"row_0300")).build();
        HRegion r = HRegion.createHRegion((RegionInfo)hri, (Path)testDir, (Configuration)conf, (TableDescriptor)desc, (WAL)wFactory.getWAL(hri));
        TestDefaultMemStore.addRegionToMETA(meta, r);
        edge.setCurrentTimeMillis(1334L);
        StringBuilder sb = new StringBuilder();
        Assert.assertTrue((!meta.shouldFlush(sb) ? 1 : 0) != 0);
        edge.setCurrentTimeMillis(edge.currentTime() + 300000L + 1L);
        Assert.assertTrue((meta.shouldFlush(sb) ? 1 : 0) != 0);
    }

    public static void addRegionToMETA(HRegion meta, HRegion r) throws IOException {
        meta.checkResources();
        byte[] row = r.getRegionInfo().getRegionName();
        long now = EnvironmentEdgeManager.currentTime();
        ArrayList<KeyValue> cells = new ArrayList<KeyValue>(2);
        cells.add(new KeyValue(row, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, now, RegionInfo.toByteArray((RegionInfo)r.getRegionInfo())));
        cells.add(new KeyValue(row, HConstants.CATALOG_FAMILY, HConstants.META_VERSION_QUALIFIER, now, Bytes.toBytes((short)1)));
        meta.put(row, HConstants.CATALOG_FAMILY, cells);
    }

    protected int addRows(AbstractMemStore hmc) {
        return this.addRows((MemStore)hmc, Long.MAX_VALUE);
    }

    protected int addRows(MemStore hmc, long ts) {
        for (int i = 0; i < 10; ++i) {
            long timestamp = ts == Long.MAX_VALUE ? System.currentTimeMillis() : ts;
            for (int ii = 0; ii < 10; ++ii) {
                byte[] row = Bytes.toBytes((int)i);
                byte[] qf = TestDefaultMemStore.makeQualifier(i, ii);
                hmc.add((Cell)new KeyValue(row, FAMILY, qf, timestamp, qf), null);
            }
        }
        return 10;
    }

    private long runSnapshot(AbstractMemStore hmc) throws UnexpectedStateException {
        int oldHistorySize = hmc.getSnapshot().getCellsCount();
        MemStoreSnapshot snapshot = hmc.snapshot();
        Assert.assertTrue((String)"History size has not increased", (oldHistorySize < hmc.getSnapshot().getCellsCount() ? 1 : 0) != 0);
        long t = this.memstore.timeOfOldestEdit();
        Assert.assertTrue((String)"Time of oldest edit is not Long.MAX_VALUE", (t == Long.MAX_VALUE ? 1 : 0) != 0);
        hmc.clearSnapshot(snapshot.getId());
        return t;
    }

    private void isExpectedRowWithoutTimestamps(int rowIndex, List<Cell> kvs) {
        int i = 0;
        for (Cell kv : kvs) {
            byte[] expectedColname = TestDefaultMemStore.makeQualifier(rowIndex, i++);
            Assert.assertTrue((String)"Column name", (boolean)CellUtil.matchingQualifier((Cell)kv, (byte[])expectedColname));
            Assert.assertTrue((String)"Content", (boolean)CellUtil.matchingValue((Cell)kv, (byte[])expectedColname));
        }
    }

    private static void addRows(int count, MemStore mem) {
        long nanos = System.nanoTime();
        for (int i = 0; i < count; ++i) {
            if (i % 1000 == 0) {
                System.out.println(i + " Took for 1k usec: " + (System.nanoTime() - nanos) / 1000L);
                nanos = System.nanoTime();
            }
            long timestamp = System.currentTimeMillis();
            for (int ii = 0; ii < 10; ++ii) {
                byte[] row = Bytes.toBytes((int)i);
                byte[] qf = TestDefaultMemStore.makeQualifier(i, ii);
                mem.add((Cell)new KeyValue(row, FAMILY, qf, timestamp, qf), null);
            }
        }
    }

    static void doScan(MemStore ms, int iteration) throws IOException {
        long nanos = System.nanoTime();
        KeyValueScanner s = (KeyValueScanner)ms.getScanners(0L).get(0);
        s.seek((Cell)KeyValueUtil.createFirstOnRow((byte[])new byte[0]));
        System.out.println(iteration + " create/seek took: " + (System.nanoTime() - nanos) / 1000L);
        int cnt = 0;
        while (s.next() != null) {
            ++cnt;
        }
        System.out.println(iteration + " took usec: " + (System.nanoTime() - nanos) / 1000L + " for: " + cnt);
    }

    public static void main(String[] args) throws IOException {
        DefaultMemStore ms = new DefaultMemStore();
        long n1 = System.nanoTime();
        TestDefaultMemStore.addRows(25000, (MemStore)ms);
        System.out.println("Took for insert: " + (System.nanoTime() - n1) / 1000L);
        System.out.println("foo");
        for (int i = 0; i < 50; ++i) {
            TestDefaultMemStore.doScan((MemStore)ms, i);
        }
    }

    private class EnvironmentEdgeForMemstoreTest
    implements EnvironmentEdge {
        long t = 1234L;

        private EnvironmentEdgeForMemstoreTest() {
        }

        public long currentTime() {
            return this.t;
        }

        public void setCurrentTimeMillis(long t) {
            this.t = t;
        }
    }

    private static class ReadOwnWritesTester
    extends Thread {
        static final int NUM_TRIES = 1000;
        final byte[] row;
        final byte[] f = Bytes.toBytes((String)"family");
        final byte[] q1 = Bytes.toBytes((String)"q1");
        final MultiVersionConcurrencyControl mvcc;
        final MemStore memstore;
        AtomicReference<Throwable> caughtException;

        public ReadOwnWritesTester(int id, MemStore memstore, MultiVersionConcurrencyControl mvcc, AtomicReference<Throwable> caughtException) {
            this.mvcc = mvcc;
            this.memstore = memstore;
            this.caughtException = caughtException;
            this.row = Bytes.toBytes((int)id);
        }

        @Override
        public void run() {
            try {
                this.internalRun();
            }
            catch (Throwable t) {
                this.caughtException.compareAndSet(null, t);
            }
        }

        private void internalRun() throws IOException {
            for (long i = 0L; i < 1000L && this.caughtException.get() == null; ++i) {
                MultiVersionConcurrencyControl.WriteEntry w = this.mvcc.begin();
                byte[] v = Bytes.toBytes((long)i);
                KeyValue kv = new KeyValue(this.row, this.f, this.q1, i, v);
                kv.setSequenceId(w.getWriteNumber());
                this.memstore.add((Cell)kv, null);
                this.mvcc.completeAndWait(w);
                KeyValueScanner s = (KeyValueScanner)this.memstore.getScanners(this.mvcc.getReadPoint()).get(0);
                s.seek((Cell)kv);
                Cell ret = s.next();
                Assert.assertNotNull((String)"Didnt find own write at all", (Object)ret);
                Assert.assertEquals((String)"Didnt read own writes", (long)kv.getTimestamp(), (long)ret.getTimestamp());
            }
        }
    }
}

