/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionStateStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestRegionStateStore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionStateStore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionStateStore.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testVisitMetaForRegionExistingRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)"testVisitMetaForRegion");
        UTIL.createTable(tableName, "cf");
        List<HRegion> regions = UTIL.getHBaseCluster().getRegions(tableName);
        final String encodedName = regions.get(0).getRegionInfo().getEncodedName();
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        final AtomicBoolean visitorCalled = new AtomicBoolean(false);
        regionStateStore.visitMetaForRegion(encodedName, new RegionStateStore.RegionStateVisitor(){

            public void visitRegionState(Result result, RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, ServerName lastHost, long openSeqNum) {
                Assert.assertEquals((Object)encodedName, (Object)regionInfo.getEncodedName());
                visitorCalled.set(true);
            }
        });
        Assert.assertTrue((String)"Visitor has not been called.", (boolean)visitorCalled.get());
    }

    @Test
    public void testVisitMetaForBadRegionState() throws Exception {
        TableName tableName = TableName.valueOf((String)"testVisitMetaForBadRegionState");
        UTIL.createTable(tableName, "cf");
        List<HRegion> regions = UTIL.getHBaseCluster().getRegions(tableName);
        final String encodedName = regions.get(0).getRegionInfo().getEncodedName();
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        Put put = new Put(regions.get(0).getRegionInfo().getRegionName(), EnvironmentEdgeManager.currentTime());
        put.addColumn(HConstants.CATALOG_FAMILY, HConstants.STATE_QUALIFIER, Bytes.toBytes((String)"BAD_STATE"));
        try (Table table = UTIL.getConnection().getTable(TableName.META_TABLE_NAME);){
            table.put(put);
        }
        final AtomicBoolean visitorCalled = new AtomicBoolean(false);
        regionStateStore.visitMetaForRegion(encodedName, new RegionStateStore.RegionStateVisitor(){

            public void visitRegionState(Result result, RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, ServerName lastHost, long openSeqNum) {
                Assert.assertEquals((Object)encodedName, (Object)regionInfo.getEncodedName());
                Assert.assertNull((Object)state);
                visitorCalled.set(true);
            }
        });
        Assert.assertTrue((String)"Visitor has not been called.", (boolean)visitorCalled.get());
    }

    @Test
    public void testVisitMetaForRegionNonExistingRegion() throws Exception {
        String encodedName = "fakeencodedregionname";
        RegionStateStore regionStateStore = UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStateStore();
        final AtomicBoolean visitorCalled = new AtomicBoolean(false);
        regionStateStore.visitMetaForRegion("fakeencodedregionname", new RegionStateStore.RegionStateVisitor(){

            public void visitRegionState(Result result, RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, ServerName lastHost, long openSeqNum) {
                visitorCalled.set(true);
            }
        });
        Assert.assertFalse((String)"Visitor has been called, but it shouldn't.", (boolean)visitorCalled.get());
    }
}

