/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.coprocessor.TestRegionObserverInterface;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.ScanOptions;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.junit.Assert;

public class SimpleRegionObserver
implements RegionCoprocessor,
RegionObserver {
    final AtomicInteger ctBeforeDelete = new AtomicInteger(1);
    final AtomicInteger ctPreOpen = new AtomicInteger(0);
    final AtomicInteger ctPostOpen = new AtomicInteger(0);
    final AtomicInteger ctPreClose = new AtomicInteger(0);
    final AtomicInteger ctPostClose = new AtomicInteger(0);
    final AtomicInteger ctPreFlush = new AtomicInteger(0);
    final AtomicInteger ctPostFlush = new AtomicInteger(0);
    final AtomicInteger ctPreCompactSelect = new AtomicInteger(0);
    final AtomicInteger ctPostCompactSelect = new AtomicInteger(0);
    final AtomicInteger ctPreCompact = new AtomicInteger(0);
    final AtomicInteger ctPostCompact = new AtomicInteger(0);
    final AtomicInteger ctPreGet = new AtomicInteger(0);
    final AtomicInteger ctPostGet = new AtomicInteger(0);
    final AtomicInteger ctPrePut = new AtomicInteger(0);
    final AtomicInteger ctPostPut = new AtomicInteger(0);
    final AtomicInteger ctPreDeleted = new AtomicInteger(0);
    final AtomicInteger ctPrePrepareDeleteTS = new AtomicInteger(0);
    final AtomicInteger ctPostDeleted = new AtomicInteger(0);
    final AtomicInteger ctPreIncrement = new AtomicInteger(0);
    final AtomicInteger ctPreIncrementAfterRowLock = new AtomicInteger(0);
    final AtomicInteger ctPreAppend = new AtomicInteger(0);
    final AtomicInteger ctPreAppendAfterRowLock = new AtomicInteger(0);
    final AtomicInteger ctPostIncrement = new AtomicInteger(0);
    final AtomicInteger ctPostAppend = new AtomicInteger(0);
    final AtomicInteger ctPreCheckAndPut = new AtomicInteger(0);
    final AtomicInteger ctPreCheckAndPutWithFilter = new AtomicInteger(0);
    final AtomicInteger ctPreCheckAndPutAfterRowLock = new AtomicInteger(0);
    final AtomicInteger ctPreCheckAndPutWithFilterAfterRowLock = new AtomicInteger(0);
    final AtomicInteger ctPostCheckAndPut = new AtomicInteger(0);
    final AtomicInteger ctPostCheckAndPutWithFilter = new AtomicInteger(0);
    final AtomicInteger ctPreCheckAndDelete = new AtomicInteger(0);
    final AtomicInteger ctPreCheckAndDeleteWithFilter = new AtomicInteger(0);
    final AtomicInteger ctPreCheckAndDeleteAfterRowLock = new AtomicInteger(0);
    final AtomicInteger ctPreCheckAndDeleteWithFilterAfterRowLock = new AtomicInteger(0);
    final AtomicInteger ctPostCheckAndDelete = new AtomicInteger(0);
    final AtomicInteger ctPostCheckAndDeleteWithFilter = new AtomicInteger(0);
    final AtomicInteger ctPreScannerNext = new AtomicInteger(0);
    final AtomicInteger ctPostScannerNext = new AtomicInteger(0);
    final AtomicInteger ctPostScannerFilterRow = new AtomicInteger(0);
    final AtomicInteger ctPreScannerClose = new AtomicInteger(0);
    final AtomicInteger ctPostScannerClose = new AtomicInteger(0);
    final AtomicInteger ctPreScannerOpen = new AtomicInteger(0);
    final AtomicInteger ctPostScannerOpen = new AtomicInteger(0);
    final AtomicInteger ctPreBulkLoadHFile = new AtomicInteger(0);
    final AtomicInteger ctPostBulkLoadHFile = new AtomicInteger(0);
    final AtomicInteger ctPreBatchMutate = new AtomicInteger(0);
    final AtomicInteger ctPostBatchMutate = new AtomicInteger(0);
    final AtomicInteger ctPreReplayWALs = new AtomicInteger(0);
    final AtomicInteger ctPostReplayWALs = new AtomicInteger(0);
    final AtomicInteger ctPreWALRestore = new AtomicInteger(0);
    final AtomicInteger ctPostWALRestore = new AtomicInteger(0);
    final AtomicInteger ctPreStoreFileReaderOpen = new AtomicInteger(0);
    final AtomicInteger ctPostStoreFileReaderOpen = new AtomicInteger(0);
    final AtomicInteger ctPostBatchMutateIndispensably = new AtomicInteger(0);
    final AtomicInteger ctPostStartRegionOperation = new AtomicInteger(0);
    final AtomicInteger ctPostCloseRegionOperation = new AtomicInteger(0);
    final AtomicBoolean throwOnPostFlush = new AtomicBoolean(false);
    final AtomicInteger ctPreWALAppend = new AtomicInteger(0);
    static final String TABLE_SKIPPED = "SKIPPED_BY_PREWALRESTORE";
    Map<String, byte[]> extendedAttributes = new HashMap<String, byte[]>();
    static final byte[] WAL_EXTENDED_ATTRIBUTE_BYTES = Bytes.toBytes((String)"foo");

    public void setThrowOnPostFlush(Boolean val) {
        this.throwOnPostFlush.set(val);
    }

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment e) throws IOException {
    }

    public void preOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.ctPreOpen.incrementAndGet();
    }

    public void postOpen(ObserverContext<RegionCoprocessorEnvironment> c) {
        this.ctPostOpen.incrementAndGet();
    }

    public boolean wasOpened() {
        return this.ctPreOpen.get() > 0 && this.ctPostOpen.get() > 0;
    }

    public void preClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        this.ctPreClose.incrementAndGet();
    }

    public void postClose(ObserverContext<RegionCoprocessorEnvironment> c, boolean abortRequested) {
        this.ctPostClose.incrementAndGet();
    }

    public boolean wasClosed() {
        return this.ctPreClose.get() > 0 && this.ctPostClose.get() > 0;
    }

    public InternalScanner preFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, FlushLifeCycleTracker tracker) throws IOException {
        this.ctPreFlush.incrementAndGet();
        return scanner;
    }

    public void postFlush(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile, FlushLifeCycleTracker tracker) throws IOException {
        this.ctPostFlush.incrementAndGet();
        if (this.throwOnPostFlush.get()) {
            throw new IOException("throwOnPostFlush is true in postFlush");
        }
    }

    public boolean wasFlushed() {
        return this.ctPreFlush.get() > 0 && this.ctPostFlush.get() > 0;
    }

    public void preCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends StoreFile> candidates, CompactionLifeCycleTracker tracker) throws IOException {
        this.ctPreCompactSelect.incrementAndGet();
    }

    public void postCompactSelection(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends StoreFile> selected, CompactionLifeCycleTracker tracker, CompactionRequest request) {
        this.ctPostCompactSelect.incrementAndGet();
    }

    public InternalScanner preCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, InternalScanner scanner, ScanType scanType, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        this.ctPreCompact.incrementAndGet();
        return scanner;
    }

    public void postCompact(ObserverContext<RegionCoprocessorEnvironment> c, Store store, StoreFile resultFile, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        this.ctPostCompact.incrementAndGet();
    }

    public boolean wasCompacted() {
        return this.ctPreCompact.get() > 0 && this.ctPostCompact.get() > 0;
    }

    public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) throws IOException {
        this.ctPreScannerOpen.incrementAndGet();
    }

    public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws IOException {
        this.ctPostScannerOpen.incrementAndGet();
        return s;
    }

    public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
        this.ctPreScannerNext.incrementAndGet();
        return hasMore;
    }

    public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
        this.ctPostScannerNext.incrementAndGet();
        return hasMore;
    }

    public boolean postScannerFilterRow(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s, Cell currentRow, boolean hasMore) throws IOException {
        this.ctPostScannerFilterRow.incrementAndGet();
        return hasMore;
    }

    public void preScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.ctPreScannerClose.incrementAndGet();
    }

    public void postScannerClose(ObserverContext<RegionCoprocessorEnvironment> c, InternalScanner s) throws IOException {
        this.ctPostScannerClose.incrementAndGet();
    }

    public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> results) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)get);
        Assert.assertNotNull(results);
        this.ctPreGet.incrementAndGet();
    }

    public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> c, Get get, List<Cell> results) {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)get);
        Assert.assertNotNull(results);
        if (e.getRegion().getTableDescriptor().getTableName().equals((Object)TestRegionObserverInterface.TEST_TABLE)) {
            boolean foundA = false;
            boolean foundB = false;
            boolean foundC = false;
            for (Cell kv : results) {
                if (CellUtil.matchingFamily((Cell)kv, (byte[])TestRegionObserverInterface.A)) {
                    foundA = true;
                }
                if (CellUtil.matchingFamily((Cell)kv, (byte[])TestRegionObserverInterface.B)) {
                    foundB = true;
                }
                if (!CellUtil.matchingFamily((Cell)kv, (byte[])TestRegionObserverInterface.C)) continue;
                foundC = true;
            }
            Assert.assertTrue((boolean)foundA);
            Assert.assertTrue((boolean)foundB);
            Assert.assertTrue((boolean)foundC);
        }
        this.ctPostGet.incrementAndGet();
    }

    public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        NavigableMap familyMap = put.getFamilyCellMap();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)familyMap);
        if (e.getRegion().getTableDescriptor().getTableName().equals((Object)TestRegionObserverInterface.TEST_TABLE)) {
            List cells = (List)familyMap.get(TestRegionObserverInterface.A);
            Assert.assertNotNull((Object)cells);
            Assert.assertNotNull(cells.get(0));
            Cell cell = (Cell)cells.get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])TestRegionObserverInterface.A, (int)0, (int)TestRegionObserverInterface.A.length));
            cells = (List)familyMap.get(TestRegionObserverInterface.B);
            Assert.assertNotNull((Object)cells);
            Assert.assertNotNull(cells.get(0));
            cell = (Cell)cells.get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])TestRegionObserverInterface.B, (int)0, (int)TestRegionObserverInterface.B.length));
            cells = (List)familyMap.get(TestRegionObserverInterface.C);
            Assert.assertNotNull((Object)cells);
            Assert.assertNotNull(cells.get(0));
            cell = (Cell)cells.get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])TestRegionObserverInterface.C, (int)0, (int)TestRegionObserverInterface.C.length));
        }
        this.ctPrePut.incrementAndGet();
    }

    public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
        NavigableMap familyMap = put.getFamilyCellMap();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)familyMap);
        List cells = (List)familyMap.get(TestRegionObserverInterface.A);
        if (e.getRegion().getTableDescriptor().getTableName().equals((Object)TestRegionObserverInterface.TEST_TABLE)) {
            Assert.assertNotNull((Object)cells);
            Assert.assertNotNull(cells.get(0));
            Cell cell = (Cell)cells.get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])TestRegionObserverInterface.A, (int)0, (int)TestRegionObserverInterface.A.length));
            cells = (List)familyMap.get(TestRegionObserverInterface.B);
            Assert.assertNotNull((Object)cells);
            Assert.assertNotNull(cells.get(0));
            cell = (Cell)cells.get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])TestRegionObserverInterface.B, (int)0, (int)TestRegionObserverInterface.B.length));
            cells = (List)familyMap.get(TestRegionObserverInterface.C);
            Assert.assertNotNull((Object)cells);
            Assert.assertNotNull(cells.get(0));
            cell = (Cell)cells.get(0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])cell.getQualifierArray(), (int)cell.getQualifierOffset(), (int)cell.getQualifierLength(), (byte[])TestRegionObserverInterface.C, (int)0, (int)TestRegionObserverInterface.C.length));
        }
        this.ctPostPut.incrementAndGet();
    }

    public void preDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        NavigableMap familyMap = delete.getFamilyCellMap();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)familyMap);
        if (this.ctBeforeDelete.get() > 0) {
            this.ctPreDeleted.incrementAndGet();
        }
    }

    public void prePrepareTimeStampForDeleteVersion(ObserverContext<RegionCoprocessorEnvironment> e, Mutation delete, Cell cell, byte[] byteNow, Get get) throws IOException {
        this.ctPrePrepareDeleteTS.incrementAndGet();
    }

    public void postDelete(ObserverContext<RegionCoprocessorEnvironment> c, Delete delete, WALEdit edit, Durability durability) throws IOException {
        NavigableMap familyMap = delete.getFamilyCellMap();
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull((Object)familyMap);
        this.ctBeforeDelete.set(0);
        this.ctPostDeleted.incrementAndGet();
    }

    public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull(miniBatchOp);
        this.ctPreBatchMutate.incrementAndGet();
    }

    public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)c.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        Assert.assertNotNull(miniBatchOp);
        this.ctPostBatchMutate.incrementAndGet();
    }

    public void postStartRegionOperation(ObserverContext<RegionCoprocessorEnvironment> ctx, Region.Operation op) throws IOException {
        this.ctPostStartRegionOperation.incrementAndGet();
    }

    public void postCloseRegionOperation(ObserverContext<RegionCoprocessorEnvironment> ctx, Region.Operation op) throws IOException {
        if (this.ctPostStartRegionOperation.get() > 0) {
            this.ctPostCloseRegionOperation.incrementAndGet();
        }
    }

    public void postBatchMutateIndispensably(ObserverContext<RegionCoprocessorEnvironment> ctx, MiniBatchOperationInProgress<Mutation> miniBatchOp, boolean success) throws IOException {
        this.ctPostBatchMutateIndispensably.incrementAndGet();
    }

    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment) throws IOException {
        this.ctPreIncrement.incrementAndGet();
        return null;
    }

    public Result preIncrementAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
        this.ctPreIncrementAfterRowLock.incrementAndGet();
        return null;
    }

    public Result postIncrement(ObserverContext<RegionCoprocessorEnvironment> c, Increment increment, Result result) throws IOException {
        this.ctPostIncrement.incrementAndGet();
        return result;
    }

    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> e, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        this.ctPreCheckAndPut.incrementAndGet();
        return true;
    }

    public boolean preCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, Filter filter, Put put, boolean result) throws IOException {
        this.ctPreCheckAndPutWithFilter.incrementAndGet();
        return true;
    }

    public boolean preCheckAndPutAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> e, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        this.ctPreCheckAndPutAfterRowLock.incrementAndGet();
        return true;
    }

    public boolean preCheckAndPutAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, Filter filter, Put put, boolean result) throws IOException {
        this.ctPreCheckAndPutWithFilterAfterRowLock.incrementAndGet();
        return true;
    }

    public boolean postCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> e, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Put put, boolean result) throws IOException {
        this.ctPostCheckAndPut.incrementAndGet();
        return true;
    }

    public boolean postCheckAndPut(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, Filter filter, Put put, boolean result) throws IOException {
        this.ctPostCheckAndPutWithFilter.incrementAndGet();
        return true;
    }

    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> e, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        this.ctPreCheckAndDelete.incrementAndGet();
        return true;
    }

    public boolean preCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, Filter filter, Delete delete, boolean result) throws IOException {
        this.ctPreCheckAndDeleteWithFilter.incrementAndGet();
        return true;
    }

    public boolean preCheckAndDeleteAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> e, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        this.ctPreCheckAndDeleteAfterRowLock.incrementAndGet();
        return true;
    }

    public boolean preCheckAndDeleteAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> c, byte[] row, Filter filter, Delete delete, boolean result) throws IOException {
        this.ctPreCheckAndDeleteWithFilterAfterRowLock.incrementAndGet();
        return true;
    }

    public boolean postCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> e, byte[] row, byte[] family, byte[] qualifier, CompareOperator compareOp, ByteArrayComparable comparator, Delete delete, boolean result) throws IOException {
        this.ctPostCheckAndDelete.incrementAndGet();
        return true;
    }

    public boolean postCheckAndDelete(ObserverContext<RegionCoprocessorEnvironment> e, byte[] row, Filter filter, Delete delete, boolean result) throws IOException {
        this.ctPostCheckAndDeleteWithFilter.incrementAndGet();
        return true;
    }

    public Result preAppendAfterRowLock(ObserverContext<RegionCoprocessorEnvironment> e, Append append) throws IOException {
        this.ctPreAppendAfterRowLock.incrementAndGet();
        return null;
    }

    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append) throws IOException {
        this.ctPreAppend.incrementAndGet();
        return null;
    }

    public Result postAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append, Result result) throws IOException {
        this.ctPostAppend.incrementAndGet();
        return null;
    }

    public void preBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)ctx.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        if (e.getRegion().getTableDescriptor().getTableName().equals((Object)TestRegionObserverInterface.TEST_TABLE)) {
            Assert.assertNotNull(familyPaths);
            Assert.assertEquals((long)1L, (long)familyPaths.size());
            Assert.assertArrayEquals((byte[])TestRegionObserverInterface.A, (byte[])((byte[])familyPaths.get(0).getFirst()));
            String familyPath = (String)familyPaths.get(0).getSecond();
            String familyName = Bytes.toString((byte[])TestRegionObserverInterface.A);
            Assert.assertEquals((Object)familyPath.substring(familyPath.length() - familyName.length() - 1), (Object)("/" + familyName));
        }
        this.ctPreBulkLoadHFile.incrementAndGet();
    }

    public void postBulkLoadHFile(ObserverContext<RegionCoprocessorEnvironment> ctx, List<Pair<byte[], String>> familyPaths, Map<byte[], List<Path>> map) throws IOException {
        RegionCoprocessorEnvironment e = (RegionCoprocessorEnvironment)ctx.getEnvironment();
        Assert.assertNotNull((Object)e);
        Assert.assertNotNull((Object)e.getRegion());
        if (e.getRegion().getTableDescriptor().getTableName().equals((Object)TestRegionObserverInterface.TEST_TABLE)) {
            Assert.assertNotNull(familyPaths);
            Assert.assertEquals((long)1L, (long)familyPaths.size());
            Assert.assertArrayEquals((byte[])TestRegionObserverInterface.A, (byte[])((byte[])familyPaths.get(0).getFirst()));
            String familyPath = (String)familyPaths.get(0).getSecond();
            String familyName = Bytes.toString((byte[])TestRegionObserverInterface.A);
            Assert.assertEquals((Object)familyPath.substring(familyPath.length() - familyName.length() - 1), (Object)("/" + familyName));
        }
        this.ctPostBulkLoadHFile.incrementAndGet();
    }

    public void preReplayWALs(ObserverContext<? extends RegionCoprocessorEnvironment> env, RegionInfo info, Path edits) throws IOException {
        this.ctPreReplayWALs.incrementAndGet();
    }

    public void postReplayWALs(ObserverContext<? extends RegionCoprocessorEnvironment> env, RegionInfo info, Path edits) throws IOException {
        this.ctPostReplayWALs.incrementAndGet();
    }

    public void preWALRestore(ObserverContext<? extends RegionCoprocessorEnvironment> env, RegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        String tableName = logKey.getTableName().getNameAsString();
        if (tableName.equals(TABLE_SKIPPED)) {
            env.bypass();
            return;
        }
        this.ctPreWALRestore.incrementAndGet();
    }

    public void postWALRestore(ObserverContext<? extends RegionCoprocessorEnvironment> env, RegionInfo info, WALKey logKey, WALEdit logEdit) throws IOException {
        this.ctPostWALRestore.incrementAndGet();
    }

    public StoreFileReader preStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFileReader reader) throws IOException {
        this.ctPreStoreFileReaderOpen.incrementAndGet();
        return null;
    }

    public StoreFileReader postStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFileReader reader) throws IOException {
        this.ctPostStoreFileReaderOpen.incrementAndGet();
        return reader;
    }

    public void preStoreScannerOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, Store store, ScanOptions options) throws IOException {
        if (options.getScan().getTimeRange().isAllTime()) {
            this.setScanOptions(options);
        }
    }

    public void preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanType scanType, ScanOptions options, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        this.setScanOptions(options);
    }

    public void preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanOptions options, FlushLifeCycleTracker tracker) throws IOException {
        this.setScanOptions(options);
    }

    public void preMemStoreCompactionCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanOptions options) throws IOException {
        this.setScanOptions(options);
    }

    private void setScanOptions(ScanOptions options) {
        options.setMaxVersions(3);
        options.setMinVersions(2);
        options.setKeepDeletedCells(KeepDeletedCells.TRUE);
        options.setTTL(1000L);
    }

    public void preWALAppend(ObserverContext<RegionCoprocessorEnvironment> ctx, WALKey key, WALEdit edit) throws IOException {
        this.ctPreWALAppend.incrementAndGet();
        key.addExtendedAttribute(Integer.toString(this.ctPreWALAppend.get()), Bytes.toBytes((String)"foo"));
    }

    public boolean hadPreGet() {
        return this.ctPreGet.get() > 0;
    }

    public boolean hadPostGet() {
        return this.ctPostGet.get() > 0;
    }

    public boolean hadPrePut() {
        return this.ctPrePut.get() > 0;
    }

    public boolean hadPostPut() {
        return this.ctPostPut.get() > 0;
    }

    public boolean hadPreBatchMutate() {
        return this.ctPreBatchMutate.get() > 0;
    }

    public boolean hadPostBatchMutate() {
        return this.ctPostBatchMutate.get() > 0;
    }

    public boolean hadPostBatchMutateIndispensably() {
        return this.ctPostBatchMutateIndispensably.get() > 0;
    }

    public boolean hadPostStartRegionOperation() {
        return this.ctPostStartRegionOperation.get() > 0;
    }

    public boolean hadPostCloseRegionOperation() {
        return this.ctPostCloseRegionOperation.get() > 0;
    }

    public boolean hadDelete() {
        return this.ctBeforeDelete.get() <= 0;
    }

    public int getCtPostStartRegionOperation() {
        return this.ctPostStartRegionOperation.get();
    }

    public int getCtPostCloseRegionOperation() {
        return this.ctPostCloseRegionOperation.get();
    }

    public int getPreCheckAndPut() {
        return this.ctPreCheckAndPut.get();
    }

    public int getPreCheckAndPutWithFilter() {
        return this.ctPreCheckAndPutWithFilter.get();
    }

    public int getPreCheckAndPutAfterRowLock() {
        return this.ctPreCheckAndPutAfterRowLock.get();
    }

    public int getPreCheckAndPutWithFilterAfterRowLock() {
        return this.ctPreCheckAndPutWithFilterAfterRowLock.get();
    }

    public int getPostCheckAndPut() {
        return this.ctPostCheckAndPut.get();
    }

    public int getPostCheckAndPutWithFilter() {
        return this.ctPostCheckAndPutWithFilter.get();
    }

    public int getPreCheckAndDelete() {
        return this.ctPreCheckAndDelete.get();
    }

    public int getPreCheckAndDeleteWithFilter() {
        return this.ctPreCheckAndDeleteWithFilter.get();
    }

    public int getPreCheckAndDeleteAfterRowLock() {
        return this.ctPreCheckAndDeleteAfterRowLock.get();
    }

    public int getPreCheckAndDeleteWithFilterAfterRowLock() {
        return this.ctPreCheckAndDeleteWithFilterAfterRowLock.get();
    }

    public int getPostCheckAndDelete() {
        return this.ctPostCheckAndDelete.get();
    }

    public int getPostCheckAndDeleteWithFilter() {
        return this.ctPostCheckAndDeleteWithFilter.get();
    }

    public boolean hadPreIncrement() {
        return this.ctPreIncrement.get() > 0;
    }

    public boolean hadPreIncrementAfterRowLock() {
        return this.ctPreIncrementAfterRowLock.get() > 0;
    }

    public boolean hadPostIncrement() {
        return this.ctPostIncrement.get() > 0;
    }

    public boolean hadPreAppend() {
        return this.ctPreAppend.get() > 0;
    }

    public boolean hadPreAppendAfterRowLock() {
        return this.ctPreAppendAfterRowLock.get() > 0;
    }

    public boolean hadPostAppend() {
        return this.ctPostAppend.get() > 0;
    }

    public boolean hadPrePreparedDeleteTS() {
        return this.ctPrePrepareDeleteTS.get() > 0;
    }

    public boolean hadPreReplayWALs() {
        return this.ctPreReplayWALs.get() > 0;
    }

    public boolean hadPostReplayWALs() {
        return this.ctPostReplayWALs.get() > 0;
    }

    public boolean hadPreWALRestore() {
        return this.ctPreWALRestore.get() > 0;
    }

    public boolean hadPostWALRestore() {
        return this.ctPostWALRestore.get() > 0;
    }

    public boolean wasScannerNextCalled() {
        return this.ctPreScannerNext.get() > 0 && this.ctPostScannerNext.get() > 0;
    }

    public boolean wasScannerFilterRowCalled() {
        return this.ctPostScannerFilterRow.get() > 0;
    }

    public boolean wasScannerCloseCalled() {
        return this.ctPreScannerClose.get() > 0 && this.ctPostScannerClose.get() > 0;
    }

    public boolean wasScannerOpenCalled() {
        return this.ctPreScannerOpen.get() > 0 && this.ctPostScannerOpen.get() > 0;
    }

    public boolean hadDeleted() {
        return this.ctPreDeleted.get() > 0 && this.ctPostDeleted.get() > 0;
    }

    public boolean hadPostBulkLoadHFile() {
        return this.ctPostBulkLoadHFile.get() > 0;
    }

    public boolean hadPreBulkLoadHFile() {
        return this.ctPreBulkLoadHFile.get() > 0;
    }

    public int getCtBeforeDelete() {
        return this.ctBeforeDelete.get();
    }

    public int getCtPreOpen() {
        return this.ctPreOpen.get();
    }

    public int getCtPostOpen() {
        return this.ctPostOpen.get();
    }

    public int getCtPreClose() {
        return this.ctPreClose.get();
    }

    public int getCtPostClose() {
        return this.ctPostClose.get();
    }

    public int getCtPreFlush() {
        return this.ctPreFlush.get();
    }

    public int getCtPostFlush() {
        return this.ctPostFlush.get();
    }

    public int getCtPreCompactSelect() {
        return this.ctPreCompactSelect.get();
    }

    public int getCtPostCompactSelect() {
        return this.ctPostCompactSelect.get();
    }

    public int getCtPreCompact() {
        return this.ctPreCompact.get();
    }

    public int getCtPostCompact() {
        return this.ctPostCompact.get();
    }

    public int getCtPreGet() {
        return this.ctPreGet.get();
    }

    public int getCtPostGet() {
        return this.ctPostGet.get();
    }

    public int getCtPrePut() {
        return this.ctPrePut.get();
    }

    public int getCtPostPut() {
        return this.ctPostPut.get();
    }

    public int getCtPreDeleted() {
        return this.ctPreDeleted.get();
    }

    public int getCtPostDeleted() {
        return this.ctPostDeleted.get();
    }

    public int getCtPreIncrement() {
        return this.ctPreIncrement.get();
    }

    public int getCtPostIncrement() {
        return this.ctPostIncrement.get();
    }

    public int getCtPreReplayWALs() {
        return this.ctPreReplayWALs.get();
    }

    public int getCtPostReplayWALs() {
        return this.ctPostReplayWALs.get();
    }

    public int getCtPreWALRestore() {
        return this.ctPreWALRestore.get();
    }

    public int getCtPostWALRestore() {
        return this.ctPostWALRestore.get();
    }

    public int getCtPreWALAppend() {
        return this.ctPreWALAppend.get();
    }

    public boolean wasStoreFileReaderOpenCalled() {
        return this.ctPreStoreFileReaderOpen.get() > 0 && this.ctPostStoreFileReaderOpen.get() > 0;
    }
}

