/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MetaCellComparator;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class MetaMockingUtil {
    public static Result getMetaTableRowResult(HRegionInfo region) throws IOException {
        return MetaMockingUtil.getMetaTableRowResult(region, null, null, null);
    }

    public static Result getMetaTableRowResult(HRegionInfo region, ServerName sn) throws IOException {
        return MetaMockingUtil.getMetaTableRowResult(region, sn, null, null);
    }

    public static Result getMetaTableRowResult(HRegionInfo region, ServerName sn, HRegionInfo splita, HRegionInfo splitb) throws IOException {
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        if (region != null) {
            kvs.add(new KeyValue(region.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, region.toByteArray()));
        }
        if (sn != null) {
            kvs.add(new KeyValue(region.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)sn.getHostAndPort())));
            kvs.add(new KeyValue(region.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)sn.getStartcode())));
        }
        if (splita != null) {
            kvs.add(new KeyValue(region.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, splita.toByteArray()));
        }
        if (splitb != null) {
            kvs.add(new KeyValue(region.getRegionName(), HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, splitb.toByteArray()));
        }
        Collections.sort(kvs, MetaCellComparator.META_COMPARATOR);
        return Result.create(kvs);
    }
}

