/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CpuResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.util.NodeManagerHardwareUtils;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class CGroupsCpuResourceHandlerImpl
implements CpuResourceHandler {
    static final Logger LOG = LoggerFactory.getLogger(CGroupsCpuResourceHandlerImpl.class);
    private CGroupsHandler cGroupsHandler;
    private boolean strictResourceUsageMode = false;
    private float yarnProcessors;
    private int nodeVCores;
    private static final CGroupsHandler.CGroupController CPU = CGroupsHandler.CGroupController.CPU;
    @VisibleForTesting
    static final int MAX_QUOTA_US = 1000000;
    @VisibleForTesting
    static final int MIN_PERIOD_US = 1000;
    @VisibleForTesting
    static final int CPU_DEFAULT_WEIGHT = 1024;
    static final int CPU_DEFAULT_WEIGHT_OPPORTUNISTIC = 2;

    CGroupsCpuResourceHandlerImpl(CGroupsHandler cGroupsHandler) {
        this.cGroupsHandler = cGroupsHandler;
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration conf) throws ResourceHandlerException {
        return this.bootstrap(ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)conf), conf);
    }

    @VisibleForTesting
    List<PrivilegedOperation> bootstrap(ResourceCalculatorPlugin plugin, Configuration conf) throws ResourceHandlerException {
        boolean existingCpuLimits;
        this.strictResourceUsageMode = conf.getBoolean("yarn.nodemanager.linux-container-executor.cgroups.strict-resource-usage", false);
        this.cGroupsHandler.initializeCGroupController(CPU);
        this.nodeVCores = NodeManagerHardwareUtils.getVCores(plugin, conf);
        this.yarnProcessors = NodeManagerHardwareUtils.getContainersCPUs(plugin, conf);
        int systemProcessors = NodeManagerHardwareUtils.getNodeCPUs(plugin, conf);
        try {
            existingCpuLimits = CGroupsCpuResourceHandlerImpl.cpuLimitsExist(this.cGroupsHandler.getPathForCGroup(CPU, ""));
        }
        catch (IOException ie) {
            throw new ResourceHandlerException(ie);
        }
        if (systemProcessors != (int)this.yarnProcessors) {
            LOG.info("YARN containers restricted to " + this.yarnProcessors + " cores");
            int[] limits = CGroupsCpuResourceHandlerImpl.getOverallLimits(this.yarnProcessors);
            this.cGroupsHandler.updateCGroupParam(CPU, "", "cfs_period_us", String.valueOf(limits[0]));
            this.cGroupsHandler.updateCGroupParam(CPU, "", "cfs_quota_us", String.valueOf(limits[1]));
        } else if (existingCpuLimits) {
            LOG.info("Removing CPU constraints for YARN containers.");
            this.cGroupsHandler.updateCGroupParam(CPU, "", "cfs_quota_us", String.valueOf(-1));
        }
        return null;
    }

    @InterfaceAudience.Private
    public static boolean cpuLimitsExist(String path) throws IOException {
        String contents;
        int quotaUS;
        File quotaFile = new File(path, CPU.getName() + "." + "cfs_quota_us");
        return quotaFile.exists() && (quotaUS = Integer.parseInt((contents = FileUtils.readFileToString((File)quotaFile, (String)"UTF-8")).trim())) != -1;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static int[] getOverallLimits(float yarnProcessors) {
        int[] ret = new int[2];
        if (yarnProcessors < 0.01f) {
            throw new IllegalArgumentException("Number of processors can't be <= 0.");
        }
        int quotaUS = 1000000;
        int periodUS = (int)(1000000.0f / yarnProcessors);
        if (yarnProcessors < 1.0f && (quotaUS = (int)((float)(periodUS = 1000000) * yarnProcessors)) < 1000) {
            LOG.warn("The quota calculated for the cgroup was too low. The minimum value is 1000, calculated value is " + quotaUS + ". Setting quota to minimum value.");
            quotaUS = 1000;
        }
        if (periodUS < 1000) {
            LOG.warn("The period calculated for the cgroup was too low. The minimum value is 1000, calculated value is " + periodUS + ". Using all available CPU.");
            periodUS = 1000000;
            quotaUS = -1;
        }
        ret[0] = periodUS;
        ret[1] = quotaUS;
        return ret;
    }

    @Override
    public List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        String cgroupId = container.getContainerId().toString();
        Resource containerResource = container.getResource();
        this.cGroupsHandler.createCGroup(CPU, cgroupId);
        try {
            int containerVCores = containerResource.getVirtualCores();
            ContainerTokenIdentifier id = container.getContainerTokenIdentifier();
            if (id != null && id.getExecutionType() == ExecutionType.OPPORTUNISTIC) {
                this.cGroupsHandler.updateCGroupParam(CPU, cgroupId, "shares", String.valueOf(2));
            } else {
                int cpuShares = 1024 * containerVCores;
                this.cGroupsHandler.updateCGroupParam(CPU, cgroupId, "shares", String.valueOf(cpuShares));
            }
            if (this.strictResourceUsageMode && this.nodeVCores != containerVCores) {
                float containerCPU = (float)containerVCores * this.yarnProcessors / (float)this.nodeVCores;
                int[] limits = CGroupsCpuResourceHandlerImpl.getOverallLimits(containerCPU);
                this.cGroupsHandler.updateCGroupParam(CPU, cgroupId, "cfs_period_us", String.valueOf(limits[0]));
                this.cGroupsHandler.updateCGroupParam(CPU, cgroupId, "cfs_quota_us", String.valueOf(limits[1]));
            }
        }
        catch (ResourceHandlerException re) {
            this.cGroupsHandler.deleteCGroup(CPU, cgroupId);
            LOG.warn("Could not update cgroup for container", (Throwable)((Object)re));
            throw re;
        }
        ArrayList<PrivilegedOperation> ret = new ArrayList<PrivilegedOperation>();
        ret.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, "cgroups=" + this.cGroupsHandler.getPathForCGroupTasks(CPU, cgroupId)));
        return ret;
    }

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        return null;
    }

    @Override
    public List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        this.cGroupsHandler.deleteCGroup(CPU, containerId.toString());
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        return null;
    }
}

