/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNameNodeRpcServerMethods {
    private static NamenodeProtocols nnRpc;
    private static Configuration conf;
    private static MiniDFSCluster cluster;

    @Before
    public void setup() throws Exception {
        conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder(conf).build();
        cluster.waitActive();
        nnRpc = cluster.getNameNode().getRpcServer();
    }

    @After
    public void cleanup() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testDeleteSnapshotWhenSnapshotNameIsEmpty() throws Exception {
        String dir = "/testNamenodeRetryCache/testDelete";
        try {
            nnRpc.deleteSnapshot(dir, null);
            Assert.fail((String)"testdeleteSnapshot is not thrown expected exception ");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"The snapshot name is null or empty.", (Throwable)e);
        }
        try {
            nnRpc.deleteSnapshot(dir, "");
            Assert.fail((String)"testdeleteSnapshot is not thrown expected exception");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"The snapshot name is null or empty.", (Throwable)e);
        }
    }
}

