/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.hdfs.server.namenode.ErasureCodingPolicyManager;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestEnabledECPolicies {
    @Rule
    public Timeout testTimeout = new Timeout(60000);

    private void expectInvalidPolicy(String value) {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.namenode.ec.system.default.policy", value);
        try {
            ErasureCodingPolicyManager.getInstance().init((Configuration)conf);
            Assert.fail((String)"Expected exception when instantiating ECPolicyManager");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"is not a valid policy", (Throwable)e);
        }
    }

    private void expectValidPolicy(String value, int numEnabled) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        ErasureCodingPolicyManager manager = ErasureCodingPolicyManager.getInstance();
        manager.init((Configuration)conf);
        manager.enablePolicy(value);
        Assert.assertEquals((String)"Incorrect number of enabled policies", (long)numEnabled, (long)manager.getEnabledPolicies().length);
    }

    @Test
    public void testDefaultPolicy() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String defaultECPolicies = conf.get("dfs.namenode.ec.system.default.policy", "RS-6-3-1024k");
        this.expectValidPolicy(defaultECPolicies, 1);
    }

    @Test
    public void testInvalid() throws Exception {
        this.expectInvalidPolicy("not-a-policy");
        this.expectInvalidPolicy("not-a-policy," + StripedFileTestUtil.getDefaultECPolicy().getName());
        this.expectInvalidPolicy(StripedFileTestUtil.getDefaultECPolicy().getName() + ", not-a-policy");
        this.expectInvalidPolicy("not-a-policy, ");
        this.expectInvalidPolicy("     ,not-a-policy, ");
    }

    @Test
    public void testValid() throws Exception {
        String ecPolicyName = StripedFileTestUtil.getDefaultECPolicy().getName();
        this.expectValidPolicy(ecPolicyName, 1);
    }

    @Test
    public void testGetPolicies() throws Exception {
        ErasureCodingPolicy[] enabledPolicies = new ErasureCodingPolicy[]{};
        this.testGetPolicies(enabledPolicies);
        enabledPolicies = new ErasureCodingPolicy[]{(ErasureCodingPolicy)SystemErasureCodingPolicies.getPolicies().get(1)};
        this.testGetPolicies(enabledPolicies);
        enabledPolicies = new ErasureCodingPolicy[]{(ErasureCodingPolicy)SystemErasureCodingPolicies.getPolicies().get(1), (ErasureCodingPolicy)SystemErasureCodingPolicies.getPolicies().get(2)};
        this.testGetPolicies(enabledPolicies);
    }

    private void testGetPolicies(ErasureCodingPolicy[] enabledPolicies) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        ErasureCodingPolicyManager manager = ErasureCodingPolicyManager.getInstance();
        manager.init((Configuration)conf);
        for (ErasureCodingPolicy p : enabledPolicies) {
            manager.enablePolicy(p.getName());
        }
        HashSet<String> found = new HashSet<String>();
        for (ErasureCodingPolicy p : manager.getEnabledPolicies()) {
            Assert.assertFalse((String)("Duplicate policy name found: " + p.getName()), (boolean)found.contains(p.getName()));
            found.add(p.getName());
        }
        for (ErasureCodingPolicy p : enabledPolicies) {
            Assert.assertTrue((String)("Did not find specified EC policy " + p.getName()), (boolean)found.contains(p.getName()));
        }
        Assert.assertEquals((long)enabledPolicies.length, (long)(found.size() - 1));
        for (ErasureCodingPolicy p : SystemErasureCodingPolicies.getPolicies()) {
            if (found.contains(p.getName())) {
                Assert.assertNotNull((String)("getEnabledPolicyByName did not find enabled policy" + p.getName()), (Object)manager.getEnabledPolicyByName(p.getName()));
                continue;
            }
            Assert.assertNull((String)("getEnabledPolicyByName found disabled policy " + p.getName()), (Object)manager.getEnabledPolicyByName(p.getName()));
        }
    }
}

