/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSStripedOutputStream;
import org.apache.hadoop.hdfs.DataStreamer;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;

public class TestWriteStripedFileWithFailure {
    public static final Log LOG = LogFactory.getLog(TestWriteStripedFileWithFailure.class);
    private MiniDFSCluster cluster;
    private FileSystem fs;
    private Configuration conf = new HdfsConfiguration();
    private final ErasureCodingPolicy ecPolicy = StripedFileTestUtil.getDefaultECPolicy();
    private final short dataBlocks = (short)this.ecPolicy.getNumDataUnits();
    private final short parityBlocks = (short)this.ecPolicy.getNumParityUnits();
    private final int numDNs = this.dataBlocks + this.parityBlocks;
    private final int blockSize = 4 * this.ecPolicy.getCellSize();
    private final int smallFileLength = this.blockSize * this.dataBlocks - 123;
    private final int largeFileLength = this.blockSize * this.dataBlocks + 123;
    private final int[] fileLengths = new int[]{this.smallFileLength, this.largeFileLength};

    public void setup() throws IOException {
        this.conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.numDNs).build();
        this.cluster.getFileSystem().getClient().setErasureCodingPolicy("/", StripedFileTestUtil.getDefaultECPolicy().getName());
        this.fs = this.cluster.getFileSystem();
    }

    public void tearDown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Ignore
    @Test(timeout=300000L)
    public void testWriteStripedFileWithDNFailure() throws IOException {
        for (int fileLength : this.fileLengths) {
            for (int dataDelNum = 1; dataDelNum <= this.parityBlocks; ++dataDelNum) {
                int parityDelNum = 0;
                while (dataDelNum + parityDelNum <= this.parityBlocks) {
                    try {
                        this.setup();
                        this.writeFileWithDNFailure(fileLength, dataDelNum, parityDelNum);
                    }
                    catch (IOException ioe) {
                        String fileType = fileLength < this.blockSize * this.dataBlocks ? "smallFile" : "largeFile";
                        LOG.error((Object)("Failed to write file with DN failure: fileType = " + fileType + ", dataDelNum = " + dataDelNum + ", parityDelNum = " + parityDelNum));
                        throw ioe;
                    }
                    finally {
                        this.tearDown();
                    }
                    ++parityDelNum;
                }
            }
        }
    }

    private void writeFileWithDNFailure(int fileLength, int dataDNFailureNum, int parityDNFailureNum) throws IOException {
        String fileType = fileLength < this.blockSize * this.dataBlocks ? "smallFile" : "largeFile";
        String src = "/dnFailure_" + dataDNFailureNum + "_" + parityDNFailureNum + "_" + fileType;
        LOG.info((Object)("writeFileWithDNFailure: file = " + src + ", fileType = " + fileType + ", dataDNFailureNum = " + dataDNFailureNum + ", parityDNFailureNum = " + parityDNFailureNum));
        Path srcPath = new Path(src);
        AtomicInteger pos = new AtomicInteger();
        FSDataOutputStream out = this.fs.create(srcPath);
        DFSStripedOutputStream stripedOut = (DFSStripedOutputStream)out.getWrappedStream();
        int[] dataDNFailureIndices = StripedFileTestUtil.randomArray(0, this.dataBlocks, dataDNFailureNum);
        Assert.assertNotNull((Object)dataDNFailureIndices);
        int[] parityDNFailureIndices = StripedFileTestUtil.randomArray(this.dataBlocks, this.dataBlocks + this.parityBlocks, parityDNFailureNum);
        Assert.assertNotNull((Object)parityDNFailureIndices);
        int[] failedDataNodes = new int[dataDNFailureNum + parityDNFailureNum];
        System.arraycopy(dataDNFailureIndices, 0, failedDataNodes, 0, dataDNFailureIndices.length);
        System.arraycopy(parityDNFailureIndices, 0, failedDataNodes, dataDNFailureIndices.length, parityDNFailureIndices.length);
        int killPos = fileLength / 2;
        while (pos.get() < fileLength) {
            int i = pos.getAndIncrement();
            if (i == killPos) {
                for (int failedDn : failedDataNodes) {
                    StripedFileTestUtil.killDatanode(this.cluster, stripedOut, failedDn, pos);
                }
            }
            this.write(out, i);
        }
        out.close();
        int dnFailureNum = dataDNFailureNum + parityDNFailureNum;
        Assert.assertEquals((long)this.cluster.getDataNodes().size(), (long)(this.numDNs - dnFailureNum));
        byte[] smallBuf = new byte[1024];
        byte[] largeBuf = new byte[fileLength + 100];
        byte[] expected = StripedFileTestUtil.generateBytes(fileLength);
        StripedFileTestUtil.verifyLength(this.fs, srcPath, fileLength);
        StripedFileTestUtil.verifySeek(this.fs, srcPath, fileLength, this.ecPolicy, this.blockSize * this.dataBlocks);
        StripedFileTestUtil.verifyStatefulRead(this.fs, srcPath, fileLength, expected, smallBuf);
        StripedFileTestUtil.verifyPread((DistributedFileSystem)this.fs, srcPath, fileLength, expected, largeBuf);
        this.fs.delete(srcPath, true);
    }

    void write(FSDataOutputStream out, int i) throws IOException {
        try {
            out.write((int)StripedFileTestUtil.getByte(i));
        }
        catch (IOException e) {
            throw new IOException("Failed at i=" + i, e);
        }
    }

    static {
        GenericTestUtils.setLogLevel((Logger)DFSOutputStream.LOG, (Level)Level.ALL);
        GenericTestUtils.setLogLevel((Logger)DataStreamer.LOG, (Level)Level.ALL);
    }
}

