/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.tools.StoragePolicyAdmin;
import org.apache.hadoop.hdfs.tools.TestStoragePolicyCommands;
import org.apache.hadoop.util.Tool;
import org.junit.Before;
import org.junit.Test;

public class TestViewFSStoragePolicyCommands
extends TestStoragePolicyCommands {
    @Override
    @Before
    public void clusterSetUp() throws IOException {
        conf = new HdfsConfiguration();
        String clusterName = "cluster";
        cluster = new MiniDFSCluster.Builder(conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(2).build();
        cluster.waitActive();
        DistributedFileSystem hdfs1 = cluster.getFileSystem(0);
        DistributedFileSystem hdfs2 = cluster.getFileSystem(1);
        conf.set("fs.defaultFS", "viewfs://" + clusterName);
        Path base1 = new Path("/user1");
        Path base2 = new Path("/user2");
        hdfs1.delete(base1, true);
        hdfs2.delete(base2, true);
        hdfs1.mkdirs(base1);
        hdfs2.mkdirs(base2);
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"/foo", (URI)hdfs1.makeQualified(base1).toUri());
        ConfigUtil.addLink((Configuration)conf, (String)clusterName, (String)"/hdfs2", (URI)hdfs2.makeQualified(base2).toUri());
        fs = FileSystem.get((Configuration)conf);
    }

    @Test
    public void testStoragePolicyRoot() throws Exception {
        StoragePolicyAdmin admin = new StoragePolicyAdmin(conf);
        DFSTestUtil.toolRun((Tool)admin, "-getStoragePolicy -path /", 2, "is not supported for filesystem viewfs on path /");
    }
}

