/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.ha.HAStressTestHarness;
import org.apache.hadoop.io.retry.RetryInvocationHandler;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

public class TestDNFencingWithReplication {
    private static final int NUM_THREADS = 20;
    private static final long RUNTIME = 35000L;
    private static final int BLOCK_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFencingStress() throws Exception {
        HAStressTestHarness harness = new HAStressTestHarness();
        harness.setNumberOfNameNodes(3);
        harness.conf.setInt("dfs.blockreport.intervalMsec", 1000);
        harness.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1);
        harness.conf.setInt("dfs.namenode.redundancy.interval.seconds", 1);
        MiniDFSCluster cluster = harness.startCluster();
        try {
            Path p;
            int i;
            cluster.waitActive();
            cluster.transitionToActive(0);
            FileSystem fs = harness.getFailoverFs();
            MultithreadedTestUtil.TestContext togglers = new MultithreadedTestUtil.TestContext();
            for (i = 0; i < 20; ++i) {
                p = new Path("/test-" + i);
                DFSTestUtil.createFile(fs, p, 10240L, (short)3, i);
                togglers.addThread((MultithreadedTestUtil.TestingThread)new ReplicationToggler(togglers, fs, p, cluster));
            }
            harness.addReplicationTriggerThread(500);
            harness.addFailoverThread(5000);
            harness.startThreads();
            togglers.startThreads();
            togglers.waitFor(35000L);
            togglers.stop();
            harness.stopThreads();
            for (i = 0; i < 20; ++i) {
                p = new Path("/test-" + i);
                DFSTestUtil.readFile(fs, p);
            }
        }
        finally {
            System.err.println("===========================\n\n\n\n");
            harness.shutdown();
        }
    }

    static {
        GenericTestUtils.setLogLevel((Log)FSNamesystem.auditLog, (Level)Level.WARN);
        GenericTestUtils.setLogLevel((Logger)Server.LOG, (Level)Level.FATAL);
        GenericTestUtils.setLogLevel((Logger)RetryInvocationHandler.LOG, (Level)Level.FATAL);
    }

    private static class ReplicationToggler
    extends MultithreadedTestUtil.RepeatingTestThread {
        private final FileSystem fs;
        private final Path path;
        private final MiniDFSCluster cluster;

        ReplicationToggler(MultithreadedTestUtil.TestContext ctx, FileSystem fs, Path p, MiniDFSCluster cluster) {
            super(ctx);
            this.fs = fs;
            this.path = p;
            this.cluster = cluster;
        }

        public void doAnAction() throws Exception {
            this.fs.setReplication(this.path, (short)1);
            this.waitForReplicas(1);
            this.fs.setReplication(this.path, (short)2);
            this.waitForReplicas(2);
        }

        private void waitForReplicas(final int replicas) throws Exception {
            try {
                GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                    public Boolean get() {
                        try {
                            cluster.waitActive();
                            BlockLocation[] blocks = fs.getFileBlockLocations(path, 0L, 10L);
                            Assert.assertEquals((long)1L, (long)blocks.length);
                            return blocks[0].getHosts().length == replicas;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, (int)100, (int)60000);
            }
            catch (TimeoutException te) {
                throw new IOException("Timed out waiting for " + replicas + " replicas on path " + this.path);
            }
        }

        public String toString() {
            return "Toggler for " + this.path;
        }
    }
}

