/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkStatus;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerException;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerResultVerifier;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerTestUtil;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ConnectorFactory;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerCluster;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerDataNode;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolumeSet;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.GreedyPlanner;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.NodePlan;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestDiskBalancerRPC {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final String PLAN_FILE = "/system/current.plan.json";
    private MiniDFSCluster cluster;
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setBoolean("dfs.disk.balancer.enabled", true);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        this.cluster.waitActive();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @Test
    public void testSubmitPlan() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        dataNode.submitDiskBalancerPlan(planHash, (long)planVersion, PLAN_FILE, plan.toJson(), false);
    }

    @Test
    public void testSubmitPlanWithInvalidHash() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        char[] hashArray = planHash.toCharArray();
        hashArray[0] = (char)(hashArray[0] + '\u0001');
        planHash = String.valueOf(hashArray);
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        this.thrown.expect(DiskBalancerException.class);
        this.thrown.expect((Matcher)new DiskBalancerResultVerifier(DiskBalancerException.Result.INVALID_PLAN_HASH));
        dataNode.submitDiskBalancerPlan(planHash, (long)planVersion, PLAN_FILE, plan.toJson(), false);
    }

    @Test
    public void testSubmitPlanWithInvalidVersion() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        this.thrown.expect(DiskBalancerException.class);
        this.thrown.expect((Matcher)new DiskBalancerResultVerifier(DiskBalancerException.Result.INVALID_PLAN_VERSION));
        dataNode.submitDiskBalancerPlan(planHash, (long)(++planVersion), PLAN_FILE, plan.toJson(), false);
    }

    @Test
    public void testSubmitPlanWithInvalidPlan() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        this.thrown.expect(DiskBalancerException.class);
        this.thrown.expect((Matcher)new DiskBalancerResultVerifier(DiskBalancerException.Result.INVALID_PLAN));
        dataNode.submitDiskBalancerPlan(planHash, (long)planVersion, "", "", false);
    }

    @Test
    public void testCancelPlan() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        dataNode.submitDiskBalancerPlan(planHash, (long)planVersion, PLAN_FILE, plan.toJson(), false);
        dataNode.cancelDiskBalancePlan(planHash);
    }

    @Test
    public void testCancelNonExistentPlan() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        char[] hashArray = planHash.toCharArray();
        hashArray[0] = (char)(hashArray[0] + '\u0001');
        planHash = String.valueOf(hashArray);
        NodePlan plan = rpcTestHelper.getPlan();
        this.thrown.expect(DiskBalancerException.class);
        this.thrown.expect((Matcher)new DiskBalancerResultVerifier(DiskBalancerException.Result.NO_SUCH_PLAN));
        dataNode.cancelDiskBalancePlan(planHash);
    }

    @Test
    public void testCancelEmptyPlan() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = "";
        NodePlan plan = rpcTestHelper.getPlan();
        this.thrown.expect(DiskBalancerException.class);
        this.thrown.expect((Matcher)new DiskBalancerResultVerifier(DiskBalancerException.Result.NO_SUCH_PLAN));
        dataNode.cancelDiskBalancePlan(planHash);
    }

    @Test
    public void testGetDiskBalancerVolumeMapping() throws Exception {
        boolean dnIndex = false;
        DataNode dataNode = this.cluster.getDataNodes().get(0);
        String volumeNameJson = dataNode.getDiskBalancerSetting("DiskBalancerVolumeName");
        Assert.assertNotNull((Object)volumeNameJson);
        ObjectMapper mapper = new ObjectMapper();
        Map volumemap = (Map)mapper.readValue(volumeNameJson, HashMap.class);
        Assert.assertEquals((long)2L, (long)volumemap.size());
    }

    @Test
    public void testGetDiskBalancerInvalidSetting() throws Exception {
        boolean dnIndex = false;
        String invalidSetting = "invalidSetting";
        DataNode dataNode = this.cluster.getDataNodes().get(0);
        this.thrown.expect(DiskBalancerException.class);
        this.thrown.expect((Matcher)new DiskBalancerResultVerifier(DiskBalancerException.Result.UNKNOWN_KEY));
        dataNode.getDiskBalancerSetting("invalidSetting");
    }

    @Test
    public void testgetDiskBalancerBandwidth() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        dataNode.submitDiskBalancerPlan(planHash, (long)planVersion, PLAN_FILE, plan.toJson(), false);
        String bandwidthString = dataNode.getDiskBalancerSetting("DiskBalancerBandwidth");
        long value = Long.decode(bandwidthString);
        Assert.assertEquals((long)10L, (long)value);
    }

    @Test
    public void testQueryPlan() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        String planHash = rpcTestHelper.getPlanHash();
        int planVersion = rpcTestHelper.getPlanVersion();
        NodePlan plan = rpcTestHelper.getPlan();
        dataNode.submitDiskBalancerPlan(planHash, (long)planVersion, PLAN_FILE, plan.toJson(), false);
        DiskBalancerWorkStatus status = dataNode.queryDiskBalancerPlan();
        Assert.assertTrue((status.getResult() == DiskBalancerWorkStatus.Result.PLAN_UNDER_PROGRESS || status.getResult() == DiskBalancerWorkStatus.Result.PLAN_DONE ? 1 : 0) != 0);
    }

    @Test
    public void testQueryPlanWithoutSubmit() throws Exception {
        RpcTestHelper rpcTestHelper = new RpcTestHelper().invoke();
        DataNode dataNode = rpcTestHelper.getDataNode();
        DiskBalancerWorkStatus status = dataNode.queryDiskBalancerPlan();
        Assert.assertTrue((status.getResult() == DiskBalancerWorkStatus.Result.NO_PLAN ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveBlockAcrossVolume() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int defaultBlockSize = 100;
        conf.setBoolean("dfs.disk.balancer.enabled", true);
        conf.setLong("dfs.blocksize", 100L);
        conf.setInt("dfs.bytes-per-checksum", 100);
        String fileName = "/tmp.txt";
        Path filePath = new Path(fileName);
        boolean numDatanodes = true;
        boolean dnIndex = false;
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        FsVolumeImpl source = null;
        FsVolumeImpl dest = null;
        try {
            this.cluster.waitActive();
            Random r = new Random();
            DistributedFileSystem fs = this.cluster.getFileSystem(0);
            DFSTestUtil.createFile((FileSystem)fs, filePath, 10240L, (short)1, r.nextLong());
            DataNode dnNode = this.cluster.getDataNodes().get(0);
            try (FsDatasetSpi.FsVolumeReferences refs = dnNode.getFSDataset().getFsVolumeReferences();){
                source = (FsVolumeImpl)refs.get(0);
                dest = (FsVolumeImpl)refs.get(1);
                DiskBalancerTestUtil.moveAllDataToDestVolume(dnNode.getFSDataset(), (FsVolumeSpi)source, (FsVolumeSpi)dest);
                Assert.assertTrue((DiskBalancerTestUtil.getBlockCount((FsVolumeSpi)source) == 0 ? 1 : 0) != 0);
            }
        }
        finally {
            this.cluster.shutdown();
        }
    }

    private class RpcTestHelper {
        private NodePlan plan;
        private int planVersion;
        private DataNode dataNode;
        private String planHash;

        private RpcTestHelper() {
        }

        public NodePlan getPlan() {
            return this.plan;
        }

        public int getPlanVersion() {
            return this.planVersion;
        }

        public DataNode getDataNode() {
            return this.dataNode;
        }

        public String getPlanHash() {
            return this.planHash;
        }

        public RpcTestHelper invoke() throws Exception {
            boolean dnIndex = false;
            TestDiskBalancerRPC.this.cluster.restartDataNode(0);
            TestDiskBalancerRPC.this.cluster.waitActive();
            ClusterConnector nameNodeConnector = ConnectorFactory.getCluster((URI)TestDiskBalancerRPC.this.cluster.getFileSystem(0).getUri(), (Configuration)TestDiskBalancerRPC.this.conf);
            DiskBalancerCluster diskBalancerCluster = new DiskBalancerCluster(nameNodeConnector);
            diskBalancerCluster.readClusterInfo();
            Assert.assertEquals((long)TestDiskBalancerRPC.this.cluster.getDataNodes().size(), (long)diskBalancerCluster.getNodes().size());
            diskBalancerCluster.setNodesToProcess(diskBalancerCluster.getNodes());
            this.dataNode = TestDiskBalancerRPC.this.cluster.getDataNodes().get(0);
            DiskBalancerDataNode node = diskBalancerCluster.getNodeByUUID(this.dataNode.getDatanodeUuid());
            GreedyPlanner planner = new GreedyPlanner(10.0, node);
            this.plan = new NodePlan(node.getDataNodeName(), node.getDataNodePort());
            planner.balanceVolumeSet(node, (DiskBalancerVolumeSet)node.getVolumeSets().get("DISK"), this.plan);
            this.planVersion = 1;
            this.planHash = DigestUtils.shaHex((String)this.plan.toJson());
            return this;
        }
    }
}

