/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.internal.util.reflection.Whitebox;

public class TestUnderReplicatedBlocks {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testSetRepIncWithUnderReplicatedBlocks() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int REPLICATION_FACTOR = 2;
        String FILE_NAME = "/testFile";
        Path FILE_PATH = new Path("/testFile");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            BlockManager bm = cluster.getNamesystem().getBlockManager();
            DFSTestUtil.createFile((FileSystem)fs, FILE_PATH, 1L, (short)2, 1L);
            DFSTestUtil.waitReplication((FileSystem)fs, FILE_PATH, (short)2);
            BlockManagerTestUtil.updateState(bm);
            DFSTestUtil.verifyClientStats((Configuration)conf, cluster);
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, FILE_PATH);
            DatanodeDescriptor dn = ((DatanodeStorageInfo)bm.blocksMap.getStorages(b.getLocalBlock()).iterator().next()).getDatanodeDescriptor();
            bm.addToInvalidates(b.getLocalBlock(), (DatanodeInfo)dn);
            BlockManagerTestUtil.computeAllPendingWork(bm);
            DataNodeTestUtils.triggerHeartbeat(cluster.getDataNode(dn.getIpcPort()));
            Thread.sleep(5000L);
            BlockManagerTestUtil.updateState(bm);
            DFSTestUtil.verifyClientStats((Configuration)conf, cluster);
            bm.blocksMap.removeNode(b.getLocalBlock(), dn);
            BlockManagerTestUtil.updateState(bm);
            DFSTestUtil.verifyClientStats((Configuration)conf, cluster);
            FsShell shell = new FsShell((Configuration)conf);
            Assert.assertEquals((long)0L, (long)shell.run(new String[]{"-setrep", "-w", Integer.toString(3), "/testFile"}));
            BlockManagerTestUtil.updateState(bm);
            DFSTestUtil.verifyClientStats((Configuration)conf, cluster);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testNumberOfBlocksToBeReplicated() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.fs-limits.min-block-size", 0L);
        conf.setLong("dfs.blocksize", 1L);
        conf.setInt("dfs.bytes-per-checksum", 1);
        conf.setInt("dfs.heartbeat.interval", 100);
        conf.setInt("dfs.namenode.replication.work.multiplier.per.iteration", 5);
        int NUM_OF_BLOCKS = 10;
        int REP_FACTOR = 2;
        String FILE_NAME = "/testFile";
        Path FILE_PATH = new Path("/testFile");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, FILE_PATH, NUM_OF_BLOCKS, (short)2, 1L);
            DFSTestUtil.waitReplication((FileSystem)fs, FILE_PATH, (short)2);
            cluster.startDataNodes((Configuration)conf, 1, true, null, null, null, null);
            BlockManager bm = cluster.getNamesystem().getBlockManager();
            ExtendedBlock b = DFSTestUtil.getFirstBlock((FileSystem)fs, FILE_PATH);
            Iterator storageInfos = bm.blocksMap.getStorages(b.getLocalBlock()).iterator();
            DatanodeDescriptor firstDn = ((DatanodeStorageInfo)storageInfos.next()).getDatanodeDescriptor();
            DatanodeDescriptor secondDn = ((DatanodeStorageInfo)storageInfos.next()).getDatanodeDescriptor();
            BlockManagerTestUtil.updateState(bm);
            DFSTestUtil.verifyClientStats((Configuration)conf, cluster);
            bm.getDatanodeManager().removeDatanode((DatanodeID)firstDn);
            BlockManagerTestUtil.updateState(bm);
            Assert.assertEquals((long)NUM_OF_BLOCKS, (long)bm.getUnderReplicatedNotMissingBlocks());
            DFSTestUtil.verifyClientStats((Configuration)conf, cluster);
            bm.computeDatanodeWork();
            Assert.assertTrue((String)"The number of replication work pending before targets are determined should be non-negative.", ((Integer)Whitebox.getInternalState((Object)secondDn, (String)"pendingReplicationWithoutTargets") >= 0 ? 1 : 0) != 0);
            BlockManagerTestUtil.updateState(bm);
            Assert.assertTrue((String)("The number of blocks to be replicated should be less than or equal to " + bm.replicationStreamsHardLimit), (secondDn.getNumberOfBlocksToBeReplicated() <= bm.replicationStreamsHardLimit ? 1 : 0) != 0);
            DFSTestUtil.verifyClientStats((Configuration)conf, cluster);
        }
        finally {
            cluster.shutdown();
        }
    }
}

