/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.google.common.base.Supplier;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerSafeMode;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.NumberReplicas;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;

public class TestBlockManagerSafeMode {
    private static final int DATANODE_NUM = 3;
    private static final long BLOCK_TOTAL = 10L;
    private static final double THRESHOLD = 0.99;
    private static final long BLOCK_THRESHOLD = 9L;
    private static final int EXTENSION = 1000;
    private FSNamesystem fsn;
    private BlockManager bm;
    private DatanodeManager dn;
    private BlockManagerSafeMode bmSafeMode;

    @Before
    public void setupMockCluster() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setDouble("dfs.namenode.safemode.threshold-pct", 0.99);
        conf.setInt("dfs.namenode.safemode.extension", 1000);
        conf.setInt("dfs.namenode.safemode.min.datanodes", 3);
        this.fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).hasWriteLock();
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).hasReadLock();
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).isRunning();
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        this.bm = (BlockManager)Mockito.spy((Object)new BlockManager((Namesystem)this.fsn, false, (Configuration)conf));
        ((BlockManager)Mockito.doReturn((Object)true).when((Object)this.bm)).isGenStampInFuture((Block)Matchers.any(Block.class));
        this.dn = (DatanodeManager)Mockito.spy((Object)this.bm.getDatanodeManager());
        Whitebox.setInternalState((Object)this.bm, (String)"datanodeManager", (Object)this.dn);
        Mockito.when((Object)this.dn.getNumLiveDataNodes()).thenReturn((Object)3);
        this.bmSafeMode = new BlockManagerSafeMode(this.bm, (Namesystem)this.fsn, false, (Configuration)conf);
    }

    @Test(timeout=30000L)
    public void testInitialize() {
        Assert.assertFalse((String)"Block manager should not be in safe mode at beginning.", (boolean)this.bmSafeMode.isInSafeMode());
        this.bmSafeMode.activate(10L);
        Assert.assertEquals((Object)BlockManagerSafeMode.BMSafeModeStatus.PENDING_THRESHOLD, (Object)this.getSafeModeStatus());
        Assert.assertTrue((boolean)this.bmSafeMode.isInSafeMode());
    }

    @Test(timeout=10000L)
    public void testCheckSafeMode1() {
        this.bmSafeMode.activate(10L);
        this.setSafeModeStatus(BlockManagerSafeMode.BMSafeModeStatus.PENDING_THRESHOLD);
        for (long i = 0L; i < 9L; ++i) {
            this.setBlockSafe(i);
            this.bmSafeMode.checkSafeMode();
            Assert.assertEquals((Object)BlockManagerSafeMode.BMSafeModeStatus.PENDING_THRESHOLD, (Object)this.getSafeModeStatus());
        }
    }

    @Test(timeout=10000L)
    public void testCheckSafeMode2() {
        this.bmSafeMode.activate(10L);
        Whitebox.setInternalState((Object)this.bmSafeMode, (String)"extension", (Object)Integer.MAX_VALUE);
        this.setSafeModeStatus(BlockManagerSafeMode.BMSafeModeStatus.PENDING_THRESHOLD);
        this.setBlockSafe(9L);
        this.bmSafeMode.checkSafeMode();
        Assert.assertEquals((Object)BlockManagerSafeMode.BMSafeModeStatus.EXTENSION, (Object)this.getSafeModeStatus());
    }

    @Test(timeout=10000L)
    public void testCheckSafeMode3() {
        this.bmSafeMode.activate(10L);
        Whitebox.setInternalState((Object)this.bmSafeMode, (String)"extension", (Object)0);
        this.setSafeModeStatus(BlockManagerSafeMode.BMSafeModeStatus.PENDING_THRESHOLD);
        this.setBlockSafe(9L);
        this.bmSafeMode.checkSafeMode();
        Assert.assertEquals((Object)BlockManagerSafeMode.BMSafeModeStatus.OFF, (Object)this.getSafeModeStatus());
    }

    @Test(timeout=10000L)
    public void testCheckSafeMode4() {
        this.bmSafeMode.activate(10L);
        this.setBlockSafe(0L);
        this.setSafeModeStatus(BlockManagerSafeMode.BMSafeModeStatus.EXTENSION);
        Whitebox.setInternalState((Object)this.bmSafeMode, (String)"extension", (Object)0);
        this.bmSafeMode.checkSafeMode();
        Assert.assertEquals((Object)BlockManagerSafeMode.BMSafeModeStatus.EXTENSION, (Object)this.getSafeModeStatus());
    }

    @Test(timeout=10000L)
    public void testCheckSafeMode5() {
        this.bmSafeMode.activate(10L);
        Whitebox.setInternalState((Object)this.bmSafeMode, (String)"extension", (Object)Integer.MAX_VALUE);
        this.setSafeModeStatus(BlockManagerSafeMode.BMSafeModeStatus.EXTENSION);
        this.setBlockSafe(9L);
        this.bmSafeMode.checkSafeMode();
        Assert.assertEquals((Object)BlockManagerSafeMode.BMSafeModeStatus.EXTENSION, (Object)this.getSafeModeStatus());
    }

    @Test(timeout=10000L)
    public void testCheckSafeMode6() {
        ((FSNamesystem)Mockito.doReturn((Object)true).when((Object)this.fsn)).inTransitionToActive();
        this.bmSafeMode.activate(10L);
        Whitebox.setInternalState((Object)this.bmSafeMode, (String)"extension", (Object)0);
        this.setSafeModeStatus(BlockManagerSafeMode.BMSafeModeStatus.PENDING_THRESHOLD);
        this.setBlockSafe(9L);
        this.bmSafeMode.checkSafeMode();
        Assert.assertEquals((Object)BlockManagerSafeMode.BMSafeModeStatus.PENDING_THRESHOLD, (Object)this.getSafeModeStatus());
    }

    @Test(timeout=10000L)
    public void testCheckSafeMode7() throws Exception {
        ((FSNamesystem)Mockito.doReturn((Object)false).when((Object)this.fsn)).inTransitionToActive();
        this.bmSafeMode.activate(10L);
        Whitebox.setInternalState((Object)this.bmSafeMode, (String)"extension", (Object)5);
        this.setBlockSafe(9L);
        this.bmSafeMode.checkSafeMode();
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return TestBlockManagerSafeMode.this.getSafeModeStatus() == BlockManagerSafeMode.BMSafeModeStatus.OFF;
            }
        }, (int)100, (int)10000);
    }

    @Test(timeout=30000L)
    public void testIncrementSafeBlockCount() {
        this.bmSafeMode.activate(10L);
        Whitebox.setInternalState((Object)this.bmSafeMode, (String)"extension", (Object)0);
        for (long i = 1L; i <= 10L; ++i) {
            BlockInfo blockInfo = (BlockInfo)Mockito.mock(BlockInfo.class);
            ((BlockInfo)Mockito.doReturn((Object)false).when((Object)blockInfo)).isStriped();
            this.bmSafeMode.incrementSafeBlockCount(1, blockInfo);
            if (i < 9L) {
                Assert.assertEquals((long)i, (long)this.getblockSafe());
                Assert.assertTrue((boolean)this.bmSafeMode.isInSafeMode());
                continue;
            }
            Assert.assertFalse((boolean)this.bmSafeMode.isInSafeMode());
            Assert.assertEquals((long)9L, (long)this.getblockSafe());
        }
    }

    @Test(timeout=30000L)
    public void testIncrementSafeBlockCountWithExtension() throws Exception {
        this.bmSafeMode.activate(10L);
        for (long i = 1L; i <= 10L; ++i) {
            BlockInfo blockInfo = (BlockInfo)Mockito.mock(BlockInfo.class);
            ((BlockInfo)Mockito.doReturn((Object)false).when((Object)blockInfo)).isStriped();
            this.bmSafeMode.incrementSafeBlockCount(1, blockInfo);
            if (i >= 9L) continue;
            Assert.assertTrue((boolean)this.bmSafeMode.isInSafeMode());
        }
        this.waitForExtensionPeriod();
        Assert.assertFalse((boolean)this.bmSafeMode.isInSafeMode());
    }

    @Test(timeout=30000L)
    public void testDecrementSafeBlockCount() {
        this.bmSafeMode.activate(10L);
        Whitebox.setInternalState((Object)this.bmSafeMode, (String)"extension", (Object)0);
        this.mockBlockManagerForBlockSafeDecrement();
        this.setBlockSafe(9L);
        for (long i = 9L; i > 0L; --i) {
            BlockInfo blockInfo = (BlockInfo)Mockito.mock(BlockInfo.class);
            this.bmSafeMode.decrementSafeBlockCount(blockInfo);
            Assert.assertEquals((long)(i - 1L), (long)this.getblockSafe());
            Assert.assertTrue((boolean)this.bmSafeMode.isInSafeMode());
        }
    }

    @Test(timeout=30000L)
    public void testIncrementAndDecrementSafeBlockCount() {
        this.bmSafeMode.activate(10L);
        Whitebox.setInternalState((Object)this.bmSafeMode, (String)"extension", (Object)0);
        this.mockBlockManagerForBlockSafeDecrement();
        for (long i = 1L; i <= 10L; ++i) {
            BlockInfo blockInfo = (BlockInfo)Mockito.mock(BlockInfo.class);
            ((BlockInfo)Mockito.doReturn((Object)false).when((Object)blockInfo)).isStriped();
            this.bmSafeMode.incrementSafeBlockCount(1, blockInfo);
            this.bmSafeMode.decrementSafeBlockCount(blockInfo);
            this.bmSafeMode.incrementSafeBlockCount(1, blockInfo);
            if (i < 9L) {
                Assert.assertEquals((long)i, (long)this.getblockSafe());
                Assert.assertTrue((boolean)this.bmSafeMode.isInSafeMode());
                continue;
            }
            Assert.assertEquals((long)9L, (long)this.getblockSafe());
            Assert.assertFalse((boolean)this.bmSafeMode.isInSafeMode());
        }
    }

    @Test(timeout=30000L)
    public void testSafeModeMonitor() throws Exception {
        this.bmSafeMode.activate(10L);
        this.setBlockSafe(9L);
        this.bmSafeMode.checkSafeMode();
        Assert.assertTrue((boolean)this.bmSafeMode.isInSafeMode());
        this.waitForExtensionPeriod();
        Assert.assertFalse((boolean)this.bmSafeMode.isInSafeMode());
    }

    @Test(timeout=30000L)
    public void testDatanodeThreshodShouldBeMet() throws Exception {
        this.bmSafeMode.activate(10L);
        Mockito.when((Object)this.dn.getNumLiveDataNodes()).thenReturn((Object)1);
        this.setBlockSafe(9L);
        this.bmSafeMode.checkSafeMode();
        Assert.assertTrue((boolean)this.bmSafeMode.isInSafeMode());
        Mockito.when((Object)this.dn.getNumLiveDataNodes()).thenReturn((Object)3);
        this.bmSafeMode.checkSafeMode();
        this.waitForExtensionPeriod();
        Assert.assertFalse((boolean)this.bmSafeMode.isInSafeMode());
    }

    @Test(timeout=30000L)
    public void testStayInSafeModeWhenBytesInFuture() throws Exception {
        this.bmSafeMode.activate(10L);
        this.injectBlocksWithFugureGS(100L);
        Assert.assertEquals((long)100L, (long)this.bmSafeMode.getBytesInFuture());
        this.setBlockSafe(9L);
        this.bmSafeMode.checkSafeMode();
        Assert.assertFalse((String)"Shouldn't leave safe mode in case of blocks with future GS! ", (boolean)this.bmSafeMode.leaveSafeMode(false));
        Assert.assertTrue((String)"Leaving safe mode forcefully should succeed regardless of blocks with future GS.", (boolean)this.bmSafeMode.leaveSafeMode(true));
        Assert.assertEquals((String)"Number of blocks with future GS should have been cleared after leaving safe mode", (long)0L, (long)this.bmSafeMode.getBytesInFuture());
        Assert.assertTrue((String)"Leaving safe mode should succeed after blocks with future GS are cleared.", (boolean)this.bmSafeMode.leaveSafeMode(false));
    }

    @Test(timeout=10000L)
    public void testExtensionConfig() {
        HdfsConfiguration conf = new HdfsConfiguration();
        this.bmSafeMode = new BlockManagerSafeMode(this.bm, (Namesystem)this.fsn, false, (Configuration)conf);
        Assert.assertEquals((long)30000L, (long)this.bmSafeMode.extension);
        conf.set("dfs.namenode.safemode.extension", "30000");
        this.bmSafeMode = new BlockManagerSafeMode(this.bm, (Namesystem)this.fsn, false, (Configuration)conf);
        Assert.assertEquals((long)30000L, (long)this.bmSafeMode.extension);
        conf.set("dfs.namenode.safemode.extension", "20s");
        this.bmSafeMode = new BlockManagerSafeMode(this.bm, (Namesystem)this.fsn, false, (Configuration)conf);
        Assert.assertEquals((long)20000L, (long)this.bmSafeMode.extension);
        conf.set("dfs.namenode.safemode.extension", "7m");
        this.bmSafeMode = new BlockManagerSafeMode(this.bm, (Namesystem)this.fsn, false, (Configuration)conf);
        Assert.assertEquals((long)420000L, (long)this.bmSafeMode.extension);
    }

    @Test(timeout=30000L)
    public void testGetSafeModeTip() throws Exception {
        this.bmSafeMode.activate(10L);
        String tip = this.bmSafeMode.getSafeModeTip();
        Assert.assertTrue((boolean)tip.contains(String.format("The reported blocks %d needs additional %d blocks to reach the threshold %.4f of total blocks %d.%n", 0, 9L, 0.99, 10L)));
        Assert.assertTrue((boolean)tip.contains(String.format("The number of live datanodes %d has reached the minimum number %d. ", this.dn.getNumLiveDataNodes(), 3)));
        Assert.assertTrue((boolean)tip.contains("Safe mode will be turned off automatically once the thresholds have been reached."));
        this.setBlockSafe(9L);
        this.bmSafeMode.checkSafeMode();
        tip = this.bmSafeMode.getSafeModeTip();
        Assert.assertTrue((boolean)tip.contains(String.format("The reported blocks %d has reached the threshold %.4f of total blocks %d. ", this.getblockSafe(), 0.99, 10L)));
        Assert.assertTrue((boolean)tip.contains(String.format("The number of live datanodes %d has reached the minimum number %d. ", this.dn.getNumLiveDataNodes(), 3)));
        Assert.assertTrue((boolean)tip.contains("In safe mode extension. Safe mode will be turned off automatically in"));
        this.waitForExtensionPeriod();
        tip = this.bmSafeMode.getSafeModeTip();
        Assert.assertTrue((boolean)tip.contains(String.format("The reported blocks %d has reached the threshold %.4f of total blocks %d. ", this.getblockSafe(), 0.99, 10L)));
        Assert.assertTrue((boolean)tip.contains(String.format("The number of live datanodes %d has reached the minimum number %d. ", this.dn.getNumLiveDataNodes(), 3)));
        Assert.assertTrue((boolean)tip.contains("Safe mode will be turned off automatically soon"));
    }

    @Test(timeout=30000L)
    public void testGetSafeModeTipForBlocksWithFutureGS() throws Exception {
        this.bmSafeMode.activate(10L);
        this.injectBlocksWithFugureGS(40L);
        String tip = this.bmSafeMode.getSafeModeTip();
        Assert.assertTrue((boolean)tip.contains(String.format("The reported blocks %d needs additional %d blocks to reach the threshold %.4f of total blocks %d.%n", 0, 9L, 0.99, 10L)));
        Assert.assertTrue((boolean)tip.contains("Name node detected blocks with generation stamps in future. This means that Name node metadata is inconsistent. This can happen if Name node metadata files have been manually replaced. Exiting safe mode will cause loss of 40 byte(s). Please restart name node with right metadata or use \"hdfs dfsadmin -safemode forceExit\" if you are certain that the NameNode was started with the correct FsImage and edit logs. If you encountered this during a rollback, it is safe to exit with -safemode forceExit."));
        Assert.assertFalse((boolean)tip.contains("Safe mode will be turned off"));
        this.setBlockSafe(9L);
        tip = this.bmSafeMode.getSafeModeTip();
        Assert.assertTrue((boolean)tip.contains(String.format("The reported blocks %d has reached the threshold %.4f of total blocks %d. ", this.getblockSafe(), 0.99, 10L)));
        Assert.assertTrue((boolean)tip.contains("Name node detected blocks with generation stamps in future. This means that Name node metadata is inconsistent. This can happen if Name node metadata files have been manually replaced. Exiting safe mode will cause loss of 40 byte(s). Please restart name node with right metadata or use \"hdfs dfsadmin -safemode forceExit\" if you are certain that the NameNode was started with the correct FsImage and edit logs. If you encountered this during a rollback, it is safe to exit with -safemode forceExit."));
        Assert.assertFalse((boolean)tip.contains("Safe mode will be turned off"));
    }

    private void mockBlockManagerForBlockSafeDecrement() {
        BlockInfo storedBlock = (BlockInfo)Mockito.mock(BlockInfo.class);
        Mockito.when((Object)storedBlock.isComplete()).thenReturn((Object)true);
        ((BlockManager)Mockito.doReturn((Object)storedBlock).when((Object)this.bm)).getStoredBlock((Block)Matchers.any(Block.class));
        NumberReplicas numberReplicas = (NumberReplicas)Mockito.mock(NumberReplicas.class);
        Mockito.when((Object)numberReplicas.liveReplicas()).thenReturn((Object)0);
        ((BlockManager)Mockito.doReturn((Object)numberReplicas).when((Object)this.bm)).countNodes((BlockInfo)Matchers.any(BlockInfo.class));
    }

    private void waitForExtensionPeriod() throws Exception {
        Assert.assertEquals((Object)BlockManagerSafeMode.BMSafeModeStatus.EXTENSION, (Object)this.getSafeModeStatus());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return TestBlockManagerSafeMode.this.getSafeModeStatus() != BlockManagerSafeMode.BMSafeModeStatus.EXTENSION;
            }
        }, (int)100, (int)2000);
    }

    private void injectBlocksWithFugureGS(long numBytesInFuture) {
        BlockListAsLongs.BlockReportReplica brr = (BlockListAsLongs.BlockReportReplica)Mockito.mock(BlockListAsLongs.BlockReportReplica.class);
        Mockito.when((Object)brr.getBytesOnDisk()).thenReturn((Object)numBytesInFuture);
        this.bmSafeMode.checkBlocksWithFutureGS(brr);
    }

    private void setSafeModeStatus(BlockManagerSafeMode.BMSafeModeStatus status) {
        Whitebox.setInternalState((Object)this.bmSafeMode, (String)"status", (Object)status);
    }

    private BlockManagerSafeMode.BMSafeModeStatus getSafeModeStatus() {
        return (BlockManagerSafeMode.BMSafeModeStatus)Whitebox.getInternalState((Object)this.bmSafeMode, (String)"status");
    }

    private void setBlockSafe(long blockSafe) {
        Whitebox.setInternalState((Object)this.bmSafeMode, (String)"blockSafe", (Object)blockSafe);
    }

    private long getblockSafe() {
        return (Long)Whitebox.getInternalState((Object)this.bmSafeMode, (String)"blockSafe");
    }
}

