/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ReplicatedBlockStats {
    private final long lowRedundancyBlocks;
    private final long corruptBlocks;
    private final long missingBlocks;
    private final long missingReplicationOneBlocks;
    private final long bytesInFutureBlocks;
    private final long pendingDeletionBlocks;

    public ReplicatedBlockStats(long lowRedundancyBlocks, long corruptBlocks, long missingBlocks, long missingReplicationOneBlocks, long bytesInFutureBlocks, long pendingDeletionBlocks) {
        this.lowRedundancyBlocks = lowRedundancyBlocks;
        this.corruptBlocks = corruptBlocks;
        this.missingBlocks = missingBlocks;
        this.missingReplicationOneBlocks = missingReplicationOneBlocks;
        this.bytesInFutureBlocks = bytesInFutureBlocks;
        this.pendingDeletionBlocks = pendingDeletionBlocks;
    }

    public long getLowRedundancyBlocks() {
        return this.lowRedundancyBlocks;
    }

    public long getCorruptBlocks() {
        return this.corruptBlocks;
    }

    public long getMissingReplicaBlocks() {
        return this.missingBlocks;
    }

    public long getMissingReplicationOneBlocks() {
        return this.missingReplicationOneBlocks;
    }

    public long getBytesInFutureBlocks() {
        return this.bytesInFutureBlocks;
    }

    public long getPendingDeletionBlocks() {
        return this.pendingDeletionBlocks;
    }

    public String toString() {
        StringBuilder statsBuilder = new StringBuilder();
        statsBuilder.append("ReplicatedBlockStats=[").append("LowRedundancyBlocks=").append(this.getLowRedundancyBlocks()).append(", CorruptBlocks=").append(this.getCorruptBlocks()).append(", MissingReplicaBlocks=").append(this.getMissingReplicaBlocks()).append(", MissingReplicationOneBlocks=").append(this.getMissingReplicationOneBlocks()).append(", BytesInFutureBlocks=").append(this.getBytesInFutureBlocks()).append(", PendingDeletionBlocks=").append(this.getPendingDeletionBlocks()).append("]");
        return statsBuilder.toString();
    }
}

