/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.util.FalconRadixUtils;

public class RadixNode<T> {
    private String key = "";
    private List<RadixNode<T>> children = new LinkedList<RadixNode<T>>();
    private boolean isTerminal = false;
    private Set<T> values = new HashSet<T>();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public List<RadixNode<T>> getChildren() {
        return this.children;
    }

    public void setChildren(List<RadixNode<T>> children) {
        this.children = children;
    }

    public boolean isTerminal() {
        return this.isTerminal;
    }

    public void setTerminal(boolean isTerminalNew) {
        this.isTerminal = isTerminalNew;
    }

    public boolean isRoot() {
        return StringUtils.equals((CharSequence)this.key, (CharSequence)"");
    }

    public Collection<T> getValues() {
        return Collections.unmodifiableCollection(this.values);
    }

    public void setValues(Collection<T> newValues) {
        this.values = new HashSet<T>();
        this.values.addAll(newValues);
    }

    public void addValue(T value) {
        this.values.add(value);
    }

    public void removeValue(T value) {
        this.values.remove(value);
    }

    public void removeAll() {
        this.values.clear();
    }

    public boolean containsValue(T value) {
        return this.values.contains(value);
    }

    public int getMatchLength(String input) {
        int matchLength;
        if (input == null) {
            return 0;
        }
        for (matchLength = 0; matchLength < this.key.length() && matchLength < input.length() && input.charAt(matchLength) == this.key.charAt(matchLength); ++matchLength) {
        }
        return matchLength;
    }

    public boolean matches(String input, FalconRadixUtils.INodeAlgorithm matcher) {
        if (input == null) {
            return false;
        }
        if (matcher == null) {
            return StringUtils.equals((CharSequence)this.getKey(), (CharSequence)input);
        }
        return matcher.match(this.getKey(), input);
    }
}

