/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.security.AuthorizationProvider;
import org.apache.falcon.security.CurrentUser;
import org.apache.falcon.util.ReflectionUtils;
import org.apache.falcon.util.StartupProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtil {
    private static final String CONFIG_PREFIX = "falcon.authentication.";
    public static final String AUTHENTICATION_TYPE = "falcon.authentication.type";
    public static final String NN_PRINCIPAL = "dfs.namenode.kerberos.principal";
    public static final String HIVE_METASTORE_KERBEROS_PRINCIPAL = "hive.metastore.kerberos.principal";
    public static final String METASTORE_USE_THRIFT_SASL = "hive.metastore.sasl.enabled";
    public static final String METASTORE_PRINCIPAL = "hcat.metastore.principal";
    private static final Logger LOG = LoggerFactory.getLogger(SecurityUtil.class);

    private SecurityUtil() {
    }

    public static String getAuthenticationType() {
        return StartupProperties.get().getProperty(AUTHENTICATION_TYPE, "simple");
    }

    public static boolean isSecurityEnabled() {
        boolean useKerberos;
        String authenticationType = StartupProperties.get().getProperty(AUTHENTICATION_TYPE, "simple");
        if (authenticationType == null || "simple".equals(authenticationType)) {
            useKerberos = false;
        } else if ("kerberos".equals(authenticationType)) {
            useKerberos = true;
        } else {
            throw new IllegalArgumentException("Invalid attribute value for falcon.authentication.type of " + authenticationType);
        }
        return useKerberos;
    }

    public static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static boolean isAuthorizationEnabled() {
        return Boolean.valueOf(StartupProperties.get().getProperty("falcon.security.authorization.enabled", "false"));
    }

    public static AuthorizationProvider getAuthorizationProvider() throws FalconException {
        String providerClassName = StartupProperties.get().getProperty("falcon.security.authorization.provider", "org.apache.falcon.security.DefaultAuthorizationProvider");
        return (AuthorizationProvider)ReflectionUtils.getInstanceByClassName(providerClassName);
    }

    public static void tryProxy(Entity entity, String doAsUser) throws IOException, FalconException {
        if (entity != null && entity.getACL() != null && SecurityUtil.isAuthorizationEnabled()) {
            String aclOwner = entity.getACL().getOwner();
            String aclGroup = entity.getACL().getGroup();
            if (StringUtils.isNotEmpty((CharSequence)doAsUser)) {
                if (!doAsUser.equalsIgnoreCase(aclOwner)) {
                    LOG.warn("doAs user {} not same as acl owner {}. Ignoring acl owner.", (Object)doAsUser, (Object)aclOwner);
                    throw new FalconException("doAs user and ACL owner mismatch. doAs user " + doAsUser + " should be same as ACL owner " + aclOwner);
                }
                return;
            }
            if (SecurityUtil.getAuthorizationProvider().shouldProxy(CurrentUser.getAuthenticatedUGI(), aclOwner, aclGroup)) {
                CurrentUser.proxy(aclOwner, aclGroup);
            }
        }
    }
}

