/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.metadata;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphQuery;
import com.tinkerpop.blueprints.Vertex;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.entity.v0.SchemaHelper;
import org.apache.falcon.metadata.RelationshipLabel;
import org.apache.falcon.metadata.RelationshipProperty;
import org.apache.falcon.metadata.RelationshipType;
import org.apache.falcon.security.CurrentUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationshipGraphBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RelationshipGraphBuilder.class);
    private final Graph graph;
    private final boolean preserveHistory;

    protected RelationshipGraphBuilder(Graph graph, boolean preserveHistory) {
        this.graph = graph;
        this.preserveHistory = preserveHistory;
    }

    public Graph getGraph() {
        return this.graph;
    }

    protected boolean isPreserveHistory() {
        return this.preserveHistory;
    }

    public Vertex addVertex(String name, RelationshipType type) {
        Vertex vertex = this.findVertex(name, type);
        if (vertex != null) {
            LOG.debug("Found an existing vertex for: name={}, type={}", (Object)name, (Object)type);
            return vertex;
        }
        return this.createVertex(name, type);
    }

    protected Vertex addVertex(String name, RelationshipType type, long timestamp) {
        Vertex vertex = this.findVertex(name, type);
        if (vertex != null) {
            LOG.debug("Found an existing vertex for: name={}, type={}", (Object)name, (Object)type);
            return vertex;
        }
        return this.createVertex(name, type, timestamp);
    }

    protected Vertex findVertex(String name, RelationshipType type) {
        LOG.debug("Finding vertex for: name={}, type={}", (Object)name, (Object)type);
        GraphQuery query = this.graph.query().has(RelationshipProperty.NAME.getName(), (Object)name).has(RelationshipProperty.TYPE.getName(), (Object)type.getName());
        Iterator results = query.vertices().iterator();
        return results.hasNext() ? (Vertex)results.next() : null;
    }

    protected Vertex createVertex(String name, RelationshipType type) {
        return this.createVertex(name, type, System.currentTimeMillis());
    }

    protected Vertex createVertex(String name, RelationshipType type, long timestamp) {
        LOG.debug("Creating a new vertex for: name={}, type={}", (Object)name, (Object)type);
        Vertex vertex = this.graph.addVertex(null);
        vertex.setProperty(RelationshipProperty.NAME.getName(), (Object)name);
        vertex.setProperty(RelationshipProperty.TYPE.getName(), (Object)type.getName());
        vertex.setProperty(RelationshipProperty.TIMESTAMP.getName(), (Object)timestamp);
        return vertex;
    }

    protected Edge addEdge(Vertex fromVertex, Vertex toVertex, String edgeLabel) {
        return this.addEdge(fromVertex, toVertex, edgeLabel, null);
    }

    protected Edge addEdge(Vertex fromVertex, Vertex toVertex, String edgeLabel, String timestamp) {
        Edge edgeToVertex;
        Edge edge = this.findEdge(fromVertex, toVertex, edgeLabel);
        Edge edge2 = edgeToVertex = edge != null ? edge : fromVertex.addEdge(edgeLabel, toVertex);
        if (timestamp != null) {
            edgeToVertex.setProperty(RelationshipProperty.TIMESTAMP.getName(), (Object)timestamp);
        }
        return edgeToVertex;
    }

    protected void removeEdge(Vertex fromVertex, Vertex toVertex, String edgeLabel) {
        Edge edge = this.findEdge(fromVertex, toVertex, edgeLabel);
        if (edge != null) {
            this.getGraph().removeEdge(edge);
        }
    }

    protected void removeEdge(Vertex fromVertex, Object toVertexName, String edgeLabel) {
        Edge edge = this.findEdge(fromVertex, toVertexName, edgeLabel);
        if (edge != null) {
            this.getGraph().removeEdge(edge);
        }
    }

    protected Edge findEdge(Vertex fromVertex, Vertex toVertex, String edgeLabel) {
        return this.findEdge(fromVertex, toVertex.getProperty(RelationshipProperty.NAME.getName()), edgeLabel);
    }

    protected Edge findEdge(Vertex fromVertex, Object toVertexName, String edgeLabel) {
        Edge edgeToFind = null;
        for (Edge edge : fromVertex.getEdges(Direction.OUT, new String[]{edgeLabel})) {
            if (!edge.getVertex(Direction.IN).getProperty(RelationshipProperty.NAME.getName()).equals(toVertexName)) continue;
            edgeToFind = edge;
            break;
        }
        return edgeToFind;
    }

    protected void addUserRelation(Vertex fromVertex) {
        this.addUserRelation(fromVertex, RelationshipLabel.USER.getName());
    }

    protected void addUserRelation(Vertex fromVertex, String edgeLabel) {
        Vertex relationToUserVertex = this.addVertex(CurrentUser.getUser(), RelationshipType.USER);
        this.addEdge(fromVertex, relationToUserVertex, edgeLabel);
    }

    protected void addDataClassification(String classification, Vertex entityVertex) {
        String[] tags;
        if (classification == null || classification.length() == 0) {
            return;
        }
        for (String tag : tags = classification.split(",")) {
            int index = tag.indexOf("=");
            String tagKey = tag.substring(0, index);
            String tagValue = tag.substring(index + 1, tag.length());
            Vertex tagValueVertex = this.addVertex(tagValue, RelationshipType.TAGS);
            this.addEdge(entityVertex, tagValueVertex, tagKey);
        }
    }

    protected void addGroups(String groups, Vertex fromVertex) {
        this.addCSVTags(groups, fromVertex, RelationshipType.GROUPS, RelationshipLabel.GROUPS);
    }

    protected void addPipelines(String pipelines, Vertex fromVertex) {
        this.addCSVTags(pipelines, fromVertex, RelationshipType.PIPELINES, RelationshipLabel.PIPELINES);
    }

    protected void addProcessFeedEdge(Vertex processVertex, Vertex feedVertex, RelationshipLabel edgeLabel) {
        if (edgeLabel == RelationshipLabel.FEED_PROCESS_EDGE) {
            this.addEdge(feedVertex, processVertex, edgeLabel.getName());
        } else {
            this.addEdge(processVertex, feedVertex, edgeLabel.getName());
        }
    }

    protected String getCurrentTimeStamp() {
        return SchemaHelper.formatDateUTC((Date)new Date());
    }

    private void addCSVTags(String csvTags, Vertex fromVertex, RelationshipType relationshipType, RelationshipLabel edgeLabel) {
        String[] tags;
        if (StringUtils.isEmpty((CharSequence)csvTags)) {
            return;
        }
        for (String tag : tags = csvTags.split(",")) {
            Vertex vertex = this.addVertex(tag, relationshipType);
            this.addEdge(fromVertex, vertex, edgeLabel.getName());
        }
    }
}

