/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.metadata;

import com.thinkaurelius.titan.graphdb.blueprints.TitanBlueprintsGraph;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.GraphFactory;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.TransactionRetryHelper;
import com.tinkerpop.blueprints.util.TransactionWork;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.store.ConfigurationStore;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.metadata.EntityRelationshipGraphBuilder;
import org.apache.falcon.metadata.InstanceRelationshipGraphBuilder;
import org.apache.falcon.metadata.RelationshipProperty;
import org.apache.falcon.service.ConfigurationChangeListener;
import org.apache.falcon.service.FalconService;
import org.apache.falcon.service.Services;
import org.apache.falcon.util.StartupProperties;
import org.apache.falcon.workflow.WorkflowExecutionContext;
import org.apache.falcon.workflow.WorkflowExecutionListener;
import org.apache.falcon.workflow.WorkflowJobEndNotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataMappingService
implements FalconService,
ConfigurationChangeListener,
WorkflowExecutionListener {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataMappingService.class);
    public static final String SERVICE_NAME = MetadataMappingService.class.getSimpleName();
    private static final String FALCON_PREFIX = "falcon.graph.";
    private Graph graph;
    private Set<String> vertexIndexedKeys;
    private Set<String> edgeIndexedKeys;
    private EntityRelationshipGraphBuilder entityGraphBuilder;
    private InstanceRelationshipGraphBuilder instanceGraphBuilder;
    private int transactionRetries;
    private long transactionRetryDelayInMillis;

    @Override
    public String getName() {
        return SERVICE_NAME;
    }

    @Override
    public void init() throws FalconException {
        this.graph = this.initializeGraphDB();
        this.createIndicesForVertexKeys();
        LOG.info("Initialized graph db: {}", (Object)this.graph);
        this.vertexIndexedKeys = this.getIndexableGraph().getIndexedKeys(Vertex.class);
        LOG.info("Init vertex property keys: {}", this.vertexIndexedKeys);
        this.edgeIndexedKeys = this.getIndexableGraph().getIndexedKeys(Edge.class);
        LOG.info("Init edge property keys: {}", this.edgeIndexedKeys);
        boolean preserveHistory = Boolean.valueOf(StartupProperties.get().getProperty("falcon.graph.preserve.history", "false"));
        this.entityGraphBuilder = new EntityRelationshipGraphBuilder(this.graph, preserveHistory);
        this.instanceGraphBuilder = new InstanceRelationshipGraphBuilder(this.graph, preserveHistory);
        ConfigurationStore.get().registerListener(this);
        ((WorkflowJobEndNotificationService)Services.get().getService(WorkflowJobEndNotificationService.SERVICE_NAME)).registerListener(this);
        try {
            this.transactionRetries = Integer.parseInt(StartupProperties.get().getProperty("falcon.graph.transaction.retry.count", "3"));
            this.transactionRetryDelayInMillis = Long.parseLong(StartupProperties.get().getProperty("falcon.graph.transaction.retry.delay", "5"));
        }
        catch (NumberFormatException e) {
            throw new FalconException("Invalid values for graph transaction retry delay/count " + e);
        }
    }

    protected Graph initializeGraphDB() {
        LOG.info("Initializing graph db");
        Configuration graphConfig = MetadataMappingService.getConfiguration();
        return GraphFactory.open((Configuration)graphConfig);
    }

    public static Configuration getConfiguration() {
        BaseConfiguration graphConfig = new BaseConfiguration();
        Properties configProperties = StartupProperties.get();
        for (Map.Entry<Object, Object> entry : configProperties.entrySet()) {
            String name = (String)entry.getKey();
            if (!name.startsWith(FALCON_PREFIX)) continue;
            String value = (String)entry.getValue();
            name = name.substring(FALCON_PREFIX.length());
            graphConfig.setProperty(name, (Object)value);
        }
        return graphConfig;
    }

    protected void createIndicesForVertexKeys() {
        if (!((KeyIndexableGraph)this.graph).getIndexedKeys(Vertex.class).isEmpty()) {
            LOG.info("Indexes already exist for graph");
            return;
        }
        LOG.info("Indexes does not exist, Creating indexes for graph");
        this.makeNameKeyIndex();
        this.makeKeyIndex(RelationshipProperty.TYPE.getName());
        this.makeKeyIndex(RelationshipProperty.TIMESTAMP.getName());
        this.makeKeyIndex(RelationshipProperty.VERSION.getName());
    }

    private void makeNameKeyIndex() {
        this.getTitanGraph().makeKey(RelationshipProperty.NAME.getName()).dataType(String.class).indexed(Vertex.class).indexed(Edge.class).make();
        this.getTitanGraph().commit();
    }

    private void makeKeyIndex(String key) {
        this.getTitanGraph().makeKey(key).dataType(String.class).indexed(Vertex.class).make();
        this.getTitanGraph().commit();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public KeyIndexableGraph getIndexableGraph() {
        return (KeyIndexableGraph)this.graph;
    }

    public TransactionalGraph getTransactionalGraph() {
        return (TransactionalGraph)this.graph;
    }

    public TitanBlueprintsGraph getTitanGraph() {
        return (TitanBlueprintsGraph)this.graph;
    }

    public Set<String> getVertexIndexedKeys() {
        return this.vertexIndexedKeys;
    }

    public Set<String> getEdgeIndexedKeys() {
        return this.edgeIndexedKeys;
    }

    @Override
    public void destroy() throws FalconException {
        ((WorkflowJobEndNotificationService)Services.get().getService(WorkflowJobEndNotificationService.SERVICE_NAME)).unregisterListener(this);
        LOG.info("Shutting down graph db");
        this.graph.shutdown();
    }

    @Override
    public void onAdd(final Entity entity) throws FalconException {
        EntityType entityType = entity.getEntityType();
        LOG.info("Adding lineage for entity: {}, type: {}", (Object)entity.getName(), (Object)entityType);
        try {
            new TransactionRetryHelper.Builder(this.getTransactionalGraph()).perform((TransactionWork)new TransactionWork<Void>(){

                public Void execute(TransactionalGraph transactionalGraph) throws Exception {
                    MetadataMappingService.this.entityGraphBuilder.addEntity(entity);
                    transactionalGraph.commit();
                    return null;
                }
            }).build().exponentialBackoff(this.transactionRetries, this.transactionRetryDelayInMillis);
        }
        catch (Exception e) {
            this.getTransactionalGraph().rollback();
            throw new FalconException(e);
        }
    }

    @Override
    public void onRemove(Entity entity) throws FalconException {
    }

    @Override
    public void onChange(final Entity oldEntity, final Entity newEntity) throws FalconException {
        EntityType entityType = newEntity.getEntityType();
        LOG.info("Updating lineage for entity: {}, type: {}", (Object)newEntity.getName(), (Object)entityType);
        try {
            new TransactionRetryHelper.Builder(this.getTransactionalGraph()).perform((TransactionWork)new TransactionWork<Void>(){

                public Void execute(TransactionalGraph transactionalGraph) throws Exception {
                    MetadataMappingService.this.entityGraphBuilder.updateEntity(oldEntity, newEntity);
                    transactionalGraph.commit();
                    return null;
                }
            }).build().exponentialBackoff(this.transactionRetries, this.transactionRetryDelayInMillis);
        }
        catch (Exception e) {
            this.getTransactionalGraph().rollback();
            throw new FalconException(e);
        }
    }

    @Override
    public void onReload(Entity entity) throws FalconException {
        this.onAdd(entity);
    }

    @Override
    public void onSuccess(final WorkflowExecutionContext context) throws FalconException {
        LOG.info("Adding lineage for context {}", (Object)context);
        try {
            new TransactionRetryHelper.Builder(this.getTransactionalGraph()).perform((TransactionWork)new TransactionWork<Void>(){

                public Void execute(TransactionalGraph transactionalGraph) throws Exception {
                    MetadataMappingService.this.onSuccessfulExecution(context);
                    transactionalGraph.commit();
                    return null;
                }
            }).build().exponentialBackoff(this.transactionRetries, this.transactionRetryDelayInMillis);
        }
        catch (Exception e) {
            this.getTransactionalGraph().rollback();
            throw new FalconException(e);
        }
    }

    private void onSuccessfulExecution(WorkflowExecutionContext context) throws FalconException {
        WorkflowExecutionContext.EntityOperations entityOperation = context.getOperation();
        switch (entityOperation) {
            case GENERATE: {
                this.onProcessInstanceExecuted(context);
                break;
            }
            case REPLICATE: {
                this.onFeedInstanceReplicated(context);
                break;
            }
            case DELETE: {
                this.onFeedInstanceEvicted(context);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid EntityOperation" + (Object)((Object)entityOperation));
            }
        }
    }

    @Override
    public void onFailure(WorkflowExecutionContext context) throws FalconException {
    }

    @Override
    public void onStart(WorkflowExecutionContext context) throws FalconException {
    }

    @Override
    public void onSuspend(WorkflowExecutionContext context) throws FalconException {
    }

    @Override
    public void onWait(WorkflowExecutionContext context) throws FalconException {
    }

    private void onProcessInstanceExecuted(WorkflowExecutionContext context) throws FalconException {
        Vertex processInstance = this.instanceGraphBuilder.addProcessInstance(context);
        this.instanceGraphBuilder.addOutputFeedInstances(context, processInstance);
        this.instanceGraphBuilder.addInputFeedInstances(context, processInstance);
    }

    private void onFeedInstanceReplicated(WorkflowExecutionContext context) throws FalconException {
        LOG.info("Adding replicated feed instance: {}", (Object)context.getNominalTimeAsISO8601());
        this.instanceGraphBuilder.addReplicatedInstance(context);
    }

    private void onFeedInstanceEvicted(WorkflowExecutionContext context) throws FalconException {
        LOG.info("Adding evicted feed instance: {}", (Object)context.getNominalTimeAsISO8601());
        this.instanceGraphBuilder.addEvictedInstance(context);
    }
}

