/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.metadata;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.CatalogStorage;
import org.apache.falcon.entity.FeedHelper;
import org.apache.falcon.entity.Storage;
import org.apache.falcon.entity.common.FeedDataPath;
import org.apache.falcon.entity.store.ConfigurationStore;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.SchemaHelper;
import org.apache.falcon.entity.v0.cluster.Cluster;
import org.apache.falcon.entity.v0.feed.Feed;
import org.apache.falcon.entity.v0.feed.LocationType;
import org.apache.falcon.entity.v0.process.Process;
import org.apache.falcon.metadata.RelationshipGraphBuilder;
import org.apache.falcon.metadata.RelationshipLabel;
import org.apache.falcon.metadata.RelationshipProperty;
import org.apache.falcon.metadata.RelationshipType;
import org.apache.falcon.workflow.WorkflowExecutionArgs;
import org.apache.falcon.workflow.WorkflowExecutionContext;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceRelationshipGraphBuilder
extends RelationshipGraphBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(InstanceRelationshipGraphBuilder.class);
    private static final String FEED_INSTANCE_FORMAT = "yyyyMMddHHmm";
    private static final String NONE = "NONE";
    private static final String IGNORE = "IGNORE";
    private static final WorkflowExecutionArgs[] INSTANCE_WORKFLOW_PROPERTIES = new WorkflowExecutionArgs[]{WorkflowExecutionArgs.USER_WORKFLOW_NAME, WorkflowExecutionArgs.USER_WORKFLOW_ENGINE, WorkflowExecutionArgs.WORKFLOW_ID, WorkflowExecutionArgs.RUN_ID, WorkflowExecutionArgs.STATUS, WorkflowExecutionArgs.WF_ENGINE_URL, WorkflowExecutionArgs.USER_SUBFLOW_ID};

    public InstanceRelationshipGraphBuilder(Graph graph, boolean preserveHistory) {
        super(graph, preserveHistory);
    }

    public Vertex addProcessInstance(WorkflowExecutionContext context) throws FalconException {
        String processInstanceName = this.getProcessInstanceName(context);
        LOG.info("Adding process instance: {}", (Object)processInstanceName);
        Vertex processInstance = this.addVertex(processInstanceName, RelationshipType.PROCESS_INSTANCE, context.getTimeStampAsLong());
        this.addWorkflowInstanceProperties(processInstance, context);
        this.addInstanceToEntity(processInstance, context.getEntityName(), RelationshipType.PROCESS_ENTITY, RelationshipLabel.INSTANCE_ENTITY_EDGE);
        this.addInstanceToEntity(processInstance, context.getClusterName(), RelationshipType.CLUSTER_ENTITY, RelationshipLabel.PROCESS_CLUSTER_EDGE);
        this.addInstanceToEntity(processInstance, context.getWorkflowUser(), RelationshipType.USER, RelationshipLabel.USER);
        if (this.isPreserveHistory()) {
            Process process = (Process)ConfigurationStore.get().get(EntityType.PROCESS, context.getEntityName());
            this.addDataClassification(process.getTags(), processInstance);
            this.addPipelines(process.getPipelines(), processInstance);
        }
        this.addCounters(processInstance, context);
        return processInstance;
    }

    private void addCounters(Vertex processInstance, WorkflowExecutionContext context) throws FalconException {
        String counterString = this.getCounterString(context);
        if (!StringUtils.isBlank((CharSequence)counterString)) {
            this.addCountersToInstance(counterString, processInstance);
        }
    }

    private String getCounterString(WorkflowExecutionContext context) {
        if (!StringUtils.isBlank((CharSequence)context.getCounters())) {
            return context.getCounters();
        }
        return null;
    }

    public String getProcessInstanceName(WorkflowExecutionContext context) {
        return context.getEntityName() + "/" + context.getNominalTimeAsISO8601();
    }

    public void addWorkflowInstanceProperties(Vertex processInstance, WorkflowExecutionContext context) {
        for (WorkflowExecutionArgs instanceWorkflowProperty : INSTANCE_WORKFLOW_PROPERTIES) {
            this.addProperty(processInstance, context, instanceWorkflowProperty);
        }
        processInstance.setProperty(RelationshipProperty.VERSION.getName(), (Object)context.getUserWorkflowVersion());
    }

    private void addProperty(Vertex vertex, WorkflowExecutionContext context, WorkflowExecutionArgs optionName) {
        String value = context.getValue(optionName);
        if (value == null || value.length() == 0) {
            return;
        }
        vertex.setProperty(optionName.getName(), (Object)value);
    }

    private void addCountersToInstance(String counterString, Vertex vertex) throws FalconException {
        String[] counterKeyValues = counterString.split(",");
        try {
            for (String counter : counterKeyValues) {
                String[] keyVals = counter.split(":", 2);
                vertex.setProperty(keyVals[0], (Object)Long.parseLong(keyVals[1]));
            }
        }
        catch (NumberFormatException e) {
            throw new FalconException("Invalid values for counter:" + e);
        }
    }

    public void addInstanceToEntity(Vertex instanceVertex, String entityName, RelationshipType entityType, RelationshipLabel edgeLabel) {
        this.addInstanceToEntity(instanceVertex, entityName, entityType, edgeLabel, null);
    }

    public void addInstanceToEntity(Vertex instanceVertex, String entityName, RelationshipType entityType, RelationshipLabel edgeLabel, String timestamp) {
        Vertex entityVertex = this.findVertex(entityName, entityType);
        LOG.info("Vertex exists? name={}, type={}, v={}", new Object[]{entityName, entityType, entityVertex});
        if (entityVertex == null) {
            LOG.error("Illegal State: {} vertex must exist for {}", (Object)entityType, (Object)entityName);
            throw new IllegalStateException(entityType + " entity vertex must exist " + entityName);
        }
        this.addEdge(instanceVertex, entityVertex, edgeLabel.getName(), timestamp);
    }

    public void addOutputFeedInstances(WorkflowExecutionContext context, Vertex processInstance) throws FalconException {
        String outputFeedNamesArg = context.getOutputFeedNames();
        if (NONE.equals(outputFeedNamesArg) || IGNORE.equals(outputFeedNamesArg)) {
            return;
        }
        String[] outputFeedNames = context.getOutputFeedNamesList();
        String[] outputFeedInstancePaths = context.getOutputFeedInstancePathsList();
        for (int index = 0; index < outputFeedNames.length; ++index) {
            String feedName = outputFeedNames[index];
            String feedInstanceDataPath = outputFeedInstancePaths[index];
            this.addFeedInstance(processInstance, RelationshipLabel.PROCESS_FEED_EDGE, context, feedName, feedInstanceDataPath);
        }
    }

    public void addInputFeedInstances(WorkflowExecutionContext context, Vertex processInstance) throws FalconException {
        String inputFeedNamesArg = context.getInputFeedNames();
        if (NONE.equals(inputFeedNamesArg) || IGNORE.equals(inputFeedNamesArg)) {
            return;
        }
        String[] inputFeedNames = context.getInputFeedNamesList();
        String[] inputFeedInstancePaths = context.getInputFeedInstancePathsList();
        for (int index = 0; index < inputFeedNames.length; ++index) {
            String[] feedInstancePaths;
            String inputFeedName = inputFeedNames[index];
            String inputFeedInstancePath = inputFeedInstancePaths[index];
            for (String feedInstanceDataPath : feedInstancePaths = inputFeedInstancePath.split(",")) {
                this.addFeedInstance(processInstance, RelationshipLabel.FEED_PROCESS_EDGE, context, inputFeedName, feedInstanceDataPath);
            }
        }
    }

    public void addReplicatedInstance(WorkflowExecutionContext context) throws FalconException {
        String feedName = context.getOutputFeedNames();
        String feedInstanceDataPath = context.getOutputFeedInstancePaths();
        String targetClusterName = context.getClusterName();
        LOG.info("Computing feed instance for : name= {} path= {}, in cluster: {}", new Object[]{feedName, feedInstanceDataPath, targetClusterName});
        String feedInstanceName = InstanceRelationshipGraphBuilder.getFeedInstanceName(feedName, targetClusterName, feedInstanceDataPath, context.getNominalTimeAsISO8601());
        Vertex feedInstanceVertex = this.findVertex(feedInstanceName, RelationshipType.FEED_INSTANCE);
        LOG.info("Vertex exists? name={}, type={}, v={}", new Object[]{feedInstanceName, RelationshipType.FEED_INSTANCE, feedInstanceVertex});
        if (feedInstanceVertex == null) {
            LOG.info("{} instance vertex {} does not exist, add it", (Object)RelationshipType.FEED_INSTANCE, (Object)feedInstanceName);
            feedInstanceVertex = this.addFeedInstance(feedInstanceName, context, feedName, context.getSrcClusterName());
        }
        this.addInstanceToEntity(feedInstanceVertex, targetClusterName, RelationshipType.CLUSTER_ENTITY, RelationshipLabel.FEED_CLUSTER_REPLICATED_EDGE, context.getTimeStampAsISO8601());
        this.addCounters(feedInstanceVertex, context);
    }

    public void addEvictedInstance(WorkflowExecutionContext context) throws FalconException {
        String outputFeedPaths = context.getOutputFeedInstancePaths();
        if (IGNORE.equals(outputFeedPaths)) {
            LOG.info("There were no evicted instances, nothing to record");
            return;
        }
        LOG.info("Recording lineage for evicted instances {}", (Object)outputFeedPaths);
        String feedName = context.getOutputFeedNames();
        String[] evictedFeedInstancePathList = context.getOutputFeedInstancePathsList();
        String clusterName = context.getClusterName();
        for (String evictedFeedInstancePath : evictedFeedInstancePathList) {
            LOG.info("Computing feed instance for : name= {}, path={}, in cluster: {}", new Object[]{feedName, evictedFeedInstancePath, clusterName});
            String feedInstanceName = InstanceRelationshipGraphBuilder.getFeedInstanceName(feedName, clusterName, evictedFeedInstancePath, context.getNominalTimeAsISO8601());
            Vertex feedInstanceVertex = this.findVertex(feedInstanceName, RelationshipType.FEED_INSTANCE);
            LOG.info("Vertex exists? name={}, type={}, v={}", new Object[]{feedInstanceName, RelationshipType.FEED_INSTANCE, feedInstanceVertex});
            if (feedInstanceVertex == null) {
                LOG.info("{} instance vertex {} does not exist, add it", (Object)RelationshipType.FEED_INSTANCE, (Object)feedInstanceName);
                feedInstanceVertex = this.addFeedInstance(feedInstanceName, context, feedName, clusterName);
            }
            this.addInstanceToEntity(feedInstanceVertex, clusterName, RelationshipType.CLUSTER_ENTITY, RelationshipLabel.FEED_CLUSTER_EVICTED_EDGE, context.getTimeStampAsISO8601());
        }
    }

    private void addFeedInstance(Vertex processInstance, RelationshipLabel edgeLabel, WorkflowExecutionContext context, String feedName, String feedInstanceDataPath) throws FalconException {
        String clusterName = context.getClusterName();
        LOG.info("Computing feed instance for : name= {} path= {}, in cluster: {}", new Object[]{feedName, feedInstanceDataPath, clusterName});
        String feedInstanceName = InstanceRelationshipGraphBuilder.getFeedInstanceName(feedName, clusterName, feedInstanceDataPath, context.getNominalTimeAsISO8601());
        Vertex feedInstance = this.addFeedInstance(feedInstanceName, context, feedName, clusterName);
        this.addProcessFeedEdge(processInstance, feedInstance, edgeLabel);
    }

    private Vertex addFeedInstance(String feedInstanceName, WorkflowExecutionContext context, String feedName, String clusterName) throws FalconException {
        LOG.info("Adding feed instance {}", (Object)feedInstanceName);
        Vertex feedInstance = this.addVertex(feedInstanceName, RelationshipType.FEED_INSTANCE, context.getTimeStampAsLong());
        this.addInstanceToEntity(feedInstance, feedName, RelationshipType.FEED_ENTITY, RelationshipLabel.INSTANCE_ENTITY_EDGE);
        this.addInstanceToEntity(feedInstance, clusterName, RelationshipType.CLUSTER_ENTITY, RelationshipLabel.FEED_CLUSTER_EDGE);
        this.addInstanceToEntity(feedInstance, context.getWorkflowUser(), RelationshipType.USER, RelationshipLabel.USER);
        if (this.isPreserveHistory()) {
            Feed feed = (Feed)ConfigurationStore.get().get(EntityType.FEED, feedName);
            this.addDataClassification(feed.getTags(), feedInstance);
            this.addGroups(feed.getGroups(), feedInstance);
        }
        return feedInstance;
    }

    public static String getFeedInstanceName(String feedName, String clusterName, String feedInstancePath, String nominalTime) throws FalconException {
        try {
            Feed feed = (Feed)ConfigurationStore.get().get(EntityType.FEED, feedName);
            Cluster cluster = (Cluster)ConfigurationStore.get().get(EntityType.CLUSTER, clusterName);
            Storage.TYPE storageType = FeedHelper.getStorageType(feed, cluster);
            return storageType == Storage.TYPE.TABLE ? InstanceRelationshipGraphBuilder.getTableFeedInstanceName(feed, feedInstancePath, storageType) : InstanceRelationshipGraphBuilder.getFileSystemFeedInstanceName(feedInstancePath, feed, cluster, nominalTime);
        }
        catch (URISyntaxException e) {
            throw new FalconException(e);
        }
    }

    private static String getTableFeedInstanceName(Feed feed, String feedInstancePath, Storage.TYPE storageType) throws URISyntaxException {
        CatalogStorage instanceStorage = (CatalogStorage)FeedHelper.createStorage(storageType.name(), feedInstancePath);
        return feed.getName() + "/" + instanceStorage.toPartitionAsPath();
    }

    private static String getFileSystemFeedInstanceName(String feedInstancePath, Feed feed, Cluster cluster, String nominalTime) throws FalconException {
        String[] elements;
        Storage rawStorage = FeedHelper.createStorage(cluster, feed);
        String feedPathTemplate = rawStorage.getUriTemplate(LocationType.DATA);
        String instance = feedInstancePath;
        for (String element : elements = FeedDataPath.PATTERN.split(feedPathTemplate)) {
            instance = instance.replaceFirst(element, "");
        }
        Date instanceTime = FeedHelper.getDate(feedPathTemplate, new Path(feedInstancePath), TimeZone.getTimeZone("UTC"));
        return StringUtils.isEmpty((CharSequence)instance) ? feed.getName() + "/" + nominalTime : feed.getName() + "/" + SchemaHelper.formatDateUTC((Date)instanceTime);
    }
}

