/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.lifecycle.retention;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.FeedHelper;
import org.apache.falcon.entity.parser.ValidationException;
import org.apache.falcon.entity.v0.Frequency;
import org.apache.falcon.entity.v0.feed.Cluster;
import org.apache.falcon.entity.v0.feed.Feed;
import org.apache.falcon.entity.v0.feed.Property;
import org.apache.falcon.entity.v0.feed.RetentionStage;
import org.apache.falcon.entity.v0.feed.Sla;
import org.apache.falcon.expression.ExpressionHelper;
import org.apache.falcon.lifecycle.retention.RetentionPolicy;
import org.apache.falcon.util.StartupProperties;

public class AgeBasedDelete
extends RetentionPolicy {
    public static final String LIMIT_PROPERTY_NAME = "retention.policy.agebaseddelete.limit";

    @Override
    public void validate(Feed feed, String clusterName) throws FalconException {
        Cluster cluster = FeedHelper.getCluster(feed, clusterName);
        Frequency retentionLimit = this.getRetentionLimit(feed, clusterName);
        if (cluster != null) {
            this.validateLimitWithSla(feed, cluster, retentionLimit.toString());
            this.validateLimitWithLateData(feed, cluster, retentionLimit.toString());
            String lifecycleEngine = StartupProperties.get().getProperty("lifecycle.engine.impl", "org.apache.falcon.lifecycle.engine.oozie.OoziePolicyBuilderFactory");
            if ("org.apache.falcon.lifecycle.engine.oozie.OoziePolicyBuilderFactory".equals(lifecycleEngine)) {
                this.validateRetentionFrequencyForOozie(feed, clusterName);
            }
        }
    }

    private void validateRetentionFrequencyForOozie(Feed feed, String clusterName) throws FalconException {
        Frequency retentionFrequency = FeedHelper.getRetentionFrequency(feed, clusterName);
        if (retentionFrequency.getTimeUnit() == Frequency.TimeUnit.minutes && retentionFrequency.getFrequencyAsInt() < 60) {
            throw new ValidationException("Feed Retention can not be more frequent than hours(1)");
        }
    }

    private void validateLimitWithLateData(Feed feed, Cluster cluster, String retention) throws FalconException {
        String feedCutoff;
        long feedCutOffPeriod;
        ExpressionHelper evaluator = ExpressionHelper.get();
        long retentionPeriod = evaluator.evaluate(retention, Long.class);
        if (feed.getLateArrival() != null && retentionPeriod < (feedCutOffPeriod = evaluator.evaluate(feedCutoff = feed.getLateArrival().getCutOff().toString(), Long.class).longValue())) {
            throw new ValidationException("Feed's retention limit: " + retention + " of referenced cluster " + cluster.getName() + " should be more than feed's late arrival cut-off period: " + feedCutoff + " for feed: " + feed.getName());
        }
    }

    private void validateLimitWithSla(Feed feed, Cluster cluster, String retentionExpression) throws FalconException {
        Sla clusterSla = FeedHelper.getSLA(cluster, feed);
        if (clusterSla != null) {
            ExpressionHelper evaluator = ExpressionHelper.get();
            ExpressionHelper.setReferenceDate(new Date());
            Frequency slaHighExpression = clusterSla.getSlaHigh();
            Date slaHigh = new Date(evaluator.evaluate(slaHighExpression.toString(), Long.class));
            Date retention = new Date(evaluator.evaluate(retentionExpression, Long.class));
            if (slaHigh.after(retention)) {
                throw new ValidationException("slaHigh of Feed: " + slaHighExpression + " is greater than retention of the feed: " + retentionExpression + " for cluster: " + cluster.getName());
            }
        }
    }

    public Frequency getRetentionLimit(Feed feed, String clusterName) throws FalconException {
        RetentionStage retention = FeedHelper.getRetentionStage(feed, clusterName);
        if (retention != null) {
            String limit = null;
            for (Property property : retention.getProperties().getProperties()) {
                if (!StringUtils.equals((CharSequence)property.getName(), (CharSequence)LIMIT_PROPERTY_NAME)) continue;
                limit = property.getValue();
            }
            if (limit == null) {
                throw new FalconException("Property: retention.policy.agebaseddelete.limit is required for " + this.getName() + " policy.");
            }
            try {
                return new Frequency(limit);
            }
            catch (IllegalArgumentException e) {
                throw new FalconException("Invalid value for property: retention.policy.agebaseddelete.limit, should be a valid frequency e.g. hours(2)", e);
            }
        }
        throw new FalconException("Cluster " + clusterName + " doesn't contain retention stage");
    }
}

