/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.hadoop;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.lang.Validate;
import org.apache.falcon.FalconException;
import org.apache.falcon.security.CurrentUser;
import org.apache.falcon.util.StartupProperties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HadoopClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopClientFactory.class);
    public static final String FS_DEFAULT_NAME_KEY = "fs.defaultFS";
    public static final String MR_JT_ADDRESS_KEY = "mapreduce.jobtracker.address";
    public static final String YARN_RM_ADDRESS_KEY = "yarn.resourcemanager.address";
    public static final FsPermission READ_EXECUTE_PERMISSION = new FsPermission(FsAction.ALL, FsAction.READ_EXECUTE, FsAction.READ_EXECUTE);
    public static final FsPermission ALL_PERMISSION = new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL);
    private static final HadoopClientFactory INSTANCE = new HadoopClientFactory();

    private HadoopClientFactory() {
    }

    public static HadoopClientFactory get() {
        return INSTANCE;
    }

    public FileSystem createFalconFileSystem(URI uri) throws FalconException {
        Validate.notNull((Object)uri, (String)"uri cannot be null");
        try {
            Configuration conf = new Configuration();
            if (UserGroupInformation.isSecurityEnabled()) {
                conf.set("dfs.namenode.kerberos.principal", StartupProperties.get().getProperty("dfs.namenode.kerberos.principal"));
            }
            return this.createFileSystem(UserGroupInformation.getLoginUser(), uri, conf);
        }
        catch (IOException e) {
            throw new FalconException("Exception while getting FileSystem for: " + uri, e);
        }
    }

    public FileSystem createFalconFileSystem(Configuration conf) throws FalconException {
        Validate.notNull((Object)conf, (String)"configuration cannot be null");
        String nameNode = HadoopClientFactory.getNameNode(conf);
        try {
            return this.createFileSystem(UserGroupInformation.getLoginUser(), new URI(nameNode), conf);
        }
        catch (URISyntaxException e) {
            throw new FalconException("Exception while getting FileSystem for: " + nameNode, e);
        }
        catch (IOException e) {
            throw new FalconException("Exception while getting FileSystem for: " + nameNode, e);
        }
    }

    public FileSystem createProxiedFileSystem(Configuration conf) throws FalconException {
        Validate.notNull((Object)conf, (String)"configuration cannot be null");
        String nameNode = HadoopClientFactory.getNameNode(conf);
        try {
            return this.createProxiedFileSystem(new URI(nameNode), conf);
        }
        catch (URISyntaxException e) {
            throw new FalconException("Exception while getting FileSystem for: " + nameNode, e);
        }
    }

    private static String getNameNode(Configuration conf) {
        return conf.get(FS_DEFAULT_NAME_KEY);
    }

    public FileSystem createProxiedFileSystem(URI uri) throws FalconException {
        return this.createProxiedFileSystem(uri, new Configuration());
    }

    public FileSystem createProxiedFileSystem(URI uri, Configuration conf) throws FalconException {
        Validate.notNull((Object)uri, (String)"uri cannot be null");
        try {
            return this.createFileSystem(CurrentUser.getProxyUGI(), uri, conf);
        }
        catch (IOException e) {
            throw new FalconException("Exception while getting FileSystem for proxy: " + CurrentUser.getUser(), e);
        }
    }

    public FileSystem createFileSystem(UserGroupInformation ugi, final URI uri, final Configuration conf) throws FalconException {
        Validate.notNull((Object)ugi, (String)"ugi cannot be null");
        Validate.notNull((Object)conf, (String)"configuration cannot be null");
        String nameNode = uri.getAuthority();
        if (nameNode == null && (nameNode = HadoopClientFactory.getNameNode(conf)) != null) {
            try {
                new URI(nameNode).getAuthority();
            }
            catch (URISyntaxException ex) {
                throw new FalconException("Exception while getting FileSystem", ex);
            }
        }
        try {
            String proxyUserName = ugi.getShortUserName();
            if (proxyUserName.equals(UserGroupInformation.getLoginUser().getShortUserName())) {
                LOG.info("Creating FS for the login user {}, impersonation not required", (Object)proxyUserName);
                return FileSystem.get((URI)uri, (Configuration)conf);
            }
            LOG.info("Creating FS impersonating user {}", (Object)proxyUserName);
            return (FileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws Exception {
                    return FileSystem.get((URI)uri, (Configuration)conf);
                }
            });
        }
        catch (InterruptedException ex) {
            throw new FalconException("Exception creating FileSystem:" + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new FalconException("Exception creating FileSystem:" + ex.getMessage(), ex);
        }
    }

    public void validateJobClient(String executeUrl) throws IOException {
        final JobConf jobConf = new JobConf();
        jobConf.set(MR_JT_ADDRESS_KEY, executeUrl);
        jobConf.set(YARN_RM_ADDRESS_KEY, executeUrl);
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        try {
            JobClient jobClient = (JobClient)loginUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<JobClient>(){

                @Override
                public JobClient run() throws Exception {
                    return new JobClient(jobConf);
                }
            });
            jobClient.getClusterStatus().getMapTasks();
        }
        catch (InterruptedException e) {
            throw new IOException("Exception creating job client:" + e.getMessage(), e);
        }
    }

    public static FsPermission getDirDefaultPermission(Configuration conf) {
        return HadoopClientFactory.getDirDefault().applyUMask(FsPermission.getUMask((Configuration)conf));
    }

    public static FsPermission getFileDefaultPermission(Configuration conf) {
        return HadoopClientFactory.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)conf));
    }

    public static FsPermission getDirDefault() {
        return new FsPermission(511);
    }

    public static FsPermission getFileDefault() {
        return new FsPermission(438);
    }

    public static void mkdirsWithDefaultPerms(FileSystem fs, Path path) throws IOException {
        HadoopClientFactory.mkdirs(fs, path, HadoopClientFactory.getDirDefaultPermission(fs.getConf()));
    }

    public static void mkdirs(FileSystem fs, Path path, FsPermission permission) throws IOException {
        if (!FileSystem.mkdirs((FileSystem)fs, (Path)path, (FsPermission)permission)) {
            throw new IOException("mkdir failed for " + path);
        }
    }
}

