/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity.v0;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.falcon.FalconException;
import org.apache.falcon.Pair;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityGraph;
import org.apache.falcon.entity.v0.EntityType;

public final class EntityIntegrityChecker {
    private EntityIntegrityChecker() {
    }

    public static Pair<String, EntityType>[] referencedBy(Entity entity) throws FalconException {
        Set<Entity> deps = EntityGraph.get().getDependents(entity);
        if (deps == null) {
            return null;
        }
        switch (entity.getEntityType()) {
            case CLUSTER: {
                return EntityIntegrityChecker.filter(deps, EntityType.FEED, EntityType.PROCESS);
            }
            case FEED: {
                return EntityIntegrityChecker.filter(deps, EntityType.PROCESS);
            }
        }
        return null;
    }

    private static Pair<String, EntityType>[] filter(Set<Entity> deps, EntityType ... types) {
        ArrayList<Pair> filteredSet = new ArrayList<Pair>();
        List<EntityType> validTypes = Arrays.asList(types);
        for (Entity dep : deps) {
            if (!validTypes.contains(dep.getEntityType())) continue;
            filteredSet.add(Pair.of((Object)dep.getName(), (Object)dep.getEntityType()));
        }
        return filteredSet.toArray(new Pair[0]);
    }
}

