/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity.store;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.FeedHelper;
import org.apache.falcon.entity.store.FeedPathStore;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.entity.v0.feed.Cluster;
import org.apache.falcon.entity.v0.feed.Feed;
import org.apache.falcon.entity.v0.feed.Location;
import org.apache.falcon.resource.FeedLookupResult;
import org.apache.falcon.service.ConfigurationChangeListener;
import org.apache.falcon.util.DeploymentUtil;
import org.apache.falcon.util.FalconRadixUtils;
import org.apache.falcon.util.RadixTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeedLocationStore
implements ConfigurationChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(FeedLocationStore.class);
    protected final FeedPathStore<FeedLookupResult.FeedProperties> store = new RadixTree<FeedLookupResult.FeedProperties>();
    private static FeedLocationStore instance = new FeedLocationStore();

    private FeedLocationStore() {
    }

    public static FeedLocationStore get() {
        return instance;
    }

    @Override
    public void onAdd(Entity entity) throws FalconException {
        if (entity.getEntityType() == EntityType.FEED) {
            Feed feed = (Feed)entity;
            List clusters = feed.getClusters().getClusters();
            for (Cluster cluster : clusters) {
                List<Location> clusterSpecificLocations;
                if (!DeploymentUtil.getCurrentClusters().contains(cluster.getName()) || (clusterSpecificLocations = FeedHelper.getLocations(FeedHelper.getCluster(feed, cluster.getName()), feed)) == null) continue;
                for (Location location : clusterSpecificLocations) {
                    if (location == null || !StringUtils.isNotBlank((CharSequence)location.getPath())) continue;
                    FeedLookupResult.FeedProperties value = new FeedLookupResult.FeedProperties(feed.getName(), location.getType(), cluster.getName());
                    this.store.insert(StringUtils.trim((String)location.getPath()), value);
                    LOG.debug("Inserted location: {} for feed: {} and cluster: {}", new Object[]{location.getPath(), feed.getName(), cluster.getName()});
                }
            }
        }
    }

    @Override
    public void onRemove(Entity entity) throws FalconException {
        if (entity.getEntityType() == EntityType.FEED) {
            Feed feed = (Feed)entity;
            List clusters = feed.getClusters().getClusters();
            for (Cluster cluster : clusters) {
                List<Location> clusterSpecificLocations = FeedHelper.getLocations(FeedHelper.getCluster(feed, cluster.getName()), feed);
                if (clusterSpecificLocations == null) continue;
                for (Location location : clusterSpecificLocations) {
                    if (location == null || !StringUtils.isNotBlank((CharSequence)location.getPath())) continue;
                    FeedLookupResult.FeedProperties value = new FeedLookupResult.FeedProperties(feed.getName(), location.getType(), cluster.getName());
                    LOG.debug("Delete called for location: {} for feed: {} and cluster: {}", new Object[]{location.getPath(), feed.getName(), cluster.getName()});
                    this.store.delete(location.getPath(), value);
                    LOG.debug("Deleted location: {} for feed: {} and cluster: {}", new Object[]{location.getPath(), feed.getName(), cluster.getName()});
                }
            }
        }
    }

    @Override
    public void onChange(Entity oldEntity, Entity newEntity) throws FalconException {
        this.onRemove(oldEntity);
        this.onAdd(newEntity);
    }

    @Override
    public void onReload(Entity entity) throws FalconException {
        this.onAdd(entity);
    }

    public Collection<FeedLookupResult.FeedProperties> reverseLookup(String path) {
        return this.store.find(path, new FalconRadixUtils.FeedRegexAlgorithm());
    }
}

