/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.entity;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.falcon.FalconException;
import org.apache.falcon.Tag;
import org.apache.falcon.entity.EntityUtil;
import org.apache.falcon.entity.v0.SchemaHelper;

public class ExternalId {
    private static final String SEPARATOR = "/";
    private String id;

    public ExternalId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ExternalId(String name, Tag tag, String elexpr) {
        if (StringUtils.isEmpty((CharSequence)name) || tag == null || StringUtils.isEmpty((CharSequence)elexpr)) {
            throw new IllegalArgumentException("Empty inputs!");
        }
        this.id = name + SEPARATOR + tag.name() + SEPARATOR + elexpr;
    }

    public ExternalId(String name, Tag tag, Date date) {
        this(name, tag, SchemaHelper.formatDateUTC((Date)date));
    }

    public String getName() {
        String[] parts = this.id.split(SEPARATOR);
        return parts[0];
    }

    public Date getDate() throws FalconException {
        return EntityUtil.parseDateUTC(this.getDateAsString());
    }

    public String getDateAsString() {
        String[] parts = this.id.split(SEPARATOR);
        return parts[2];
    }

    public Tag getTag() {
        String[] parts = this.id.split(SEPARATOR);
        return Tag.valueOf((String)parts[1]);
    }

    public String getDFSname() {
        return this.id.replace(":", "-");
    }
}

