/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.utils.obs;

import com.netflix.astyanax.shaded.org.apache.cassandra.cache.RefCountedMemory;
import com.netflix.astyanax.shaded.org.apache.cassandra.db.TypeSizes;
import com.netflix.astyanax.shaded.org.apache.cassandra.io.util.Memory;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.obs.IBitSet;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.obs.OpenBitSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OffHeapBitSet
implements IBitSet {
    private final Memory bytes;

    public OffHeapBitSet(long numBits) {
        long wordCount = OpenBitSet.bits2words(numBits);
        if (wordCount > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Bloom filter size is > 16GB, reduce the bloom_filter_fp_chance");
        }
        try {
            long byteCount = wordCount * 8L;
            this.bytes = RefCountedMemory.allocate(byteCount);
        }
        catch (OutOfMemoryError e) {
            throw new RuntimeException("Out of native memory occured, You can avoid it by increasing the system ram space or by increasing bloom_filter_fp_chance.");
        }
        this.clear();
    }

    private OffHeapBitSet(Memory bytes) {
        this.bytes = bytes;
    }

    @Override
    public long capacity() {
        return this.bytes.size() * 8L;
    }

    @Override
    public long offHeapSize() {
        return this.bytes.size();
    }

    @Override
    public boolean get(long index) {
        long i = index >> 3;
        long bit = index & 7L;
        int bitmask = 1 << (int)bit;
        return (this.bytes.getByte(i) & bitmask) != 0;
    }

    @Override
    public void set(long index) {
        long i = index >> 3;
        long bit = index & 7L;
        int bitmask = 1 << (int)bit;
        this.bytes.setByte(i, (byte)(bitmask | this.bytes.getByte(i)));
    }

    public void set(long offset, byte b) {
        this.bytes.setByte(offset, b);
    }

    @Override
    public void clear(long index) {
        long i = index >> 3;
        long bit = index & 7L;
        int bitmask = 1 << (int)bit;
        int nativeByte = this.bytes.getByte(i) & 0xFF;
        this.bytes.setByte(i, (byte)(nativeByte &= ~bitmask));
    }

    @Override
    public void clear() {
        this.bytes.setMemory(0L, this.bytes.size(), (byte)0);
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        out.writeInt((int)(this.bytes.size() / 8L));
        long i = 0L;
        while (i < this.bytes.size()) {
            long value = (long)(((this.bytes.getByte(i++) & 0xFF) << 0) + ((this.bytes.getByte(i++) & 0xFF) << 8) + ((this.bytes.getByte(i++) & 0xFF) << 16)) + ((long)(this.bytes.getByte(i++) & 0xFF) << 24) + ((long)(this.bytes.getByte(i++) & 0xFF) << 32) + ((long)(this.bytes.getByte(i++) & 0xFF) << 40) + ((long)(this.bytes.getByte(i++) & 0xFF) << 48) + ((long)this.bytes.getByte(i++) << 56);
            out.writeLong(value);
        }
    }

    @Override
    public long serializedSize(TypeSizes type) {
        return (long)type.sizeof((int)this.bytes.size()) + this.bytes.size();
    }

    public static OffHeapBitSet deserialize(DataInput in) throws IOException {
        long byteCount = (long)in.readInt() * 8L;
        Memory memory = RefCountedMemory.allocate(byteCount);
        long i = 0L;
        while (i < byteCount) {
            long v = in.readLong();
            memory.setByte(i++, (byte)(v >>> 0));
            memory.setByte(i++, (byte)(v >>> 8));
            memory.setByte(i++, (byte)(v >>> 16));
            memory.setByte(i++, (byte)(v >>> 24));
            memory.setByte(i++, (byte)(v >>> 32));
            memory.setByte(i++, (byte)(v >>> 40));
            memory.setByte(i++, (byte)(v >>> 48));
            memory.setByte(i++, (byte)(v >>> 56));
        }
        return new OffHeapBitSet(memory);
    }

    @Override
    public void close() {
        this.bytes.free();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OffHeapBitSet)) {
            return false;
        }
        OffHeapBitSet b = (OffHeapBitSet)o;
        return this.bytes.equals(b.bytes);
    }

    public int hashCode() {
        long h = 0L;
        long i = this.bytes.size();
        while (--i >= 0L) {
            h ^= (long)this.bytes.getByte(i);
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }
}

