/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.utils;

import com.netflix.astyanax.shaded.org.apache.cassandra.utils.Allocator;
import com.netflix.astyanax.shaded.org.apache.cassandra.utils.ByteBufferUtil;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlabAllocator
extends Allocator {
    private static final Logger logger = LoggerFactory.getLogger(SlabAllocator.class);
    private static final int REGION_SIZE = 0x100000;
    private static final int MAX_CLONED_SIZE = 131072;
    private static final ConcurrentLinkedQueue<Region> RACE_ALLOCATED = new ConcurrentLinkedQueue();
    private final AtomicReference<Region> currentRegion = new AtomicReference();
    private final AtomicInteger regionCount = new AtomicInteger(0);
    private AtomicLong unslabbed = new AtomicLong(0L);

    @Override
    public ByteBuffer allocate(int size) {
        assert (size >= 0);
        if (size == 0) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        if (size > 131072) {
            this.unslabbed.addAndGet(size);
            return ByteBuffer.allocate(size);
        }
        Region region;
        ByteBuffer cloned;
        while ((cloned = (region = this.getRegion()).allocate(size)) == null) {
            this.currentRegion.compareAndSet(region, null);
        }
        return cloned;
    }

    private Region getRegion() {
        Region region;
        while ((region = this.currentRegion.get()) == null) {
            region = RACE_ALLOCATED.poll();
            if (region == null) {
                region = new Region(0x100000);
            }
            if (this.currentRegion.compareAndSet(null, region)) {
                this.regionCount.incrementAndGet();
                logger.trace("{} regions now allocated in {}", (Object)this.regionCount, (Object)this);
                return region;
            }
            RACE_ALLOCATED.add(region);
        }
        return region;
    }

    @Override
    public long getMinimumSize() {
        return this.unslabbed.get() + (long)(this.regionCount.get() - 1) * 0x100000L;
    }

    private static class Region {
        private final ByteBuffer data;
        private final AtomicInteger nextFreeOffset = new AtomicInteger(0);
        private final AtomicInteger allocCount = new AtomicInteger();

        private Region(int size) {
            this.data = ByteBuffer.allocate(size);
        }

        public ByteBuffer allocate(int size) {
            int oldOffset;
            do {
                if ((oldOffset = this.nextFreeOffset.get()) + size <= this.data.capacity()) continue;
                return null;
            } while (!this.nextFreeOffset.compareAndSet(oldOffset, oldOffset + size));
            this.allocCount.incrementAndGet();
            return (ByteBuffer)this.data.duplicate().position(oldOffset).limit(oldOffset + size);
        }

        public String toString() {
            return "Region@" + System.identityHashCode(this) + " allocs=" + this.allocCount.get() + "waste=" + (this.data.capacity() - this.nextFreeOffset.get());
        }
    }
}

