/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.shaded.org.apache.cassandra.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.nio.ByteBuffer;
import org.github.jamm.MemoryMeter;

public class ObjectSizes {
    public static final MemoryLayoutSpecification SPEC = ObjectSizes.getEffectiveMemoryLayoutSpecification();
    private static final MemoryMeter meter = new MemoryMeter().omitSharedBufferOverhead();

    public static long getFieldSize(long fieldsSize) {
        return ObjectSizes.roundTo((long)SPEC.getObjectHeaderSize() + fieldsSize, SPEC.getObjectPadding());
    }

    public static long getSuperClassFieldSize(long fieldsSize) {
        return ObjectSizes.roundTo(fieldsSize, SPEC.getSuperclassFieldPadding());
    }

    public static long getArraySize(int length, long elementSize) {
        return ObjectSizes.roundTo((long)SPEC.getArrayHeaderSize() + (long)length * elementSize, SPEC.getObjectPadding());
    }

    public static long getArraySize(byte[] bytes) {
        return ObjectSizes.getArraySize(bytes.length, 1L);
    }

    public static long getSize(ByteBuffer buffer) {
        long size = 0L;
        size += ObjectSizes.getFieldSize(5L + (long)ObjectSizes.getReferenceSize() + ObjectSizes.getArraySize(buffer.capacity(), 1L));
        return size += ObjectSizes.getSuperClassFieldSize(24L);
    }

    public static long roundTo(long x, int multiple) {
        return (x + (long)multiple - 1L) / (long)multiple * (long)multiple;
    }

    public static int getReferenceSize() {
        return SPEC.getReferenceSize();
    }

    private static MemoryLayoutSpecification getEffectiveMemoryLayoutSpecification() {
        String dataModel = System.getProperty("sun.arch.data.model");
        if ("32".equals(dataModel)) {
            return new MemoryLayoutSpecification(){

                @Override
                public int getArrayHeaderSize() {
                    return 12;
                }

                @Override
                public int getObjectHeaderSize() {
                    return 8;
                }

                @Override
                public int getObjectPadding() {
                    return 8;
                }

                @Override
                public int getReferenceSize() {
                    return 4;
                }

                @Override
                public int getSuperclassFieldPadding() {
                    return 4;
                }
            };
        }
        String strVmVersion = System.getProperty("java.vm.version");
        int vmVersion = Integer.parseInt(strVmVersion.substring(0, strVmVersion.indexOf(46)));
        if (vmVersion >= 17) {
            long maxMemory = 0L;
            for (MemoryPoolMXBean mp : ManagementFactory.getMemoryPoolMXBeans()) {
                maxMemory += mp.getUsage().getMax();
            }
            if (maxMemory < 0x780000000L) {
                return new MemoryLayoutSpecification(){

                    @Override
                    public int getArrayHeaderSize() {
                        return 16;
                    }

                    @Override
                    public int getObjectHeaderSize() {
                        return 12;
                    }

                    @Override
                    public int getObjectPadding() {
                        return 8;
                    }

                    @Override
                    public int getReferenceSize() {
                        return 4;
                    }

                    @Override
                    public int getSuperclassFieldPadding() {
                        return 4;
                    }
                };
            }
        }
        return new MemoryLayoutSpecification(){

            @Override
            public int getArrayHeaderSize() {
                return 24;
            }

            @Override
            public int getObjectHeaderSize() {
                return 16;
            }

            @Override
            public int getObjectPadding() {
                return 8;
            }

            @Override
            public int getReferenceSize() {
                return 8;
            }

            @Override
            public int getSuperclassFieldPadding() {
                return 8;
            }
        };
    }

    public static long measureDeep(Object pojo) {
        return meter.measureDeep(pojo);
    }

    public static interface MemoryLayoutSpecification {
        public int getArrayHeaderSize();

        public int getObjectHeaderSize();

        public int getObjectPadding();

        public int getReferenceSize();

        public int getSuperclassFieldPadding();
    }
}

